/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.context;

import apex.jorje.semantic.ast.context.LocalVariables;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.collect.Queues;
import java.util.Deque;
import org.objectweb.asm.commons.GeneratorAdapter;

public class MethodStack {
    private final Deque<MethodContext> quack = Queues.newArrayDeque();

    public void push(MethodContext method) {
        this.quack.push(method);
    }

    public MethodContext pop() {
        return this.quack.pop();
    }

    public MethodContext peek() {
        return this.quack.peek();
    }

    public boolean isEmpty() {
        return this.quack.isEmpty();
    }

    public void clear() {
        this.quack.clear();
    }

    static final class SuppressCodeLocationsCalculator {
        private static final SuppressCodeLocationsCalculator INSTANCE = new SuppressCodeLocationsCalculator();

        private SuppressCodeLocationsCalculator() {
        }

        static SuppressCodeLocationsCalculator get() {
            return INSTANCE;
        }

        boolean shouldSuppressCodeLocations(MethodInfo methodInfo) {
            return methodInfo.getModifiers().some(ModifierTypeInfos.TEST_METHOD, AnnotationTypeInfos.IS_TEST) || TypeInfoUtil.isTestSetup(methodInfo.getDefiningType()) || methodInfo.getDefiningType().getUnitType() == UnitType.ANONYMOUS && (methodInfo.getName().startsWith("__sfdc__proxy_") || methodInfo.getName().equalsIgnoreCase("execute"));
        }
    }

    public static class MethodContext {
        private final MethodInfo methodInfo;
        private final LocalVariables localVariables;
        private final GeneratorAdapter generatorAdapter;
        private final boolean suppressCodeLocations;
        private TypeInfo pendingBox;
        private TypeInfo pendingUnbox;
        private int jsrCount;

        public MethodContext(MethodInfo methodInfo, GeneratorAdapter generatorAdapter) {
            this.methodInfo = methodInfo;
            this.generatorAdapter = generatorAdapter;
            this.localVariables = new LocalVariables();
            this.pendingBox = null;
            this.pendingUnbox = null;
            this.suppressCodeLocations = SuppressCodeLocationsCalculator.INSTANCE.shouldSuppressCodeLocations(methodInfo);
            this.jsrCount = 0;
        }

        public LocalVariables getLocalVariables() {
            return this.localVariables;
        }

        public MethodInfo getMethodInfo() {
            return this.methodInfo;
        }

        boolean shouldSuppressCodeLocations() {
            return this.suppressCodeLocations;
        }

        GeneratorAdapter getGeneratorAdapter() {
            return this.generatorAdapter;
        }

        TypeInfo getPendingBox() {
            return this.pendingBox;
        }

        void setPendingBox(TypeInfo pendingBox) {
            this.pendingBox = pendingBox;
        }

        TypeInfo getPendingUnbox() {
            return this.pendingUnbox;
        }

        void setPendingUnbox(TypeInfo pendingUnbox) {
            this.pendingUnbox = pendingUnbox;
        }

        void incrementJsrCount() {
            ++this.jsrCount;
        }

        public int getJsrCount() {
            return this.jsrCount;
        }
    }
}

