/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.common.Constants;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.MoreObjects;

public class LocalInfo
implements Variable {
    private final TypeInfo type;
    private final TypeInfo emitType;
    private final Identifier name;
    private final ModifierGroup modifiers;
    private final TypeInfo definingType;
    private int position;
    private boolean isUsedBeforeDefined;
    private MethodInfo methodInfo;

    private LocalInfo(Builder builder) {
        this.type = builder.type;
        this.emitType = builder.emitType;
        this.name = builder.name;
        this.modifiers = builder.modifiers;
        this.definingType = builder.definingType;
        this.position = -1;
        this.isUsedBeforeDefined = false;
        this.methodInfo = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LocalInfo buildThis(TypeInfo classType) {
        ModifierGroup modifiers = ModifierGroup.builder().addModifiers(ModifierTypeInfos.FINAL).build();
        return LocalInfo.builder().setDefiningType(classType).setType(classType).setName("this").setModifiers(modifiers).build();
    }

    @Override
    public String getName() {
        return this.name.getValue();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Member.Type getMemberType() {
        return Member.Type.LOCAL;
    }

    @Override
    public ModifierGroup getModifiers() {
        return this.modifiers;
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public <T, C> T accept(VariableVisitor<T, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public int getPosition(Emitter emitter) {
        MethodInfo newMethodInfo = emitter.getMethodStack().peek().getMethodInfo();
        if (this.position > -1 && newMethodInfo == this.methodInfo) {
            return this.position;
        }
        this.methodInfo = newMethodInfo;
        this.position = emitter.getMethodStack().peek().getLocalVariables().add();
        assert (!Constants.isThis(this.getName()) || this.position == 0) : "'this' variable must be position 0";
        TypeInfo typeToEmit = MoreObjects.firstNonNull(this.emitType, this.type);
        emitter.emitLocalVariable(this.getName(), typeToEmit, this.position);
        return this.position;
    }

    public void setUsedBeforeDefined() {
        this.isUsedBeforeDefined = true;
    }

    public boolean isUsedBeforeDefined() {
        return this.isUsedBeforeDefined;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("type", this.type).add("modifiers", this.modifiers).add("position", this.position).toString();
    }

    public static class Builder {
        private Identifier name;
        private TypeInfo definingType;
        private TypeInfo type;
        private ModifierGroup modifiers;
        private TypeInfo emitType;

        public Builder setName(String name) {
            return this.setName(Identifiers.newIdentifier(name));
        }

        public Builder setName(Identifier name) {
            this.name = name;
            return this;
        }

        public Builder setType(TypeInfo type) {
            this.type = type;
            return this;
        }

        public Builder setDefiningType(TypeInfo definingType) {
            this.definingType = definingType;
            return this;
        }

        public Builder setModifiers(ModifierGroup modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        public Builder setEmitType(TypeInfo emitType) {
            this.emitType = emitType;
            return this;
        }

        public LocalInfo build() {
            assert (this.name != null) : "name not set";
            assert (this.type != null) : "type not set";
            assert (this.modifiers != null) : "modifiers not set";
            assert (this.definingType != null) : "definingType not set";
            return new LocalInfo(this);
        }
    }
}

