/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.document.FileCollector;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.database.DBMSMetadata;
import net.sourceforge.pmd.util.database.DBURI;
import net.sourceforge.pmd.util.database.SourceObject;
import net.sourceforge.pmd.util.datasource.DataSource;
import net.sourceforge.pmd.util.log.MessageReporter;
import net.sourceforge.pmd.util.log.internal.MessageReporterScope;

public final class FileCollectionUtil {
    private FileCollectionUtil() {
    }

    public static List<DataSource> collectorToDataSource(FileCollector collector) {
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        for (TextFile file : collector.getCollectedFiles()) {
            result.add(file.toDataSourceCompat());
        }
        return result;
    }

    @Deprecated
    public static FileCollector collectFiles(PMDConfiguration configuration, Set<Language> languages, MessageReporter reporter) {
        FileCollector collector = FileCollectionUtil.collectFiles(configuration, reporter);
        collector.filterLanguages(languages);
        return collector;
    }

    @Deprecated
    private static FileCollector collectFiles(PMDConfiguration configuration, MessageReporter reporter) {
        FileCollector collector = FileCollector.newCollector(configuration.getLanguageVersionDiscoverer(), reporter);
        FileCollectionUtil.collectFiles(configuration, collector);
        return collector;
    }

    public static void collectFiles(PMDConfiguration configuration, FileCollector collector) {
        boolean legacyShortNamesBehavior;
        if (configuration.getSourceEncoding() != null) {
            collector.setCharset(configuration.getSourceEncoding());
        }
        boolean bl = legacyShortNamesBehavior = configuration.getRelativizeRoots().isEmpty() && configuration.isReportShortNames();
        if (configuration.getInputPaths() != null) {
            for (Path path : configuration.getInputPathList()) {
                try {
                    if (legacyShortNamesBehavior) {
                        collector.relativizeWith(path.toString());
                    }
                    FileCollectionUtil.addRoot(collector, path);
                }
                catch (IOException e) {
                    collector.getReporter().errorEx("Error collecting " + path, e);
                }
            }
        }
        if (configuration.getInputUri() != null) {
            FileCollectionUtil.collectDB(collector, configuration.getInputUri());
        }
        if (configuration.getInputFilePath() != null) {
            FileCollectionUtil.collectFileList(collector, configuration.getInputFilePath());
        }
        if (configuration.getIgnoreFilePath() != null) {
            MessageReporterScope mutedLog = new MessageReporterScope("exclude list", collector.getReporter());
            mutedLog.setLevel(MessageReporter.Level.ERROR);
            try (FileCollector excludeCollector = FileCollector.newCollector(configuration.getLanguageVersionDiscoverer(), mutedLog);){
                FileCollectionUtil.collectFileList(excludeCollector, configuration.getIgnoreFilePath());
                collector.exclude(excludeCollector);
            }
        }
    }

    public static void collectFiles(FileCollector collector, List<String> fileLocations) {
        for (String rootLocation : fileLocations) {
            try {
                FileCollectionUtil.addRoot(collector, Paths.get(rootLocation, new String[0]));
            }
            catch (IOException e) {
                collector.getReporter().errorEx("Error collecting " + rootLocation, e);
            }
        }
    }

    public static void collectFileList(FileCollector collector, String fileListLocation) {
        String filePaths;
        Path path = Paths.get(fileListLocation, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            collector.getReporter().error("No such file {0}", fileListLocation);
            return;
        }
        try {
            filePaths = FileUtil.readFilelist(path.toFile());
        }
        catch (IOException e) {
            collector.getReporter().errorEx("Error reading {0}", new Object[]{fileListLocation}, e);
            return;
        }
        FileCollectionUtil.collectFiles(collector, Arrays.asList(filePaths.split(",")));
    }

    private static void addRoot(FileCollector collector, Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            collector.getReporter().error("No such file {0}", path);
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            collector.addDirectory(path);
        } else if (path.toString().endsWith(".zip") || path.toString().endsWith(".jar")) {
            collector.addZipFileWithContent(path);
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            collector.addFile(path);
        } else {
            collector.getReporter().trace("Ignoring {0}: not a regular file or directory", path);
        }
    }

    public static void collectDB(FileCollector collector, String uriString) {
        try {
            collector.getReporter().trace("Connecting to {0}", uriString);
            DBURI dbUri = new DBURI(uriString);
            DBMSMetadata dbmsMetadata = new DBMSMetadata(dbUri);
            collector.getReporter().trace("DBMSMetadata retrieved", new Object[0]);
            List<SourceObject> sourceObjectList = dbmsMetadata.getSourceObjectList();
            collector.getReporter().trace("Located {0} database source objects", sourceObjectList.size());
            for (SourceObject sourceObject : sourceObjectList) {
                String falseFilePath = sourceObject.getPseudoFileName();
                collector.getReporter().trace("Adding database source object {0}", falseFilePath);
                try {
                    Reader sourceCode = dbmsMetadata.getSourceCode(sourceObject);
                    try {
                        String source = IOUtil.readToString(sourceCode);
                        collector.addSourceFile(source, falseFilePath);
                    }
                    finally {
                        if (sourceCode == null) continue;
                        sourceCode.close();
                    }
                }
                catch (SQLException ex) {
                    collector.getReporter().warnEx("Cannot get SourceCode for {0}  - skipping ...", new Object[]{falseFilePath}, ex);
                }
            }
        }
        catch (ClassNotFoundException e) {
            collector.getReporter().errorEx("Cannot get files from DB - probably missing database JDBC driver", e);
        }
        catch (Exception e) {
            collector.getReporter().errorEx("Cannot get files from DB - ''{0}''", new Object[]{uriString}, e);
        }
    }
}

