/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.typeresolution.PMDASMClassLoader;

public class ClassTypeResolver
extends JavaParserVisitorAdapter {
    private static Map myPrimitiveTypes;
    private static PMDASMClassLoader pmdClassLoader;
    private Map importedClasses;
    private String className;

    public Object visit(ASTCompilationUnit node, Object data) {
        try {
            this.populateClassName(node);
        }
        catch (ClassNotFoundException e) {
            this.populateImports(node);
        }
        return super.visit(node, data);
    }

    private void populateImports(ASTCompilationUnit node) {
        List theImportDeclarations = node.findChildrenOfType(ASTImportDeclaration.class);
        this.importedClasses = new HashMap();
        Iterator anIterator = theImportDeclarations.iterator();
        while (anIterator.hasNext()) {
            ASTImportDeclaration anImportDeclaration = (ASTImportDeclaration)anIterator.next();
            if (anImportDeclaration.isImportOnDemand()) continue;
            String strPackage = anImportDeclaration.getPackageName();
            String strName = anImportDeclaration.getImportedName();
            this.importedClasses.put(strName, strName);
            this.importedClasses.put(strName.substring(strPackage.length() + 1), strName);
        }
        this.importedClasses.put("String", "java.lang.String");
        this.importedClasses.put("Object", "java.lang.Object");
    }

    private void populateClassName(ASTCompilationUnit node) throws ClassNotFoundException {
        ASTClassOrInterfaceDeclaration decl = (ASTClassOrInterfaceDeclaration)node.getFirstChildOfType(ASTClassOrInterfaceDeclaration.class);
        if (decl != null) {
            ASTPackageDeclaration pkgDecl = (ASTPackageDeclaration)node.getFirstChildOfType(ASTPackageDeclaration.class);
            this.className = pkgDecl == null ? decl.getImage() : ((ASTName)pkgDecl.jjtGetChild(0)).getImage() + "." + decl.getImage();
            pmdClassLoader.loadClass(this.className);
            this.importedClasses = pmdClassLoader.getImportedClasses(this.className);
        }
    }

    public Object visit(ASTClassOrInterfaceType node, Object data) {
        String className;
        String qualifiedName = className = node.getImage();
        Class myType = (Class)myPrimitiveTypes.get(className);
        if (myType == null && this.importedClasses != null) {
            if (this.importedClasses.containsKey(className)) {
                qualifiedName = (String)this.importedClasses.get(className);
            } else if (this.importedClasses.containsValue(className)) {
                qualifiedName = className;
            }
            if (qualifiedName != null) {
                try {
                    myType = pmdClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        if (myType != null) {
            node.setType(myType);
        }
        return data;
    }

    static {
        pmdClassLoader = new PMDASMClassLoader();
        HashMap<String, Class<Object>> thePrimitiveTypes = new HashMap<String, Class<Object>>();
        thePrimitiveTypes.put("short", Short.TYPE);
        thePrimitiveTypes.put("byte", Byte.TYPE);
        thePrimitiveTypes.put("char", Character.TYPE);
        thePrimitiveTypes.put("int", Integer.TYPE);
        thePrimitiveTypes.put("long", Long.TYPE);
        thePrimitiveTypes.put("float", Float.TYPE);
        thePrimitiveTypes.put("double", Double.TYPE);
        thePrimitiveTypes.put("boolean", Boolean.TYPE);
        thePrimitiveTypes.put("void", Void.TYPE);
        myPrimitiveTypes = Collections.unmodifiableMap(thePrimitiveTypes);
    }
}

