/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import net.sourceforge.pmd.ast.SimpleNode;

public class SimpleNodeTreeNodeAdapter
implements TreeNode {
    private SimpleNode node;
    private List children;
    private SimpleNodeTreeNodeAdapter parent;

    public SimpleNodeTreeNodeAdapter(SimpleNodeTreeNodeAdapter parent, SimpleNode node) {
        this.parent = parent;
        this.node = node;
    }

    public SimpleNode getSimpleNode() {
        return this.node;
    }

    public TreeNode getChildAt(int childIndex) {
        this.checkChildren();
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.size();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        this.checkChildren();
        return this.children.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        this.checkChildren();
        return this.children.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    private void checkChildren() {
        if (this.children == null) {
            this.children = new ArrayList(this.node.jjtGetNumChildren());
            for (int i = 0; i < this.node.jjtGetNumChildren(); ++i) {
                this.children.add(new SimpleNodeTreeNodeAdapter(this, (SimpleNode)this.node.jjtGetChild(i)));
            }
        }
    }

    public String toString() {
        return this.node.toString();
    }
}

