<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/datastore/entity.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
}
namespace storage_onestore_v3\PropertyValue {
  class PointValue extends \google\net\ProtocolMessage {
    public function getX() {
      if (!isset($this->x)) {
        return 0.0;
      }
      return $this->x;
    }
    public function setX($val) {
      $this->x = $val;
      return $this;
    }
    public function clearX() {
      unset($this->x);
      return $this;
    }
    public function hasX() {
      return isset($this->x);
    }
    public function getY() {
      if (!isset($this->y)) {
        return 0.0;
      }
      return $this->y;
    }
    public function setY($val) {
      $this->y = $val;
      return $this;
    }
    public function clearY() {
      unset($this->y);
      return $this;
    }
    public function hasY() {
      return isset($this->y);
    }
    public function clear() {
      $this->clearX();
      $this->clearY();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->x)) {
        $res += 9;
      }
      if (isset($this->y)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->x)) {
        $out->putVarInt32(49);
        $out->putDouble($this->x);
      }
      if (isset($this->y)) {
        $out->putVarInt32(57);
        $out->putDouble($this->y);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 44: return;
          case 49:
            $this->setX($d->getDouble());
            break;
          case 57:
            $this->setY($d->getDouble());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->x)) return 'x';
      if (!isset($this->y)) return 'y';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasX()) {
        $this->setX($x->getX());
      }
      if ($x->hasY()) {
        $this->setY($x->getY());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->x) !== isset($x->x)) return false;
      if (isset($this->x) && $this->x !== $x->x) return false;
      if (isset($this->y) !== isset($x->y)) return false;
      if (isset($this->y) && $this->y !== $x->y) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->x)) {
        $res .= $prefix . "x: " . $this->debugFormatDouble($this->x) . "\n";
      }
      if (isset($this->y)) {
        $res .= $prefix . "y: " . $this->debugFormatDouble($this->y) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\PropertyValue {
  class UserValue extends \google\net\ProtocolMessage {
    public function getEmail() {
      if (!isset($this->email)) {
        return '';
      }
      return $this->email;
    }
    public function setEmail($val) {
      $this->email = $val;
      return $this;
    }
    public function clearEmail() {
      unset($this->email);
      return $this;
    }
    public function hasEmail() {
      return isset($this->email);
    }
    public function getAuthDomain() {
      if (!isset($this->auth_domain)) {
        return '';
      }
      return $this->auth_domain;
    }
    public function setAuthDomain($val) {
      $this->auth_domain = $val;
      return $this;
    }
    public function clearAuthDomain() {
      unset($this->auth_domain);
      return $this;
    }
    public function hasAuthDomain() {
      return isset($this->auth_domain);
    }
    public function getNickname() {
      if (!isset($this->nickname)) {
        return '';
      }
      return $this->nickname;
    }
    public function setNickname($val) {
      $this->nickname = $val;
      return $this;
    }
    public function clearNickname() {
      unset($this->nickname);
      return $this;
    }
    public function hasNickname() {
      return isset($this->nickname);
    }
    public function getGaiaid() {
      if (!isset($this->gaiaid)) {
        return "0";
      }
      return $this->gaiaid;
    }
    public function setGaiaid($val) {
      if (is_double($val)) {
        $this->gaiaid = sprintf('%0.0F', $val);
      } else {
        $this->gaiaid = $val;
      }
      return $this;
    }
    public function clearGaiaid() {
      unset($this->gaiaid);
      return $this;
    }
    public function hasGaiaid() {
      return isset($this->gaiaid);
    }
    public function getObfuscatedGaiaid() {
      if (!isset($this->obfuscated_gaiaid)) {
        return '';
      }
      return $this->obfuscated_gaiaid;
    }
    public function setObfuscatedGaiaid($val) {
      $this->obfuscated_gaiaid = $val;
      return $this;
    }
    public function clearObfuscatedGaiaid() {
      unset($this->obfuscated_gaiaid);
      return $this;
    }
    public function hasObfuscatedGaiaid() {
      return isset($this->obfuscated_gaiaid);
    }
    public function getFederatedIdentity() {
      if (!isset($this->federated_identity)) {
        return '';
      }
      return $this->federated_identity;
    }
    public function setFederatedIdentity($val) {
      $this->federated_identity = $val;
      return $this;
    }
    public function clearFederatedIdentity() {
      unset($this->federated_identity);
      return $this;
    }
    public function hasFederatedIdentity() {
      return isset($this->federated_identity);
    }
    public function getFederatedProvider() {
      if (!isset($this->federated_provider)) {
        return '';
      }
      return $this->federated_provider;
    }
    public function setFederatedProvider($val) {
      $this->federated_provider = $val;
      return $this;
    }
    public function clearFederatedProvider() {
      unset($this->federated_provider);
      return $this;
    }
    public function hasFederatedProvider() {
      return isset($this->federated_provider);
    }
    public function clear() {
      $this->clearEmail();
      $this->clearAuthDomain();
      $this->clearNickname();
      $this->clearGaiaid();
      $this->clearObfuscatedGaiaid();
      $this->clearFederatedIdentity();
      $this->clearFederatedProvider();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->email)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->email));
      }
      if (isset($this->auth_domain)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->auth_domain));
      }
      if (isset($this->nickname)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->nickname));
      }
      if (isset($this->gaiaid)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->gaiaid);
      }
      if (isset($this->obfuscated_gaiaid)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->obfuscated_gaiaid));
      }
      if (isset($this->federated_identity)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->federated_identity));
      }
      if (isset($this->federated_provider)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->federated_provider));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->email)) {
        $out->putVarInt32(74);
        $out->putPrefixedString($this->email);
      }
      if (isset($this->auth_domain)) {
        $out->putVarInt32(82);
        $out->putPrefixedString($this->auth_domain);
      }
      if (isset($this->nickname)) {
        $out->putVarInt32(90);
        $out->putPrefixedString($this->nickname);
      }
      if (isset($this->gaiaid)) {
        $out->putVarInt32(144);
        $out->putVarInt64($this->gaiaid);
      }
      if (isset($this->obfuscated_gaiaid)) {
        $out->putVarInt32(154);
        $out->putPrefixedString($this->obfuscated_gaiaid);
      }
      if (isset($this->federated_identity)) {
        $out->putVarInt32(170);
        $out->putPrefixedString($this->federated_identity);
      }
      if (isset($this->federated_provider)) {
        $out->putVarInt32(178);
        $out->putPrefixedString($this->federated_provider);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 68: return;
          case 74:
            $length = $d->getVarInt32();
            $this->setEmail(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 82:
            $length = $d->getVarInt32();
            $this->setAuthDomain(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 90:
            $length = $d->getVarInt32();
            $this->setNickname(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 144:
            $this->setGaiaid($d->getVarInt64());
            break;
          case 154:
            $length = $d->getVarInt32();
            $this->setObfuscatedGaiaid(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 170:
            $length = $d->getVarInt32();
            $this->setFederatedIdentity(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 178:
            $length = $d->getVarInt32();
            $this->setFederatedProvider(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->email)) return 'email';
      if (!isset($this->auth_domain)) return 'auth_domain';
      if (!isset($this->gaiaid)) return 'gaiaid';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasEmail()) {
        $this->setEmail($x->getEmail());
      }
      if ($x->hasAuthDomain()) {
        $this->setAuthDomain($x->getAuthDomain());
      }
      if ($x->hasNickname()) {
        $this->setNickname($x->getNickname());
      }
      if ($x->hasGaiaid()) {
        $this->setGaiaid($x->getGaiaid());
      }
      if ($x->hasObfuscatedGaiaid()) {
        $this->setObfuscatedGaiaid($x->getObfuscatedGaiaid());
      }
      if ($x->hasFederatedIdentity()) {
        $this->setFederatedIdentity($x->getFederatedIdentity());
      }
      if ($x->hasFederatedProvider()) {
        $this->setFederatedProvider($x->getFederatedProvider());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->email) !== isset($x->email)) return false;
      if (isset($this->email) && $this->email !== $x->email) return false;
      if (isset($this->auth_domain) !== isset($x->auth_domain)) return false;
      if (isset($this->auth_domain) && $this->auth_domain !== $x->auth_domain) return false;
      if (isset($this->nickname) !== isset($x->nickname)) return false;
      if (isset($this->nickname) && $this->nickname !== $x->nickname) return false;
      if (isset($this->gaiaid) !== isset($x->gaiaid)) return false;
      if (isset($this->gaiaid) && !$this->integerEquals($this->gaiaid, $x->gaiaid)) return false;
      if (isset($this->obfuscated_gaiaid) !== isset($x->obfuscated_gaiaid)) return false;
      if (isset($this->obfuscated_gaiaid) && $this->obfuscated_gaiaid !== $x->obfuscated_gaiaid) return false;
      if (isset($this->federated_identity) !== isset($x->federated_identity)) return false;
      if (isset($this->federated_identity) && $this->federated_identity !== $x->federated_identity) return false;
      if (isset($this->federated_provider) !== isset($x->federated_provider)) return false;
      if (isset($this->federated_provider) && $this->federated_provider !== $x->federated_provider) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->email)) {
        $res .= $prefix . "email: " . $this->debugFormatString($this->email) . "\n";
      }
      if (isset($this->auth_domain)) {
        $res .= $prefix . "auth_domain: " . $this->debugFormatString($this->auth_domain) . "\n";
      }
      if (isset($this->nickname)) {
        $res .= $prefix . "nickname: " . $this->debugFormatString($this->nickname) . "\n";
      }
      if (isset($this->gaiaid)) {
        $res .= $prefix . "gaiaid: " . $this->debugFormatInt64($this->gaiaid) . "\n";
      }
      if (isset($this->obfuscated_gaiaid)) {
        $res .= $prefix . "obfuscated_gaiaid: " . $this->debugFormatString($this->obfuscated_gaiaid) . "\n";
      }
      if (isset($this->federated_identity)) {
        $res .= $prefix . "federated_identity: " . $this->debugFormatString($this->federated_identity) . "\n";
      }
      if (isset($this->federated_provider)) {
        $res .= $prefix . "federated_provider: " . $this->debugFormatString($this->federated_provider) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\PropertyValue\ReferenceValue {
  class PathElement extends \google\net\ProtocolMessage {
    public function getType() {
      if (!isset($this->type)) {
        return '';
      }
      return $this->type;
    }
    public function setType($val) {
      $this->type = $val;
      return $this;
    }
    public function clearType() {
      unset($this->type);
      return $this;
    }
    public function hasType() {
      return isset($this->type);
    }
    public function getId() {
      if (!isset($this->id)) {
        return "0";
      }
      return $this->id;
    }
    public function setId($val) {
      if (is_double($val)) {
        $this->id = sprintf('%0.0F', $val);
      } else {
        $this->id = $val;
      }
      return $this;
    }
    public function clearId() {
      unset($this->id);
      return $this;
    }
    public function hasId() {
      return isset($this->id);
    }
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function clear() {
      $this->clearType();
      $this->clearId();
      $this->clearName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->type)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->type));
      }
      if (isset($this->id)) {
        $res += 2;
        $res += $this->lengthVarInt64($this->id);
      }
      if (isset($this->name)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->type)) {
        $out->putVarInt32(122);
        $out->putPrefixedString($this->type);
      }
      if (isset($this->id)) {
        $out->putVarInt32(128);
        $out->putVarInt64($this->id);
      }
      if (isset($this->name)) {
        $out->putVarInt32(138);
        $out->putPrefixedString($this->name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 116: return;
          case 122:
            $length = $d->getVarInt32();
            $this->setType(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 128:
            $this->setId($d->getVarInt64());
            break;
          case 138:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->type)) return 'type';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasType()) {
        $this->setType($x->getType());
      }
      if ($x->hasId()) {
        $this->setId($x->getId());
      }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->type) !== isset($x->type)) return false;
      if (isset($this->type) && $this->type !== $x->type) return false;
      if (isset($this->id) !== isset($x->id)) return false;
      if (isset($this->id) && !$this->integerEquals($this->id, $x->id)) return false;
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->type)) {
        $res .= $prefix . "type: " . $this->debugFormatString($this->type) . "\n";
      }
      if (isset($this->id)) {
        $res .= $prefix . "id: " . $this->debugFormatInt64($this->id) . "\n";
      }
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\PropertyValue {
  class ReferenceValue extends \google\net\ProtocolMessage {
    private $pathelement = array();
    public function getApp() {
      if (!isset($this->app)) {
        return '';
      }
      return $this->app;
    }
    public function setApp($val) {
      $this->app = $val;
      return $this;
    }
    public function clearApp() {
      unset($this->app);
      return $this;
    }
    public function hasApp() {
      return isset($this->app);
    }
    public function getPathElementSize() {
      return sizeof($this->pathelement);
    }
    public function getPathElementList() {
      return $this->pathelement;
    }
    public function mutablePathElement($idx) {
      if (!isset($this->pathelement[$idx])) {
        $val = new \storage_onestore_v3\PropertyValue\ReferenceValue\PathElement();
        $this->pathelement[$idx] = $val;
        return $val;
      }
      return $this->pathelement[$idx];
    }
    public function getPathElement($idx) {
      if (isset($this->pathelement[$idx])) {
        return $this->pathelement[$idx];
      }
      if ($idx >= end(array_keys($this->pathelement))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\PropertyValue\ReferenceValue\PathElement();
    }
    public function addPathElement() {
      $val = new \storage_onestore_v3\PropertyValue\ReferenceValue\PathElement();
      $this->pathelement[] = $val;
      return $val;
    }
    public function clearPathElement() {
      $this->pathelement = array();
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function clear() {
      $this->clearApp();
      $this->clearPathElement();
      $this->clearNameSpace();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app));
      }
      $this->checkProtoArray($this->pathelement);
      $res += 2 * sizeof($this->pathelement);
      foreach ($this->pathelement as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->name_space)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->name_space));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app)) {
        $out->putVarInt32(106);
        $out->putPrefixedString($this->app);
      }
      $this->checkProtoArray($this->pathelement);
      foreach ($this->pathelement as $value) {
        $out->putVarInt32(115);
        $value->outputPartial($out);
        $out->putVarInt32(116);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(162);
        $out->putPrefixedString($this->name_space);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 100: return;
          case 106:
            $length = $d->getVarInt32();
            $this->setApp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 115:
            $this->addPathElement()->tryMerge($d);
            break;
          case 162:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app)) return 'app';
      foreach ($this->pathelement as $value) {
        if (!$value->isInitialized()) return 'pathelement';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasApp()) {
        $this->setApp($x->getApp());
      }
      foreach ($x->getPathElementList() as $v) {
        $this->addPathElement()->copyFrom($v);
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app) !== isset($x->app)) return false;
      if (isset($this->app) && $this->app !== $x->app) return false;
      if (sizeof($this->pathelement) !== sizeof($x->pathelement)) return false;
      foreach (array_map(null, $this->pathelement, $x->pathelement) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app)) {
        $res .= $prefix . "app: " . $this->debugFormatString($this->app) . "\n";
      }
      foreach ($this->pathelement as $value) {
        $res .= $prefix . "PathElement {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class PropertyValue extends \google\net\ProtocolMessage {
    public function getInt64Value() {
      if (!isset($this->int64Value)) {
        return "0";
      }
      return $this->int64Value;
    }
    public function setInt64Value($val) {
      if (is_double($val)) {
        $this->int64Value = sprintf('%0.0F', $val);
      } else {
        $this->int64Value = $val;
      }
      return $this;
    }
    public function clearInt64Value() {
      unset($this->int64Value);
      return $this;
    }
    public function hasInt64Value() {
      return isset($this->int64Value);
    }
    public function getBooleanvalue() {
      if (!isset($this->booleanValue)) {
        return false;
      }
      return $this->booleanValue;
    }
    public function setBooleanvalue($val) {
      $this->booleanValue = $val;
      return $this;
    }
    public function clearBooleanvalue() {
      unset($this->booleanValue);
      return $this;
    }
    public function hasBooleanvalue() {
      return isset($this->booleanValue);
    }
    public function getStringvalue() {
      if (!isset($this->stringValue)) {
        return '';
      }
      return $this->stringValue;
    }
    public function setStringvalue($val) {
      $this->stringValue = $val;
      return $this;
    }
    public function clearStringvalue() {
      unset($this->stringValue);
      return $this;
    }
    public function hasStringvalue() {
      return isset($this->stringValue);
    }
    public function getDoublevalue() {
      if (!isset($this->doubleValue)) {
        return 0.0;
      }
      return $this->doubleValue;
    }
    public function setDoublevalue($val) {
      $this->doubleValue = $val;
      return $this;
    }
    public function clearDoublevalue() {
      unset($this->doubleValue);
      return $this;
    }
    public function hasDoublevalue() {
      return isset($this->doubleValue);
    }
    public function getPointValue() {
      if (!isset($this->pointvalue)) {
        return new \storage_onestore_v3\PropertyValue\PointValue();
      }
      return $this->pointvalue;
    }
    public function mutablePointValue() {
      if (!isset($this->pointvalue)) {
        $res = new \storage_onestore_v3\PropertyValue\PointValue();
        $this->pointvalue = $res;
        return $res;
      }
      return $this->pointvalue;
    }
    public function clearPointValue() {
      if (isset($this->pointvalue)) {
        unset($this->pointvalue);
      }
    }
    public function hasPointValue() {
      return isset($this->pointvalue);
    }
    public function getUserValue() {
      if (!isset($this->uservalue)) {
        return new \storage_onestore_v3\PropertyValue\UserValue();
      }
      return $this->uservalue;
    }
    public function mutableUserValue() {
      if (!isset($this->uservalue)) {
        $res = new \storage_onestore_v3\PropertyValue\UserValue();
        $this->uservalue = $res;
        return $res;
      }
      return $this->uservalue;
    }
    public function clearUserValue() {
      if (isset($this->uservalue)) {
        unset($this->uservalue);
      }
    }
    public function hasUserValue() {
      return isset($this->uservalue);
    }
    public function getReferenceValue() {
      if (!isset($this->referencevalue)) {
        return new \storage_onestore_v3\PropertyValue\ReferenceValue();
      }
      return $this->referencevalue;
    }
    public function mutableReferenceValue() {
      if (!isset($this->referencevalue)) {
        $res = new \storage_onestore_v3\PropertyValue\ReferenceValue();
        $this->referencevalue = $res;
        return $res;
      }
      return $this->referencevalue;
    }
    public function clearReferenceValue() {
      if (isset($this->referencevalue)) {
        unset($this->referencevalue);
      }
    }
    public function hasReferenceValue() {
      return isset($this->referencevalue);
    }
    public function clear() {
      $this->clearInt64Value();
      $this->clearBooleanvalue();
      $this->clearStringvalue();
      $this->clearDoublevalue();
      $this->clearPointValue();
      $this->clearUserValue();
      $this->clearReferenceValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->int64Value)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->int64Value);
      }
      if (isset($this->booleanValue)) {
        $res += 2;
      }
      if (isset($this->stringValue)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->stringValue));
      }
      if (isset($this->doubleValue)) {
        $res += 9;
      }
      if (isset($this->pointvalue)) {
        $res += 2;
        $res += $this->pointvalue->byteSizePartial();
      }
      if (isset($this->uservalue)) {
        $res += 2;
        $res += $this->uservalue->byteSizePartial();
      }
      if (isset($this->referencevalue)) {
        $res += 2;
        $res += $this->referencevalue->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->int64Value)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->int64Value);
      }
      if (isset($this->booleanValue)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->booleanValue);
      }
      if (isset($this->stringValue)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->stringValue);
      }
      if (isset($this->doubleValue)) {
        $out->putVarInt32(33);
        $out->putDouble($this->doubleValue);
      }
      if (isset($this->pointvalue)) {
        $out->putVarInt32(43);
        $this->pointvalue->outputPartial($out);
        $out->putVarInt32(44);
      }
      if (isset($this->uservalue)) {
        $out->putVarInt32(67);
        $this->uservalue->outputPartial($out);
        $out->putVarInt32(68);
      }
      if (isset($this->referencevalue)) {
        $out->putVarInt32(99);
        $this->referencevalue->outputPartial($out);
        $out->putVarInt32(100);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setInt64Value($d->getVarInt64());
            break;
          case 16:
            $this->setBooleanvalue($d->getBoolean());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setStringvalue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 33:
            $this->setDoublevalue($d->getDouble());
            break;
          case 43:
            $this->mutablePointValue()->tryMerge($d);
            break;
          case 67:
            $this->mutableUserValue()->tryMerge($d);
            break;
          case 99:
            $this->mutableReferenceValue()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (isset($this->pointvalue) && (!$this->pointvalue->isInitialized())) return 'pointvalue';
      if (isset($this->uservalue) && (!$this->uservalue->isInitialized())) return 'uservalue';
      if (isset($this->referencevalue) && (!$this->referencevalue->isInitialized())) return 'referencevalue';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasInt64Value()) {
        $this->setInt64Value($x->getInt64Value());
      }
      if ($x->hasBooleanvalue()) {
        $this->setBooleanvalue($x->getBooleanvalue());
      }
      if ($x->hasStringvalue()) {
        $this->setStringvalue($x->getStringvalue());
      }
      if ($x->hasDoublevalue()) {
        $this->setDoublevalue($x->getDoublevalue());
      }
      if ($x->hasPointValue()) {
        $this->mutablePointValue()->mergeFrom($x->getPointValue());
      }
      if ($x->hasUserValue()) {
        $this->mutableUserValue()->mergeFrom($x->getUserValue());
      }
      if ($x->hasReferenceValue()) {
        $this->mutableReferenceValue()->mergeFrom($x->getReferenceValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->int64Value) !== isset($x->int64Value)) return false;
      if (isset($this->int64Value) && !$this->integerEquals($this->int64Value, $x->int64Value)) return false;
      if (isset($this->booleanValue) !== isset($x->booleanValue)) return false;
      if (isset($this->booleanValue) && $this->booleanValue !== $x->booleanValue) return false;
      if (isset($this->stringValue) !== isset($x->stringValue)) return false;
      if (isset($this->stringValue) && $this->stringValue !== $x->stringValue) return false;
      if (isset($this->doubleValue) !== isset($x->doubleValue)) return false;
      if (isset($this->doubleValue) && $this->doubleValue !== $x->doubleValue) return false;
      if (isset($this->pointvalue) !== isset($x->pointvalue)) return false;
      if (isset($this->pointvalue) && !$this->pointvalue->equals($x->pointvalue)) return false;
      if (isset($this->uservalue) !== isset($x->uservalue)) return false;
      if (isset($this->uservalue) && !$this->uservalue->equals($x->uservalue)) return false;
      if (isset($this->referencevalue) !== isset($x->referencevalue)) return false;
      if (isset($this->referencevalue) && !$this->referencevalue->equals($x->referencevalue)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->int64Value)) {
        $res .= $prefix . "int64Value: " . $this->debugFormatInt64($this->int64Value) . "\n";
      }
      if (isset($this->booleanValue)) {
        $res .= $prefix . "booleanValue: " . $this->debugFormatBool($this->booleanValue) . "\n";
      }
      if (isset($this->stringValue)) {
        $res .= $prefix . "stringValue: " . $this->debugFormatString($this->stringValue) . "\n";
      }
      if (isset($this->doubleValue)) {
        $res .= $prefix . "doubleValue: " . $this->debugFormatDouble($this->doubleValue) . "\n";
      }
      if (isset($this->pointvalue)) {
        $res .= $prefix . "PointValue {\n" . $this->pointvalue->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->uservalue)) {
        $res .= $prefix . "UserValue {\n" . $this->uservalue->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->referencevalue)) {
        $res .= $prefix . "ReferenceValue {\n" . $this->referencevalue->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\Property {
  class Meaning {
    const NO_MEANING = 0;
    const BLOB = 14;
    const TEXT = 15;
    const BYTESTRING = 16;
    const ATOM_CATEGORY = 1;
    const ATOM_LINK = 2;
    const ATOM_TITLE = 3;
    const ATOM_CONTENT = 4;
    const ATOM_SUMMARY = 5;
    const ATOM_AUTHOR = 6;
    const GD_WHEN = 7;
    const GD_EMAIL = 8;
    const GEORSS_POINT = 9;
    const GD_IM = 10;
    const GD_PHONENUMBER = 11;
    const GD_POSTALADDRESS = 12;
    const GD_RATING = 13;
    const BLOBKEY = 17;
    const ENTITY_PROTO = 19;
    const INDEX_VALUE = 18;
  }
}
namespace storage_onestore_v3 {
  class Property extends \google\net\ProtocolMessage {
    public function getMeaning() {
      if (!isset($this->meaning)) {
        return 0;
      }
      return $this->meaning;
    }
    public function setMeaning($val) {
      $this->meaning = $val;
      return $this;
    }
    public function clearMeaning() {
      unset($this->meaning);
      return $this;
    }
    public function hasMeaning() {
      return isset($this->meaning);
    }
    public function getMeaningUri() {
      if (!isset($this->meaning_uri)) {
        return '';
      }
      return $this->meaning_uri;
    }
    public function setMeaningUri($val) {
      $this->meaning_uri = $val;
      return $this;
    }
    public function clearMeaningUri() {
      unset($this->meaning_uri);
      return $this;
    }
    public function hasMeaningUri() {
      return isset($this->meaning_uri);
    }
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function getMultiple() {
      if (!isset($this->multiple)) {
        return false;
      }
      return $this->multiple;
    }
    public function setMultiple($val) {
      $this->multiple = $val;
      return $this;
    }
    public function clearMultiple() {
      unset($this->multiple);
      return $this;
    }
    public function hasMultiple() {
      return isset($this->multiple);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return new \storage_onestore_v3\PropertyValue();
      }
      return $this->value;
    }
    public function mutableValue() {
      if (!isset($this->value)) {
        $res = new \storage_onestore_v3\PropertyValue();
        $this->value = $res;
        return $res;
      }
      return $this->value;
    }
    public function clearValue() {
      if (isset($this->value)) {
        unset($this->value);
      }
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function getEmbedded() {
      if (!isset($this->embedded)) {
        return false;
      }
      return $this->embedded;
    }
    public function setEmbedded($val) {
      $this->embedded = $val;
      return $this;
    }
    public function clearEmbedded() {
      unset($this->embedded);
      return $this;
    }
    public function hasEmbedded() {
      return isset($this->embedded);
    }
    public function clear() {
      $this->clearMeaning();
      $this->clearMeaningUri();
      $this->clearName();
      $this->clearMultiple();
      $this->clearValue();
      $this->clearEmbedded();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->meaning)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->meaning);
      }
      if (isset($this->meaning_uri)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->meaning_uri));
      }
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      if (isset($this->multiple)) {
        $res += 2;
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString($this->value->byteSizePartial());
      }
      if (isset($this->embedded)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->meaning)) {
        $out->putVarInt32(8);
        $out->putVarInt32($this->meaning);
      }
      if (isset($this->meaning_uri)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->meaning_uri);
      }
      if (isset($this->name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->name);
      }
      if (isset($this->multiple)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->multiple);
      }
      if (isset($this->value)) {
        $out->putVarInt32(42);
        $out->putVarInt32($this->value->byteSizePartial());
        $this->value->outputPartial($out);
      }
      if (isset($this->embedded)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->embedded);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setMeaning($d->getVarInt32());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setMeaningUri(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 32:
            $this->setMultiple($d->getBoolean());
            break;
          case 42:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableValue()->tryMerge($tmp);
            break;
          case 48:
            $this->setEmbedded($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->name)) return 'name';
      if (!isset($this->multiple)) return 'multiple';
      if ((!isset($this->value)) || (!$this->value->isInitialized())) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasMeaning()) {
        $this->setMeaning($x->getMeaning());
      }
      if ($x->hasMeaningUri()) {
        $this->setMeaningUri($x->getMeaningUri());
      }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
      if ($x->hasMultiple()) {
        $this->setMultiple($x->getMultiple());
      }
      if ($x->hasValue()) {
        $this->mutableValue()->mergeFrom($x->getValue());
      }
      if ($x->hasEmbedded()) {
        $this->setEmbedded($x->getEmbedded());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->meaning) !== isset($x->meaning)) return false;
      if (isset($this->meaning) && $this->meaning !== $x->meaning) return false;
      if (isset($this->meaning_uri) !== isset($x->meaning_uri)) return false;
      if (isset($this->meaning_uri) && $this->meaning_uri !== $x->meaning_uri) return false;
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      if (isset($this->multiple) !== isset($x->multiple)) return false;
      if (isset($this->multiple) && $this->multiple !== $x->multiple) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && !$this->value->equals($x->value)) return false;
      if (isset($this->embedded) !== isset($x->embedded)) return false;
      if (isset($this->embedded) && $this->embedded !== $x->embedded) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->meaning)) {
        $res .= $prefix . "meaning: " . ($this->meaning) . "\n";
      }
      if (isset($this->meaning_uri)) {
        $res .= $prefix . "meaning_uri: " . $this->debugFormatString($this->meaning_uri) . "\n";
      }
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      if (isset($this->multiple)) {
        $res .= $prefix . "multiple: " . $this->debugFormatBool($this->multiple) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value <\n" . $this->value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->embedded)) {
        $res .= $prefix . "embedded: " . $this->debugFormatBool($this->embedded) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\Path {
  class Element extends \google\net\ProtocolMessage {
    public function getType() {
      if (!isset($this->type)) {
        return '';
      }
      return $this->type;
    }
    public function setType($val) {
      $this->type = $val;
      return $this;
    }
    public function clearType() {
      unset($this->type);
      return $this;
    }
    public function hasType() {
      return isset($this->type);
    }
    public function getId() {
      if (!isset($this->id)) {
        return "0";
      }
      return $this->id;
    }
    public function setId($val) {
      if (is_double($val)) {
        $this->id = sprintf('%0.0F', $val);
      } else {
        $this->id = $val;
      }
      return $this;
    }
    public function clearId() {
      unset($this->id);
      return $this;
    }
    public function hasId() {
      return isset($this->id);
    }
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function clear() {
      $this->clearType();
      $this->clearId();
      $this->clearName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->type)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->type));
      }
      if (isset($this->id)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->id);
      }
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->type)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->type);
      }
      if (isset($this->id)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->id);
      }
      if (isset($this->name)) {
        $out->putVarInt32(34);
        $out->putPrefixedString($this->name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 12: return;
          case 18:
            $length = $d->getVarInt32();
            $this->setType(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setId($d->getVarInt64());
            break;
          case 34:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->type)) return 'type';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasType()) {
        $this->setType($x->getType());
      }
      if ($x->hasId()) {
        $this->setId($x->getId());
      }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->type) !== isset($x->type)) return false;
      if (isset($this->type) && $this->type !== $x->type) return false;
      if (isset($this->id) !== isset($x->id)) return false;
      if (isset($this->id) && !$this->integerEquals($this->id, $x->id)) return false;
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->type)) {
        $res .= $prefix . "type: " . $this->debugFormatString($this->type) . "\n";
      }
      if (isset($this->id)) {
        $res .= $prefix . "id: " . $this->debugFormatInt64($this->id) . "\n";
      }
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class Path extends \google\net\ProtocolMessage {
    private $element = array();
    public function getElementSize() {
      return sizeof($this->element);
    }
    public function getElementList() {
      return $this->element;
    }
    public function mutableElement($idx) {
      if (!isset($this->element[$idx])) {
        $val = new \storage_onestore_v3\Path\Element();
        $this->element[$idx] = $val;
        return $val;
      }
      return $this->element[$idx];
    }
    public function getElement($idx) {
      if (isset($this->element[$idx])) {
        return $this->element[$idx];
      }
      if ($idx >= end(array_keys($this->element))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Path\Element();
    }
    public function addElement() {
      $val = new \storage_onestore_v3\Path\Element();
      $this->element[] = $val;
      return $val;
    }
    public function clearElement() {
      $this->element = array();
    }
    public function clear() {
      $this->clearElement();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->element);
      $res += 2 * sizeof($this->element);
      foreach ($this->element as $value) {
        $res += $value->byteSizePartial();
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->element);
      foreach ($this->element as $value) {
        $out->putVarInt32(11);
        $value->outputPartial($out);
        $out->putVarInt32(12);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 11:
            $this->addElement()->tryMerge($d);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->element as $value) {
        if (!$value->isInitialized()) return 'element';
      }
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getElementList() as $v) {
        $this->addElement()->copyFrom($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->element) !== sizeof($x->element)) return false;
      foreach (array_map(null, $this->element, $x->element) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->element as $value) {
        $res .= $prefix . "Element {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class Reference extends \google\net\ProtocolMessage {
    public function getApp() {
      if (!isset($this->app)) {
        return '';
      }
      return $this->app;
    }
    public function setApp($val) {
      $this->app = $val;
      return $this;
    }
    public function clearApp() {
      unset($this->app);
      return $this;
    }
    public function hasApp() {
      return isset($this->app);
    }
    public function getPath() {
      if (!isset($this->path)) {
        return new \storage_onestore_v3\Path();
      }
      return $this->path;
    }
    public function mutablePath() {
      if (!isset($this->path)) {
        $res = new \storage_onestore_v3\Path();
        $this->path = $res;
        return $res;
      }
      return $this->path;
    }
    public function clearPath() {
      if (isset($this->path)) {
        unset($this->path);
      }
    }
    public function hasPath() {
      return isset($this->path);
    }
    public function getNameSpace() {
      if (!isset($this->name_space)) {
        return '';
      }
      return $this->name_space;
    }
    public function setNameSpace($val) {
      $this->name_space = $val;
      return $this;
    }
    public function clearNameSpace() {
      unset($this->name_space);
      return $this;
    }
    public function hasNameSpace() {
      return isset($this->name_space);
    }
    public function clear() {
      $this->clearApp();
      $this->clearPath();
      $this->clearNameSpace();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app));
      }
      if (isset($this->path)) {
        $res += 1;
        $res += $this->lengthString($this->path->byteSizePartial());
      }
      if (isset($this->name_space)) {
        $res += 2;
        $res += $this->lengthString(strlen($this->name_space));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app)) {
        $out->putVarInt32(106);
        $out->putPrefixedString($this->app);
      }
      if (isset($this->path)) {
        $out->putVarInt32(114);
        $out->putVarInt32($this->path->byteSizePartial());
        $this->path->outputPartial($out);
      }
      if (isset($this->name_space)) {
        $out->putVarInt32(162);
        $out->putPrefixedString($this->name_space);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 106:
            $length = $d->getVarInt32();
            $this->setApp(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 114:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePath()->tryMerge($tmp);
            break;
          case 162:
            $length = $d->getVarInt32();
            $this->setNameSpace(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app)) return 'app';
      if ((!isset($this->path)) || (!$this->path->isInitialized())) return 'path';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasApp()) {
        $this->setApp($x->getApp());
      }
      if ($x->hasPath()) {
        $this->mutablePath()->mergeFrom($x->getPath());
      }
      if ($x->hasNameSpace()) {
        $this->setNameSpace($x->getNameSpace());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app) !== isset($x->app)) return false;
      if (isset($this->app) && $this->app !== $x->app) return false;
      if (isset($this->path) !== isset($x->path)) return false;
      if (isset($this->path) && !$this->path->equals($x->path)) return false;
      if (isset($this->name_space) !== isset($x->name_space)) return false;
      if (isset($this->name_space) && $this->name_space !== $x->name_space) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app)) {
        $res .= $prefix . "app: " . $this->debugFormatString($this->app) . "\n";
      }
      if (isset($this->path)) {
        $res .= $prefix . "path <\n" . $this->path->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->name_space)) {
        $res .= $prefix . "name_space: " . $this->debugFormatString($this->name_space) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class User extends \google\net\ProtocolMessage {
    public function getEmail() {
      if (!isset($this->email)) {
        return '';
      }
      return $this->email;
    }
    public function setEmail($val) {
      $this->email = $val;
      return $this;
    }
    public function clearEmail() {
      unset($this->email);
      return $this;
    }
    public function hasEmail() {
      return isset($this->email);
    }
    public function getAuthDomain() {
      if (!isset($this->auth_domain)) {
        return '';
      }
      return $this->auth_domain;
    }
    public function setAuthDomain($val) {
      $this->auth_domain = $val;
      return $this;
    }
    public function clearAuthDomain() {
      unset($this->auth_domain);
      return $this;
    }
    public function hasAuthDomain() {
      return isset($this->auth_domain);
    }
    public function getNickname() {
      if (!isset($this->nickname)) {
        return '';
      }
      return $this->nickname;
    }
    public function setNickname($val) {
      $this->nickname = $val;
      return $this;
    }
    public function clearNickname() {
      unset($this->nickname);
      return $this;
    }
    public function hasNickname() {
      return isset($this->nickname);
    }
    public function getGaiaid() {
      if (!isset($this->gaiaid)) {
        return "0";
      }
      return $this->gaiaid;
    }
    public function setGaiaid($val) {
      if (is_double($val)) {
        $this->gaiaid = sprintf('%0.0F', $val);
      } else {
        $this->gaiaid = $val;
      }
      return $this;
    }
    public function clearGaiaid() {
      unset($this->gaiaid);
      return $this;
    }
    public function hasGaiaid() {
      return isset($this->gaiaid);
    }
    public function getObfuscatedGaiaid() {
      if (!isset($this->obfuscated_gaiaid)) {
        return '';
      }
      return $this->obfuscated_gaiaid;
    }
    public function setObfuscatedGaiaid($val) {
      $this->obfuscated_gaiaid = $val;
      return $this;
    }
    public function clearObfuscatedGaiaid() {
      unset($this->obfuscated_gaiaid);
      return $this;
    }
    public function hasObfuscatedGaiaid() {
      return isset($this->obfuscated_gaiaid);
    }
    public function getFederatedIdentity() {
      if (!isset($this->federated_identity)) {
        return '';
      }
      return $this->federated_identity;
    }
    public function setFederatedIdentity($val) {
      $this->federated_identity = $val;
      return $this;
    }
    public function clearFederatedIdentity() {
      unset($this->federated_identity);
      return $this;
    }
    public function hasFederatedIdentity() {
      return isset($this->federated_identity);
    }
    public function getFederatedProvider() {
      if (!isset($this->federated_provider)) {
        return '';
      }
      return $this->federated_provider;
    }
    public function setFederatedProvider($val) {
      $this->federated_provider = $val;
      return $this;
    }
    public function clearFederatedProvider() {
      unset($this->federated_provider);
      return $this;
    }
    public function hasFederatedProvider() {
      return isset($this->federated_provider);
    }
    public function clear() {
      $this->clearEmail();
      $this->clearAuthDomain();
      $this->clearNickname();
      $this->clearGaiaid();
      $this->clearObfuscatedGaiaid();
      $this->clearFederatedIdentity();
      $this->clearFederatedProvider();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->email)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->email));
      }
      if (isset($this->auth_domain)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->auth_domain));
      }
      if (isset($this->nickname)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->nickname));
      }
      if (isset($this->gaiaid)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->gaiaid);
      }
      if (isset($this->obfuscated_gaiaid)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->obfuscated_gaiaid));
      }
      if (isset($this->federated_identity)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->federated_identity));
      }
      if (isset($this->federated_provider)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->federated_provider));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->email)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->email);
      }
      if (isset($this->auth_domain)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->auth_domain);
      }
      if (isset($this->nickname)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->nickname);
      }
      if (isset($this->gaiaid)) {
        $out->putVarInt32(32);
        $out->putVarInt64($this->gaiaid);
      }
      if (isset($this->obfuscated_gaiaid)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->obfuscated_gaiaid);
      }
      if (isset($this->federated_identity)) {
        $out->putVarInt32(50);
        $out->putPrefixedString($this->federated_identity);
      }
      if (isset($this->federated_provider)) {
        $out->putVarInt32(58);
        $out->putPrefixedString($this->federated_provider);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setEmail(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setAuthDomain(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setNickname(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 32:
            $this->setGaiaid($d->getVarInt64());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setObfuscatedGaiaid(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 50:
            $length = $d->getVarInt32();
            $this->setFederatedIdentity(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 58:
            $length = $d->getVarInt32();
            $this->setFederatedProvider(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->email)) return 'email';
      if (!isset($this->auth_domain)) return 'auth_domain';
      if (!isset($this->gaiaid)) return 'gaiaid';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasEmail()) {
        $this->setEmail($x->getEmail());
      }
      if ($x->hasAuthDomain()) {
        $this->setAuthDomain($x->getAuthDomain());
      }
      if ($x->hasNickname()) {
        $this->setNickname($x->getNickname());
      }
      if ($x->hasGaiaid()) {
        $this->setGaiaid($x->getGaiaid());
      }
      if ($x->hasObfuscatedGaiaid()) {
        $this->setObfuscatedGaiaid($x->getObfuscatedGaiaid());
      }
      if ($x->hasFederatedIdentity()) {
        $this->setFederatedIdentity($x->getFederatedIdentity());
      }
      if ($x->hasFederatedProvider()) {
        $this->setFederatedProvider($x->getFederatedProvider());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->email) !== isset($x->email)) return false;
      if (isset($this->email) && $this->email !== $x->email) return false;
      if (isset($this->auth_domain) !== isset($x->auth_domain)) return false;
      if (isset($this->auth_domain) && $this->auth_domain !== $x->auth_domain) return false;
      if (isset($this->nickname) !== isset($x->nickname)) return false;
      if (isset($this->nickname) && $this->nickname !== $x->nickname) return false;
      if (isset($this->gaiaid) !== isset($x->gaiaid)) return false;
      if (isset($this->gaiaid) && !$this->integerEquals($this->gaiaid, $x->gaiaid)) return false;
      if (isset($this->obfuscated_gaiaid) !== isset($x->obfuscated_gaiaid)) return false;
      if (isset($this->obfuscated_gaiaid) && $this->obfuscated_gaiaid !== $x->obfuscated_gaiaid) return false;
      if (isset($this->federated_identity) !== isset($x->federated_identity)) return false;
      if (isset($this->federated_identity) && $this->federated_identity !== $x->federated_identity) return false;
      if (isset($this->federated_provider) !== isset($x->federated_provider)) return false;
      if (isset($this->federated_provider) && $this->federated_provider !== $x->federated_provider) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->email)) {
        $res .= $prefix . "email: " . $this->debugFormatString($this->email) . "\n";
      }
      if (isset($this->auth_domain)) {
        $res .= $prefix . "auth_domain: " . $this->debugFormatString($this->auth_domain) . "\n";
      }
      if (isset($this->nickname)) {
        $res .= $prefix . "nickname: " . $this->debugFormatString($this->nickname) . "\n";
      }
      if (isset($this->gaiaid)) {
        $res .= $prefix . "gaiaid: " . $this->debugFormatInt64($this->gaiaid) . "\n";
      }
      if (isset($this->obfuscated_gaiaid)) {
        $res .= $prefix . "obfuscated_gaiaid: " . $this->debugFormatString($this->obfuscated_gaiaid) . "\n";
      }
      if (isset($this->federated_identity)) {
        $res .= $prefix . "federated_identity: " . $this->debugFormatString($this->federated_identity) . "\n";
      }
      if (isset($this->federated_provider)) {
        $res .= $prefix . "federated_provider: " . $this->debugFormatString($this->federated_provider) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\EntityProto {
  class Kind {
    const GD_CONTACT = 1;
    const GD_EVENT = 2;
    const GD_MESSAGE = 3;
  }
}
namespace storage_onestore_v3 {
  class EntityProto extends \google\net\ProtocolMessage {
    private $property = array();
    private $raw_property = array();
    public function getKind() {
      if (!isset($this->kind)) {
        return 1;
      }
      return $this->kind;
    }
    public function setKind($val) {
      $this->kind = $val;
      return $this;
    }
    public function clearKind() {
      unset($this->kind);
      return $this;
    }
    public function hasKind() {
      return isset($this->kind);
    }
    public function getKindUri() {
      if (!isset($this->kind_uri)) {
        return '';
      }
      return $this->kind_uri;
    }
    public function setKindUri($val) {
      $this->kind_uri = $val;
      return $this;
    }
    public function clearKindUri() {
      unset($this->kind_uri);
      return $this;
    }
    public function hasKindUri() {
      return isset($this->kind_uri);
    }
    public function getKey() {
      if (!isset($this->key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getPropertySize() {
      return sizeof($this->property);
    }
    public function getPropertyList() {
      return $this->property;
    }
    public function mutableProperty($idx) {
      if (!isset($this->property[$idx])) {
        $val = new \storage_onestore_v3\Property();
        $this->property[$idx] = $val;
        return $val;
      }
      return $this->property[$idx];
    }
    public function getProperty($idx) {
      if (isset($this->property[$idx])) {
        return $this->property[$idx];
      }
      if ($idx >= end(array_keys($this->property))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Property();
    }
    public function addProperty() {
      $val = new \storage_onestore_v3\Property();
      $this->property[] = $val;
      return $val;
    }
    public function clearProperty() {
      $this->property = array();
    }
    public function getRawPropertySize() {
      return sizeof($this->raw_property);
    }
    public function getRawPropertyList() {
      return $this->raw_property;
    }
    public function mutableRawProperty($idx) {
      if (!isset($this->raw_property[$idx])) {
        $val = new \storage_onestore_v3\Property();
        $this->raw_property[$idx] = $val;
        return $val;
      }
      return $this->raw_property[$idx];
    }
    public function getRawProperty($idx) {
      if (isset($this->raw_property[$idx])) {
        return $this->raw_property[$idx];
      }
      if ($idx >= end(array_keys($this->raw_property))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Property();
    }
    public function addRawProperty() {
      $val = new \storage_onestore_v3\Property();
      $this->raw_property[] = $val;
      return $val;
    }
    public function clearRawProperty() {
      $this->raw_property = array();
    }
    public function getEntityGroup() {
      if (!isset($this->entity_group)) {
        return new \storage_onestore_v3\Path();
      }
      return $this->entity_group;
    }
    public function mutableEntityGroup() {
      if (!isset($this->entity_group)) {
        $res = new \storage_onestore_v3\Path();
        $this->entity_group = $res;
        return $res;
      }
      return $this->entity_group;
    }
    public function clearEntityGroup() {
      if (isset($this->entity_group)) {
        unset($this->entity_group);
      }
    }
    public function hasEntityGroup() {
      return isset($this->entity_group);
    }
    public function getOwner() {
      if (!isset($this->owner)) {
        return new \storage_onestore_v3\User();
      }
      return $this->owner;
    }
    public function mutableOwner() {
      if (!isset($this->owner)) {
        $res = new \storage_onestore_v3\User();
        $this->owner = $res;
        return $res;
      }
      return $this->owner;
    }
    public function clearOwner() {
      if (isset($this->owner)) {
        unset($this->owner);
      }
    }
    public function hasOwner() {
      return isset($this->owner);
    }
    public function clear() {
      $this->clearKind();
      $this->clearKindUri();
      $this->clearKey();
      $this->clearProperty();
      $this->clearRawProperty();
      $this->clearEntityGroup();
      $this->clearOwner();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->kind)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->kind);
      }
      if (isset($this->kind_uri)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->kind_uri));
      }
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      $this->checkProtoArray($this->property);
      $res += 1 * sizeof($this->property);
      foreach ($this->property as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      $this->checkProtoArray($this->raw_property);
      $res += 1 * sizeof($this->raw_property);
      foreach ($this->raw_property as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->entity_group)) {
        $res += 2;
        $res += $this->lengthString($this->entity_group->byteSizePartial());
      }
      if (isset($this->owner)) {
        $res += 2;
        $res += $this->lengthString($this->owner->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->kind)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->kind);
      }
      if (isset($this->kind_uri)) {
        $out->putVarInt32(42);
        $out->putPrefixedString($this->kind_uri);
      }
      if (isset($this->key)) {
        $out->putVarInt32(106);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      $this->checkProtoArray($this->property);
      foreach ($this->property as $value) {
        $out->putVarInt32(114);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      $this->checkProtoArray($this->raw_property);
      foreach ($this->raw_property as $value) {
        $out->putVarInt32(122);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->entity_group)) {
        $out->putVarInt32(130);
        $out->putVarInt32($this->entity_group->byteSizePartial());
        $this->entity_group->outputPartial($out);
      }
      if (isset($this->owner)) {
        $out->putVarInt32(138);
        $out->putVarInt32($this->owner->byteSizePartial());
        $this->owner->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 32:
            $this->setKind($d->getVarInt32());
            break;
          case 42:
            $length = $d->getVarInt32();
            $this->setKindUri(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 106:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 114:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addProperty()->tryMerge($tmp);
            break;
          case 122:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addRawProperty()->tryMerge($tmp);
            break;
          case 130:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableEntityGroup()->tryMerge($tmp);
            break;
          case 138:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableOwner()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if ((!isset($this->key)) || (!$this->key->isInitialized())) return 'key';
      foreach ($this->property as $value) {
        if (!$value->isInitialized()) return 'property';
      }
      foreach ($this->raw_property as $value) {
        if (!$value->isInitialized()) return 'raw_property';
      }
      if ((!isset($this->entity_group)) || (!$this->entity_group->isInitialized())) return 'entity_group';
      if (isset($this->owner) && (!$this->owner->isInitialized())) return 'owner';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKind()) {
        $this->setKind($x->getKind());
      }
      if ($x->hasKindUri()) {
        $this->setKindUri($x->getKindUri());
      }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      foreach ($x->getPropertyList() as $v) {
        $this->addProperty()->copyFrom($v);
      }
      foreach ($x->getRawPropertyList() as $v) {
        $this->addRawProperty()->copyFrom($v);
      }
      if ($x->hasEntityGroup()) {
        $this->mutableEntityGroup()->mergeFrom($x->getEntityGroup());
      }
      if ($x->hasOwner()) {
        $this->mutableOwner()->mergeFrom($x->getOwner());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->kind) !== isset($x->kind)) return false;
      if (isset($this->kind) && $this->kind !== $x->kind) return false;
      if (isset($this->kind_uri) !== isset($x->kind_uri)) return false;
      if (isset($this->kind_uri) && $this->kind_uri !== $x->kind_uri) return false;
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (sizeof($this->property) !== sizeof($x->property)) return false;
      foreach (array_map(null, $this->property, $x->property) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (sizeof($this->raw_property) !== sizeof($x->raw_property)) return false;
      foreach (array_map(null, $this->raw_property, $x->raw_property) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->entity_group) !== isset($x->entity_group)) return false;
      if (isset($this->entity_group) && !$this->entity_group->equals($x->entity_group)) return false;
      if (isset($this->owner) !== isset($x->owner)) return false;
      if (isset($this->owner) && !$this->owner->equals($x->owner)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->kind)) {
        $res .= $prefix . "kind: " . ($this->kind) . "\n";
      }
      if (isset($this->kind_uri)) {
        $res .= $prefix . "kind_uri: " . $this->debugFormatString($this->kind_uri) . "\n";
      }
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->property as $value) {
        $res .= $prefix . "property <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      foreach ($this->raw_property as $value) {
        $res .= $prefix . "raw_property <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->entity_group)) {
        $res .= $prefix . "entity_group <\n" . $this->entity_group->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->owner)) {
        $res .= $prefix . "owner <\n" . $this->owner->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class CompositeProperty extends \google\net\ProtocolMessage {
    private $value = array();
    public function getIndexId() {
      if (!isset($this->index_id)) {
        return "0";
      }
      return $this->index_id;
    }
    public function setIndexId($val) {
      if (is_double($val)) {
        $this->index_id = sprintf('%0.0F', $val);
      } else {
        $this->index_id = $val;
      }
      return $this;
    }
    public function clearIndexId() {
      unset($this->index_id);
      return $this;
    }
    public function hasIndexId() {
      return isset($this->index_id);
    }
    public function getValueSize() {
      return sizeof($this->value);
    }
    public function getValueList() {
      return $this->value;
    }
    public function getValue($idx) {
      return $this->value[$idx];
    }
    public function setValue($idx, $val) {
      $this->value[$idx] = $val;
      return $this;
    }
    public function addValue($val) {
      $this->value[] = $val;
      return $this;
    }
    public function clearValue() {
      $this->value = array();
    }
    public function clear() {
      $this->clearIndexId();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_id)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_id);
      }
      $this->checkProtoArray($this->value);
      $res += 1 * sizeof($this->value);
      foreach ($this->value as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_id)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->index_id);
      }
      $this->checkProtoArray($this->value);
      foreach ($this->value as $value) {
        $out->putVarInt32(18);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setIndexId($d->getVarInt64());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->addValue(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->index_id)) return 'index_id';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexId()) {
        $this->setIndexId($x->getIndexId());
      }
      foreach ($x->getValueList() as $v) {
        $this->addValue($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_id) !== isset($x->index_id)) return false;
      if (isset($this->index_id) && !$this->integerEquals($this->index_id, $x->index_id)) return false;
      if (sizeof($this->value) !== sizeof($x->value)) return false;
      foreach (array_map(null, $this->value, $x->value) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_id)) {
        $res .= $prefix . "index_id: " . $this->debugFormatInt64($this->index_id) . "\n";
      }
      foreach ($this->value as $value) {
        $res .= $prefix . "value: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\Index\Property {
  class Direction {
    const DIRECTION_UNSPECIFIED = 0;
    const ASCENDING = 1;
    const DESCENDING = 2;
  }
}
namespace storage_onestore_v3\Index\Property {
  class Mode {
    const MODE_UNSPECIFIED = 0;
    const GEOSPATIAL = 3;
  }
}
namespace storage_onestore_v3\Index {
  class Property extends \google\net\ProtocolMessage {
    public function getName() {
      if (!isset($this->name)) {
        return '';
      }
      return $this->name;
    }
    public function setName($val) {
      $this->name = $val;
      return $this;
    }
    public function clearName() {
      unset($this->name);
      return $this;
    }
    public function hasName() {
      return isset($this->name);
    }
    public function getDirection() {
      if (!isset($this->direction)) {
        return 0;
      }
      return $this->direction;
    }
    public function setDirection($val) {
      $this->direction = $val;
      return $this;
    }
    public function clearDirection() {
      unset($this->direction);
      return $this;
    }
    public function hasDirection() {
      return isset($this->direction);
    }
    public function getMode() {
      if (!isset($this->mode)) {
        return 0;
      }
      return $this->mode;
    }
    public function setMode($val) {
      $this->mode = $val;
      return $this;
    }
    public function clearMode() {
      unset($this->mode);
      return $this;
    }
    public function hasMode() {
      return isset($this->mode);
    }
    public function clear() {
      $this->clearName();
      $this->clearDirection();
      $this->clearMode();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->name));
      }
      if (isset($this->direction)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->direction);
      }
      if (isset($this->mode)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->mode);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->name);
      }
      if (isset($this->direction)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->direction);
      }
      if (isset($this->mode)) {
        $out->putVarInt32(48);
        $out->putVarInt32($this->mode);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 20: return;
          case 26:
            $length = $d->getVarInt32();
            $this->setName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 32:
            $this->setDirection($d->getVarInt32());
            break;
          case 48:
            $this->setMode($d->getVarInt32());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->name)) return 'name';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasName()) {
        $this->setName($x->getName());
      }
      if ($x->hasDirection()) {
        $this->setDirection($x->getDirection());
      }
      if ($x->hasMode()) {
        $this->setMode($x->getMode());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->name) !== isset($x->name)) return false;
      if (isset($this->name) && $this->name !== $x->name) return false;
      if (isset($this->direction) !== isset($x->direction)) return false;
      if (isset($this->direction) && $this->direction !== $x->direction) return false;
      if (isset($this->mode) !== isset($x->mode)) return false;
      if (isset($this->mode) && $this->mode !== $x->mode) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->name)) {
        $res .= $prefix . "name: " . $this->debugFormatString($this->name) . "\n";
      }
      if (isset($this->direction)) {
        $res .= $prefix . "direction: " . ($this->direction) . "\n";
      }
      if (isset($this->mode)) {
        $res .= $prefix . "mode: " . ($this->mode) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class Index extends \google\net\ProtocolMessage {
    private $property = array();
    public function getEntityType() {
      if (!isset($this->entity_type)) {
        return '';
      }
      return $this->entity_type;
    }
    public function setEntityType($val) {
      $this->entity_type = $val;
      return $this;
    }
    public function clearEntityType() {
      unset($this->entity_type);
      return $this;
    }
    public function hasEntityType() {
      return isset($this->entity_type);
    }
    public function getPropertySize() {
      return sizeof($this->property);
    }
    public function getPropertyList() {
      return $this->property;
    }
    public function mutableProperty($idx) {
      if (!isset($this->property[$idx])) {
        $val = new \storage_onestore_v3\Index\Property();
        $this->property[$idx] = $val;
        return $val;
      }
      return $this->property[$idx];
    }
    public function getProperty($idx) {
      if (isset($this->property[$idx])) {
        return $this->property[$idx];
      }
      if ($idx >= end(array_keys($this->property))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\Index\Property();
    }
    public function addProperty() {
      $val = new \storage_onestore_v3\Index\Property();
      $this->property[] = $val;
      return $val;
    }
    public function clearProperty() {
      $this->property = array();
    }
    public function getAncestor() {
      if (!isset($this->ancestor)) {
        return false;
      }
      return $this->ancestor;
    }
    public function setAncestor($val) {
      $this->ancestor = $val;
      return $this;
    }
    public function clearAncestor() {
      unset($this->ancestor);
      return $this;
    }
    public function hasAncestor() {
      return isset($this->ancestor);
    }
    public function clear() {
      $this->clearEntityType();
      $this->clearProperty();
      $this->clearAncestor();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->entity_type)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->entity_type));
      }
      $this->checkProtoArray($this->property);
      $res += 2 * sizeof($this->property);
      foreach ($this->property as $value) {
        $res += $value->byteSizePartial();
      }
      if (isset($this->ancestor)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->entity_type)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->entity_type);
      }
      $this->checkProtoArray($this->property);
      foreach ($this->property as $value) {
        $out->putVarInt32(19);
        $value->outputPartial($out);
        $out->putVarInt32(20);
      }
      if (isset($this->ancestor)) {
        $out->putVarInt32(40);
        $out->putBoolean($this->ancestor);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setEntityType(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 19:
            $this->addProperty()->tryMerge($d);
            break;
          case 40:
            $this->setAncestor($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->entity_type)) return 'entity_type';
      foreach ($this->property as $value) {
        if (!$value->isInitialized()) return 'property';
      }
      if (!isset($this->ancestor)) return 'ancestor';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasEntityType()) {
        $this->setEntityType($x->getEntityType());
      }
      foreach ($x->getPropertyList() as $v) {
        $this->addProperty()->copyFrom($v);
      }
      if ($x->hasAncestor()) {
        $this->setAncestor($x->getAncestor());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->entity_type) !== isset($x->entity_type)) return false;
      if (isset($this->entity_type) && $this->entity_type !== $x->entity_type) return false;
      if (sizeof($this->property) !== sizeof($x->property)) return false;
      foreach (array_map(null, $this->property, $x->property) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->ancestor) !== isset($x->ancestor)) return false;
      if (isset($this->ancestor) && $this->ancestor !== $x->ancestor) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->entity_type)) {
        $res .= $prefix . "entity_type: " . $this->debugFormatString($this->entity_type) . "\n";
      }
      foreach ($this->property as $value) {
        $res .= $prefix . "Property {\n" . $value->shortDebugString($prefix . "  ") . $prefix . "}\n";
      }
      if (isset($this->ancestor)) {
        $res .= $prefix . "ancestor: " . $this->debugFormatBool($this->ancestor) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\CompositeIndex {
  class State {
    const WRITE_ONLY = 1;
    const READ_WRITE = 2;
    const DELETED = 3;
    const ERROR = 4;
  }
}
namespace storage_onestore_v3\CompositeIndex {
  class WorkflowState {
    const PENDING = 1;
    const ACTIVE = 2;
    const COMPLETED = 3;
  }
}
namespace storage_onestore_v3 {
  class CompositeIndex extends \google\net\ProtocolMessage {
    private $read_division_family = array();
    public function getAppId() {
      if (!isset($this->app_id)) {
        return '';
      }
      return $this->app_id;
    }
    public function setAppId($val) {
      $this->app_id = $val;
      return $this;
    }
    public function clearAppId() {
      unset($this->app_id);
      return $this;
    }
    public function hasAppId() {
      return isset($this->app_id);
    }
    public function getId() {
      if (!isset($this->id)) {
        return "0";
      }
      return $this->id;
    }
    public function setId($val) {
      if (is_double($val)) {
        $this->id = sprintf('%0.0F', $val);
      } else {
        $this->id = $val;
      }
      return $this;
    }
    public function clearId() {
      unset($this->id);
      return $this;
    }
    public function hasId() {
      return isset($this->id);
    }
    public function getDefinition() {
      if (!isset($this->definition)) {
        return new \storage_onestore_v3\Index();
      }
      return $this->definition;
    }
    public function mutableDefinition() {
      if (!isset($this->definition)) {
        $res = new \storage_onestore_v3\Index();
        $this->definition = $res;
        return $res;
      }
      return $this->definition;
    }
    public function clearDefinition() {
      if (isset($this->definition)) {
        unset($this->definition);
      }
    }
    public function hasDefinition() {
      return isset($this->definition);
    }
    public function getState() {
      if (!isset($this->state)) {
        return 1;
      }
      return $this->state;
    }
    public function setState($val) {
      $this->state = $val;
      return $this;
    }
    public function clearState() {
      unset($this->state);
      return $this;
    }
    public function hasState() {
      return isset($this->state);
    }
    public function getOnlyUseIfRequired() {
      if (!isset($this->only_use_if_required)) {
        return false;
      }
      return $this->only_use_if_required;
    }
    public function setOnlyUseIfRequired($val) {
      $this->only_use_if_required = $val;
      return $this;
    }
    public function clearOnlyUseIfRequired() {
      unset($this->only_use_if_required);
      return $this;
    }
    public function hasOnlyUseIfRequired() {
      return isset($this->only_use_if_required);
    }
    public function getReadDivisionFamilySize() {
      return sizeof($this->read_division_family);
    }
    public function getReadDivisionFamilyList() {
      return $this->read_division_family;
    }
    public function getReadDivisionFamily($idx) {
      return $this->read_division_family[$idx];
    }
    public function setReadDivisionFamily($idx, $val) {
      $this->read_division_family[$idx] = $val;
      return $this;
    }
    public function addReadDivisionFamily($val) {
      $this->read_division_family[] = $val;
      return $this;
    }
    public function clearReadDivisionFamily() {
      $this->read_division_family = array();
    }
    public function getWriteDivisionFamily() {
      if (!isset($this->write_division_family)) {
        return '';
      }
      return $this->write_division_family;
    }
    public function setWriteDivisionFamily($val) {
      $this->write_division_family = $val;
      return $this;
    }
    public function clearWriteDivisionFamily() {
      unset($this->write_division_family);
      return $this;
    }
    public function hasWriteDivisionFamily() {
      return isset($this->write_division_family);
    }
    public function getDisabledIndex() {
      if (!isset($this->disabled_index)) {
        return false;
      }
      return $this->disabled_index;
    }
    public function setDisabledIndex($val) {
      $this->disabled_index = $val;
      return $this;
    }
    public function clearDisabledIndex() {
      unset($this->disabled_index);
      return $this;
    }
    public function hasDisabledIndex() {
      return isset($this->disabled_index);
    }
    public function getWorkflowState() {
      if (!isset($this->workflow_state)) {
        return 1;
      }
      return $this->workflow_state;
    }
    public function setWorkflowState($val) {
      $this->workflow_state = $val;
      return $this;
    }
    public function clearWorkflowState() {
      unset($this->workflow_state);
      return $this;
    }
    public function hasWorkflowState() {
      return isset($this->workflow_state);
    }
    public function getErrorMessage() {
      if (!isset($this->error_message)) {
        return '';
      }
      return $this->error_message;
    }
    public function setErrorMessage($val) {
      $this->error_message = $val;
      return $this;
    }
    public function clearErrorMessage() {
      unset($this->error_message);
      return $this;
    }
    public function hasErrorMessage() {
      return isset($this->error_message);
    }
    public function clear() {
      $this->clearAppId();
      $this->clearId();
      $this->clearDefinition();
      $this->clearState();
      $this->clearOnlyUseIfRequired();
      $this->clearReadDivisionFamily();
      $this->clearWriteDivisionFamily();
      $this->clearDisabledIndex();
      $this->clearWorkflowState();
      $this->clearErrorMessage();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->app_id)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->app_id));
      }
      if (isset($this->id)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->id);
      }
      if (isset($this->definition)) {
        $res += 1;
        $res += $this->lengthString($this->definition->byteSizePartial());
      }
      if (isset($this->state)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->state);
      }
      if (isset($this->only_use_if_required)) {
        $res += 2;
      }
      $this->checkProtoArray($this->read_division_family);
      $res += 1 * sizeof($this->read_division_family);
      foreach ($this->read_division_family as $value) {
        $res += $this->lengthString(strlen($value));
      }
      if (isset($this->write_division_family)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->write_division_family));
      }
      if (isset($this->disabled_index)) {
        $res += 2;
      }
      if (isset($this->workflow_state)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->workflow_state);
      }
      if (isset($this->error_message)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->error_message));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->app_id)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->app_id);
      }
      if (isset($this->id)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->id);
      }
      if (isset($this->definition)) {
        $out->putVarInt32(26);
        $out->putVarInt32($this->definition->byteSizePartial());
        $this->definition->outputPartial($out);
      }
      if (isset($this->state)) {
        $out->putVarInt32(32);
        $out->putVarInt32($this->state);
      }
      if (isset($this->only_use_if_required)) {
        $out->putVarInt32(48);
        $out->putBoolean($this->only_use_if_required);
      }
      $this->checkProtoArray($this->read_division_family);
      foreach ($this->read_division_family as $value) {
        $out->putVarInt32(58);
        $out->putPrefixedString($value);
      }
      if (isset($this->write_division_family)) {
        $out->putVarInt32(66);
        $out->putPrefixedString($this->write_division_family);
      }
      if (isset($this->disabled_index)) {
        $out->putVarInt32(72);
        $out->putBoolean($this->disabled_index);
      }
      if (isset($this->workflow_state)) {
        $out->putVarInt32(80);
        $out->putVarInt32($this->workflow_state);
      }
      if (isset($this->error_message)) {
        $out->putVarInt32(90);
        $out->putPrefixedString($this->error_message);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setAppId(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setId($d->getVarInt64());
            break;
          case 26:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableDefinition()->tryMerge($tmp);
            break;
          case 32:
            $this->setState($d->getVarInt32());
            break;
          case 48:
            $this->setOnlyUseIfRequired($d->getBoolean());
            break;
          case 58:
            $length = $d->getVarInt32();
            $this->addReadDivisionFamily(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 66:
            $length = $d->getVarInt32();
            $this->setWriteDivisionFamily(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 72:
            $this->setDisabledIndex($d->getBoolean());
            break;
          case 80:
            $this->setWorkflowState($d->getVarInt32());
            break;
          case 90:
            $length = $d->getVarInt32();
            $this->setErrorMessage(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->app_id)) return 'app_id';
      if (!isset($this->id)) return 'id';
      if ((!isset($this->definition)) || (!$this->definition->isInitialized())) return 'definition';
      if (!isset($this->state)) return 'state';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasAppId()) {
        $this->setAppId($x->getAppId());
      }
      if ($x->hasId()) {
        $this->setId($x->getId());
      }
      if ($x->hasDefinition()) {
        $this->mutableDefinition()->mergeFrom($x->getDefinition());
      }
      if ($x->hasState()) {
        $this->setState($x->getState());
      }
      if ($x->hasOnlyUseIfRequired()) {
        $this->setOnlyUseIfRequired($x->getOnlyUseIfRequired());
      }
      foreach ($x->getReadDivisionFamilyList() as $v) {
        $this->addReadDivisionFamily($v);
      }
      if ($x->hasWriteDivisionFamily()) {
        $this->setWriteDivisionFamily($x->getWriteDivisionFamily());
      }
      if ($x->hasDisabledIndex()) {
        $this->setDisabledIndex($x->getDisabledIndex());
      }
      if ($x->hasWorkflowState()) {
        $this->setWorkflowState($x->getWorkflowState());
      }
      if ($x->hasErrorMessage()) {
        $this->setErrorMessage($x->getErrorMessage());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->app_id) !== isset($x->app_id)) return false;
      if (isset($this->app_id) && $this->app_id !== $x->app_id) return false;
      if (isset($this->id) !== isset($x->id)) return false;
      if (isset($this->id) && !$this->integerEquals($this->id, $x->id)) return false;
      if (isset($this->definition) !== isset($x->definition)) return false;
      if (isset($this->definition) && !$this->definition->equals($x->definition)) return false;
      if (isset($this->state) !== isset($x->state)) return false;
      if (isset($this->state) && $this->state !== $x->state) return false;
      if (isset($this->only_use_if_required) !== isset($x->only_use_if_required)) return false;
      if (isset($this->only_use_if_required) && $this->only_use_if_required !== $x->only_use_if_required) return false;
      if (sizeof($this->read_division_family) !== sizeof($x->read_division_family)) return false;
      foreach (array_map(null, $this->read_division_family, $x->read_division_family) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      if (isset($this->write_division_family) !== isset($x->write_division_family)) return false;
      if (isset($this->write_division_family) && $this->write_division_family !== $x->write_division_family) return false;
      if (isset($this->disabled_index) !== isset($x->disabled_index)) return false;
      if (isset($this->disabled_index) && $this->disabled_index !== $x->disabled_index) return false;
      if (isset($this->workflow_state) !== isset($x->workflow_state)) return false;
      if (isset($this->workflow_state) && $this->workflow_state !== $x->workflow_state) return false;
      if (isset($this->error_message) !== isset($x->error_message)) return false;
      if (isset($this->error_message) && $this->error_message !== $x->error_message) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->app_id)) {
        $res .= $prefix . "app_id: " . $this->debugFormatString($this->app_id) . "\n";
      }
      if (isset($this->id)) {
        $res .= $prefix . "id: " . $this->debugFormatInt64($this->id) . "\n";
      }
      if (isset($this->definition)) {
        $res .= $prefix . "definition <\n" . $this->definition->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->state)) {
        $res .= $prefix . "state: " . ($this->state) . "\n";
      }
      if (isset($this->only_use_if_required)) {
        $res .= $prefix . "only_use_if_required: " . $this->debugFormatBool($this->only_use_if_required) . "\n";
      }
      foreach ($this->read_division_family as $value) {
        $res .= $prefix . "read_division_family: " . $this->debugFormatString($value) . "\n";
      }
      if (isset($this->write_division_family)) {
        $res .= $prefix . "write_division_family: " . $this->debugFormatString($this->write_division_family) . "\n";
      }
      if (isset($this->disabled_index)) {
        $res .= $prefix . "disabled_index: " . $this->debugFormatBool($this->disabled_index) . "\n";
      }
      if (isset($this->workflow_state)) {
        $res .= $prefix . "workflow_state: " . ($this->workflow_state) . "\n";
      }
      if (isset($this->error_message)) {
        $res .= $prefix . "error_message: " . $this->debugFormatString($this->error_message) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class SearchIndexEntry extends \google\net\ProtocolMessage {
    public function getIndexId() {
      if (!isset($this->index_id)) {
        return "0";
      }
      return $this->index_id;
    }
    public function setIndexId($val) {
      if (is_double($val)) {
        $this->index_id = sprintf('%0.0F', $val);
      } else {
        $this->index_id = $val;
      }
      return $this;
    }
    public function clearIndexId() {
      unset($this->index_id);
      return $this;
    }
    public function hasIndexId() {
      return isset($this->index_id);
    }
    public function getWriteDivisionFamily() {
      if (!isset($this->write_division_family)) {
        return '';
      }
      return $this->write_division_family;
    }
    public function setWriteDivisionFamily($val) {
      $this->write_division_family = $val;
      return $this;
    }
    public function clearWriteDivisionFamily() {
      unset($this->write_division_family);
      return $this;
    }
    public function hasWriteDivisionFamily() {
      return isset($this->write_division_family);
    }
    public function getFingerprint1999() {
      if (!isset($this->fingerprint_1999)) {
        return "0";
      }
      return $this->fingerprint_1999;
    }
    public function setFingerprint1999($val) {
      if (is_double($val)) {
        $this->fingerprint_1999 = sprintf('%0.0F', $val);
      } else {
        $this->fingerprint_1999 = $val;
      }
      return $this;
    }
    public function clearFingerprint1999() {
      unset($this->fingerprint_1999);
      return $this;
    }
    public function hasFingerprint1999() {
      return isset($this->fingerprint_1999);
    }
    public function getFingerprint2011() {
      if (!isset($this->fingerprint_2011)) {
        return "0";
      }
      return $this->fingerprint_2011;
    }
    public function setFingerprint2011($val) {
      if (is_double($val)) {
        $this->fingerprint_2011 = sprintf('%0.0F', $val);
      } else {
        $this->fingerprint_2011 = $val;
      }
      return $this;
    }
    public function clearFingerprint2011() {
      unset($this->fingerprint_2011);
      return $this;
    }
    public function hasFingerprint2011() {
      return isset($this->fingerprint_2011);
    }
    public function clear() {
      $this->clearIndexId();
      $this->clearWriteDivisionFamily();
      $this->clearFingerprint1999();
      $this->clearFingerprint2011();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_id)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_id);
      }
      if (isset($this->write_division_family)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->write_division_family));
      }
      if (isset($this->fingerprint_1999)) {
        $res += 9;
      }
      if (isset($this->fingerprint_2011)) {
        $res += 9;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_id)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->index_id);
      }
      if (isset($this->write_division_family)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->write_division_family);
      }
      if (isset($this->fingerprint_1999)) {
        $out->putVarInt32(25);
        $out->put64($this->fingerprint_1999);
      }
      if (isset($this->fingerprint_2011)) {
        $out->putVarInt32(33);
        $out->put64($this->fingerprint_2011);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setIndexId($d->getVarInt64());
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setWriteDivisionFamily(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 25:
            $this->setFingerprint1999($d->getFixed64());
            break;
          case 33:
            $this->setFingerprint2011($d->getFixed64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->index_id)) return 'index_id';
      if (!isset($this->write_division_family)) return 'write_division_family';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexId()) {
        $this->setIndexId($x->getIndexId());
      }
      if ($x->hasWriteDivisionFamily()) {
        $this->setWriteDivisionFamily($x->getWriteDivisionFamily());
      }
      if ($x->hasFingerprint1999()) {
        $this->setFingerprint1999($x->getFingerprint1999());
      }
      if ($x->hasFingerprint2011()) {
        $this->setFingerprint2011($x->getFingerprint2011());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_id) !== isset($x->index_id)) return false;
      if (isset($this->index_id) && !$this->integerEquals($this->index_id, $x->index_id)) return false;
      if (isset($this->write_division_family) !== isset($x->write_division_family)) return false;
      if (isset($this->write_division_family) && $this->write_division_family !== $x->write_division_family) return false;
      if (isset($this->fingerprint_1999) !== isset($x->fingerprint_1999)) return false;
      if (isset($this->fingerprint_1999) && !$this->integerEquals($this->fingerprint_1999, $x->fingerprint_1999)) return false;
      if (isset($this->fingerprint_2011) !== isset($x->fingerprint_2011)) return false;
      if (isset($this->fingerprint_2011) && !$this->integerEquals($this->fingerprint_2011, $x->fingerprint_2011)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_id)) {
        $res .= $prefix . "index_id: " . $this->debugFormatInt64($this->index_id) . "\n";
      }
      if (isset($this->write_division_family)) {
        $res .= $prefix . "write_division_family: " . $this->debugFormatString($this->write_division_family) . "\n";
      }
      if (isset($this->fingerprint_1999)) {
        $res .= $prefix . "fingerprint_1999: " . $this->debugFormatFixed64($this->fingerprint_1999) . "\n";
      }
      if (isset($this->fingerprint_2011)) {
        $res .= $prefix . "fingerprint_2011: " . $this->debugFormatFixed64($this->fingerprint_2011) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class SearchIndexExternalId extends \google\net\ProtocolMessage {
    public function getIndexId() {
      if (!isset($this->index_id)) {
        return "0";
      }
      return $this->index_id;
    }
    public function setIndexId($val) {
      if (is_double($val)) {
        $this->index_id = sprintf('%0.0F', $val);
      } else {
        $this->index_id = $val;
      }
      return $this;
    }
    public function clearIndexId() {
      unset($this->index_id);
      return $this;
    }
    public function hasIndexId() {
      return isset($this->index_id);
    }
    public function getPrimaryKey() {
      if (!isset($this->primary_key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->primary_key;
    }
    public function mutablePrimaryKey() {
      if (!isset($this->primary_key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->primary_key = $res;
        return $res;
      }
      return $this->primary_key;
    }
    public function clearPrimaryKey() {
      if (isset($this->primary_key)) {
        unset($this->primary_key);
      }
    }
    public function hasPrimaryKey() {
      return isset($this->primary_key);
    }
    public function clear() {
      $this->clearIndexId();
      $this->clearPrimaryKey();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->index_id)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->index_id);
      }
      if (isset($this->primary_key)) {
        $res += 1;
        $res += $this->lengthString($this->primary_key->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->index_id)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->index_id);
      }
      if (isset($this->primary_key)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->primary_key->byteSizePartial());
        $this->primary_key->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setIndexId($d->getVarInt64());
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutablePrimaryKey()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->index_id)) return 'index_id';
      if ((!isset($this->primary_key)) || (!$this->primary_key->isInitialized())) return 'primary_key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasIndexId()) {
        $this->setIndexId($x->getIndexId());
      }
      if ($x->hasPrimaryKey()) {
        $this->mutablePrimaryKey()->mergeFrom($x->getPrimaryKey());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->index_id) !== isset($x->index_id)) return false;
      if (isset($this->index_id) && !$this->integerEquals($this->index_id, $x->index_id)) return false;
      if (isset($this->primary_key) !== isset($x->primary_key)) return false;
      if (isset($this->primary_key) && !$this->primary_key->equals($x->primary_key)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->index_id)) {
        $res .= $prefix . "index_id: " . $this->debugFormatInt64($this->index_id) . "\n";
      }
      if (isset($this->primary_key)) {
        $res .= $prefix . "primary_key <\n" . $this->primary_key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3\IndexPostfix {
  class IndexValue extends \google\net\ProtocolMessage {
    public function getPropertyName() {
      if (!isset($this->property_name)) {
        return '';
      }
      return $this->property_name;
    }
    public function setPropertyName($val) {
      $this->property_name = $val;
      return $this;
    }
    public function clearPropertyName() {
      unset($this->property_name);
      return $this;
    }
    public function hasPropertyName() {
      return isset($this->property_name);
    }
    public function getValue() {
      if (!isset($this->value)) {
        return new \storage_onestore_v3\PropertyValue();
      }
      return $this->value;
    }
    public function mutableValue() {
      if (!isset($this->value)) {
        $res = new \storage_onestore_v3\PropertyValue();
        $this->value = $res;
        return $res;
      }
      return $this->value;
    }
    public function clearValue() {
      if (isset($this->value)) {
        unset($this->value);
      }
    }
    public function hasValue() {
      return isset($this->value);
    }
    public function clear() {
      $this->clearPropertyName();
      $this->clearValue();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->property_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->property_name));
      }
      if (isset($this->value)) {
        $res += 1;
        $res += $this->lengthString($this->value->byteSizePartial());
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->property_name)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->property_name);
      }
      if (isset($this->value)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->value->byteSizePartial());
        $this->value->outputPartial($out);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setPropertyName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableValue()->tryMerge($tmp);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->property_name)) return 'property_name';
      if ((!isset($this->value)) || (!$this->value->isInitialized())) return 'value';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasPropertyName()) {
        $this->setPropertyName($x->getPropertyName());
      }
      if ($x->hasValue()) {
        $this->mutableValue()->mergeFrom($x->getValue());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->property_name) !== isset($x->property_name)) return false;
      if (isset($this->property_name) && $this->property_name !== $x->property_name) return false;
      if (isset($this->value) !== isset($x->value)) return false;
      if (isset($this->value) && !$this->value->equals($x->value)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->property_name)) {
        $res .= $prefix . "property_name: " . $this->debugFormatString($this->property_name) . "\n";
      }
      if (isset($this->value)) {
        $res .= $prefix . "value <\n" . $this->value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class IndexPostfix extends \google\net\ProtocolMessage {
    private $index_value = array();
    public function getIndexValueSize() {
      return sizeof($this->index_value);
    }
    public function getIndexValueList() {
      return $this->index_value;
    }
    public function mutableIndexValue($idx) {
      if (!isset($this->index_value[$idx])) {
        $val = new \storage_onestore_v3\IndexPostfix\IndexValue();
        $this->index_value[$idx] = $val;
        return $val;
      }
      return $this->index_value[$idx];
    }
    public function getIndexValue($idx) {
      if (isset($this->index_value[$idx])) {
        return $this->index_value[$idx];
      }
      if ($idx >= end(array_keys($this->index_value))) {
        throw new \OutOfRangeException('index out of range: ' + $idx);
      }
      return new \storage_onestore_v3\IndexPostfix\IndexValue();
    }
    public function addIndexValue() {
      $val = new \storage_onestore_v3\IndexPostfix\IndexValue();
      $this->index_value[] = $val;
      return $val;
    }
    public function clearIndexValue() {
      $this->index_value = array();
    }
    public function getKey() {
      if (!isset($this->key)) {
        return new \storage_onestore_v3\Reference();
      }
      return $this->key;
    }
    public function mutableKey() {
      if (!isset($this->key)) {
        $res = new \storage_onestore_v3\Reference();
        $this->key = $res;
        return $res;
      }
      return $this->key;
    }
    public function clearKey() {
      if (isset($this->key)) {
        unset($this->key);
      }
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getBefore() {
      if (!isset($this->before)) {
        return true;
      }
      return $this->before;
    }
    public function setBefore($val) {
      $this->before = $val;
      return $this;
    }
    public function clearBefore() {
      unset($this->before);
      return $this;
    }
    public function hasBefore() {
      return isset($this->before);
    }
    public function getBeforeAscending() {
      if (!isset($this->before_ascending)) {
        return false;
      }
      return $this->before_ascending;
    }
    public function setBeforeAscending($val) {
      $this->before_ascending = $val;
      return $this;
    }
    public function clearBeforeAscending() {
      unset($this->before_ascending);
      return $this;
    }
    public function hasBeforeAscending() {
      return isset($this->before_ascending);
    }
    public function clear() {
      $this->clearIndexValue();
      $this->clearKey();
      $this->clearBefore();
      $this->clearBeforeAscending();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->index_value);
      $res += 1 * sizeof($this->index_value);
      foreach ($this->index_value as $value) {
        $res += $this->lengthString($value->byteSizePartial());
      }
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString($this->key->byteSizePartial());
      }
      if (isset($this->before)) {
        $res += 2;
      }
      if (isset($this->before_ascending)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->index_value);
      foreach ($this->index_value as $value) {
        $out->putVarInt32(10);
        $out->putVarInt32($value->byteSizePartial());
        $value->outputPartial($out);
      }
      if (isset($this->key)) {
        $out->putVarInt32(18);
        $out->putVarInt32($this->key->byteSizePartial());
        $this->key->outputPartial($out);
      }
      if (isset($this->before)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->before);
      }
      if (isset($this->before_ascending)) {
        $out->putVarInt32(32);
        $out->putBoolean($this->before_ascending);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->addIndexValue()->tryMerge($tmp);
            break;
          case 18:
            $length = $d->getVarInt32();
            $tmp = new \google\net\Decoder($d->buffer(), $d->pos(), $d->pos() + $length);
            $d->skip($length);
            $this->mutableKey()->tryMerge($tmp);
            break;
          case 24:
            $this->setBefore($d->getBoolean());
            break;
          case 32:
            $this->setBeforeAscending($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      foreach ($this->index_value as $value) {
        if (!$value->isInitialized()) return 'index_value';
      }
      if (isset($this->key) && (!$this->key->isInitialized())) return 'key';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getIndexValueList() as $v) {
        $this->addIndexValue()->copyFrom($v);
      }
      if ($x->hasKey()) {
        $this->mutableKey()->mergeFrom($x->getKey());
      }
      if ($x->hasBefore()) {
        $this->setBefore($x->getBefore());
      }
      if ($x->hasBeforeAscending()) {
        $this->setBeforeAscending($x->getBeforeAscending());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->index_value) !== sizeof($x->index_value)) return false;
      foreach (array_map(null, $this->index_value, $x->index_value) as $v) {
        if (!$v[0]->equals($v[1])) return false;
      }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && !$this->key->equals($x->key)) return false;
      if (isset($this->before) !== isset($x->before)) return false;
      if (isset($this->before) && $this->before !== $x->before) return false;
      if (isset($this->before_ascending) !== isset($x->before_ascending)) return false;
      if (isset($this->before_ascending) && $this->before_ascending !== $x->before_ascending) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->index_value as $value) {
        $res .= $prefix . "index_value <\n" . $value->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->key)) {
        $res .= $prefix . "key <\n" . $this->key->shortDebugString($prefix . "  ") . $prefix . ">\n";
      }
      if (isset($this->before)) {
        $res .= $prefix . "before: " . $this->debugFormatBool($this->before) . "\n";
      }
      if (isset($this->before_ascending)) {
        $res .= $prefix . "before_ascending: " . $this->debugFormatBool($this->before_ascending) . "\n";
      }
      return $res;
    }
  }
}
namespace storage_onestore_v3 {
  class IndexPosition extends \google\net\ProtocolMessage {
    public function getKey() {
      if (!isset($this->key)) {
        return '';
      }
      return $this->key;
    }
    public function setKey($val) {
      $this->key = $val;
      return $this;
    }
    public function clearKey() {
      unset($this->key);
      return $this;
    }
    public function hasKey() {
      return isset($this->key);
    }
    public function getBefore() {
      if (!isset($this->before)) {
        return true;
      }
      return $this->before;
    }
    public function setBefore($val) {
      $this->before = $val;
      return $this;
    }
    public function clearBefore() {
      unset($this->before);
      return $this;
    }
    public function hasBefore() {
      return isset($this->before);
    }
    public function getBeforeAscending() {
      if (!isset($this->before_ascending)) {
        return false;
      }
      return $this->before_ascending;
    }
    public function setBeforeAscending($val) {
      $this->before_ascending = $val;
      return $this;
    }
    public function clearBeforeAscending() {
      unset($this->before_ascending);
      return $this;
    }
    public function hasBeforeAscending() {
      return isset($this->before_ascending);
    }
    public function clear() {
      $this->clearKey();
      $this->clearBefore();
      $this->clearBeforeAscending();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->key)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->key));
      }
      if (isset($this->before)) {
        $res += 2;
      }
      if (isset($this->before_ascending)) {
        $res += 2;
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->key)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->key);
      }
      if (isset($this->before)) {
        $out->putVarInt32(16);
        $out->putBoolean($this->before);
      }
      if (isset($this->before_ascending)) {
        $out->putVarInt32(24);
        $out->putBoolean($this->before_ascending);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setKey(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setBefore($d->getBoolean());
            break;
          case 24:
            $this->setBeforeAscending($d->getBoolean());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasKey()) {
        $this->setKey($x->getKey());
      }
      if ($x->hasBefore()) {
        $this->setBefore($x->getBefore());
      }
      if ($x->hasBeforeAscending()) {
        $this->setBeforeAscending($x->getBeforeAscending());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->key) !== isset($x->key)) return false;
      if (isset($this->key) && $this->key !== $x->key) return false;
      if (isset($this->before) !== isset($x->before)) return false;
      if (isset($this->before) && $this->before !== $x->before) return false;
      if (isset($this->before_ascending) !== isset($x->before_ascending)) return false;
      if (isset($this->before_ascending) && $this->before_ascending !== $x->before_ascending) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->key)) {
        $res .= $prefix . "key: " . $this->debugFormatString($this->key) . "\n";
      }
      if (isset($this->before)) {
        $res .= $prefix . "before: " . $this->debugFormatBool($this->before) . "\n";
      }
      if (isset($this->before_ascending)) {
        $res .= $prefix . "before_ascending: " . $this->debugFormatBool($this->before_ascending) . "\n";
      }
      return $res;
    }
  }
}
