/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.locking;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.locking.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticLockingMetadata
extends ORMetadata {
    private Boolean m_cascade;
    private List<ColumnMetadata> m_selectedColumns = new ArrayList<ColumnMetadata>();
    private Enum m_type;

    public OptimisticLockingMetadata() {
        super("<optimistic-locking>");
    }

    public OptimisticLockingMetadata(Annotation optimisticLocking, MetadataAccessibleObject accessibleObject) {
        super(optimisticLocking, accessibleObject);
        this.m_type = (Enum)MetadataHelper.invokeMethod("type", optimisticLocking);
        this.m_cascade = (Boolean)MetadataHelper.invokeMethod("cascade", optimisticLocking);
        for (Annotation selectedColumn : (Annotation[])MetadataHelper.invokeMethod("selectedColumns", optimisticLocking)) {
            this.m_selectedColumns.add(new ColumnMetadata(selectedColumn, accessibleObject));
        }
    }

    public Boolean getCascade() {
        return this.m_cascade;
    }

    public List<ColumnMetadata> getSelectedColumns() {
        return this.m_selectedColumns;
    }

    public Enum getType() {
        return this.m_type;
    }

    public boolean hasSelectedColumns() {
        return !this.m_selectedColumns.isEmpty();
    }

    public void process(MetadataDescriptor descriptor) {
        if (this.m_type == null || this.m_type.name().equals(OptimisticLockingType.VERSION_COLUMN.name())) {
            descriptor.setUsesCascadedOptimisticLocking(this.m_cascade != null && this.m_cascade != false);
        } else if (this.m_type.name().equals(OptimisticLockingType.ALL_COLUMNS.name())) {
            descriptor.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
        } else if (this.m_type.name().equals(OptimisticLockingType.CHANGED_COLUMNS.name())) {
            descriptor.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
        } else if (this.m_type.name().equals(OptimisticLockingType.SELECTED_COLUMNS.name())) {
            if (this.m_selectedColumns.isEmpty()) {
                throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified(descriptor.getJavaClass());
            }
            SelectedFieldsLockingPolicy policy = new SelectedFieldsLockingPolicy();
            for (ColumnMetadata selectedColumn : this.m_selectedColumns) {
                if (selectedColumn.getName().equals("")) {
                    throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified(descriptor.getJavaClass());
                }
                policy.addLockFieldName(selectedColumn.getName());
            }
            descriptor.setOptimisticLockingPolicy(policy);
        }
    }

    public void setCascade(Boolean cascade) {
        this.m_cascade = cascade;
    }

    public void setSelectedColumns(List<ColumnMetadata> selectedColumns) {
        this.m_selectedColumns = selectedColumns;
    }

    public void setType(Enum type) {
        this.m_type = type;
    }
}

