/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.tools.ant.Project;

public class AntResolutionListener
implements ResolutionListener {
    private String indent = "";
    private final Project project;
    private int logLevel;

    public AntResolutionListener(Project project, boolean verbose) {
        this.project = project;
        this.logLevel = verbose ? 2 : 3;
    }

    public void testArtifact(Artifact node) {
    }

    public void startProcessChildren(Artifact artifact) {
        this.indent = this.indent + "  ";
    }

    public void endProcessChildren(Artifact artifact) {
        this.indent = this.indent.substring(2);
    }

    public void includeArtifact(Artifact artifact) {
        this.project.log(this.indent + artifact + " (selected)", this.logLevel);
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        this.project.log(this.indent + omitted + " (removed - nearer found: " + kept.getVersion() + ")", this.logLevel);
    }

    public void omitForCycle(Artifact omitted) {
        this.project.log(this.indent + omitted + " (removed - causes a cycle in the graph)", this.logLevel);
    }

    public void updateScope(Artifact artifact, String scope) {
        this.project.log(this.indent + artifact + " (setting scope to: " + scope + ")", this.logLevel);
    }

    public void updateScopeCurrentPom(Artifact artifact, String scope) {
        this.project.log(this.indent + artifact + " (not setting scope to: " + scope + "; local scope " + artifact.getScope() + " wins)", this.logLevel);
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.project.log(this.indent + artifact + " (setting version to: " + artifact.getVersion() + " from range: " + artifact.getVersionRange() + ")", this.logLevel);
    }

    public void restrictRange(Artifact artifact, Artifact replacement, VersionRange newRange) {
        this.project.log(this.indent + artifact + " (range restricted from: " + artifact.getVersionRange() + " and: " + replacement.getVersionRange() + " to: " + newRange + " )", this.logLevel);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        String msg = this.indent + artifact;
        msg = msg + " (";
        if (replacement.getVersion() != null) {
            msg = msg + "applying version: " + replacement.getVersion() + ";";
        }
        if (replacement.getScope() != null) {
            msg = msg + "applying scope: " + replacement.getScope();
        }
        msg = msg + ")";
        this.project.log(msg, this.logLevel);
    }
}

