/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.JAMonDetailValue;
import com.jamonapi.ListenerType;
import com.jamonapi.Listeners;
import com.jamonapi.MonInternals;
import com.jamonapi.MonKey;
import com.jamonapi.MonitorInt;
import com.jamonapi.Range;
import java.util.Date;

public abstract class Monitor
implements MonitorInt {
    public static final String VALUE = "value";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String MAXACTIVE = "maxactive";
    MonInternals monData;
    private static final Date NULL_DATE = new Date(0L);

    Monitor(MonInternals monData) {
        this.monData = monData;
    }

    Monitor() {
        this(new MonInternals());
    }

    final MonInternals getMonInternals() {
        return this.monData;
    }

    public MonKey getMonKey() {
        return this.monData.key;
    }

    public String getLabel() {
        return (String)this.getMonKey().getValue("Label");
    }

    public String getUnits() {
        return (String)this.getMonKey().getValue("Units");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessStats(long now) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                if (this.monData.firstAccess == 0L) {
                    this.monData.firstAccess = now;
                }
                this.monData.lastAccess = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotal() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.total;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotal(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.total = value;
            }
        }
    }

    public double getAvg() {
        if (this.monData.enabled) {
            return this.avg(this.monData.total);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMin() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.min;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMin(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.min = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMax() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.max;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMax(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.max = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getHits() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.hits;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHits(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.hits = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStdDev() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                double stdDeviation = 0.0;
                if (this.monData.hits != 0.0) {
                    double sumOfX = this.monData.total;
                    double n = this.monData.hits;
                    double nMinus1 = n <= 1.0 ? 1.0 : n - 1.0;
                    double numerator = this.monData.sumOfSquares - sumOfX * sumOfX / n;
                    stdDeviation = Math.sqrt(numerator / nMinus1);
                }
                return stdDeviation;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstAccess(Date date) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.firstAccess = date.getTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstAccess() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return new Date(this.monData.firstAccess);
            }
        }
        return NULL_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccess(Date date) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.lastAccess = date.getTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastAccess() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return new Date(this.monData.lastAccess);
            }
        }
        return NULL_DATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastValue() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.lastValue;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastValue(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.lastValue = value;
            }
        }
    }

    public void disable() {
        this.monData.enabled = false;
    }

    public void enable() {
        this.monData.enabled = true;
    }

    public boolean isEnabled() {
        return this.monData.enabled;
    }

    Listeners getListeners() {
        return this.monData.listeners;
    }

    public ListenerType getListenerType(String listenerType) {
        return this.getListeners().getListenerType(listenerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor start() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.activityStats.allActive.increment();
                if (this.monData.isPrimary) {
                    this.monData.activityStats.primaryActive.increment();
                }
                double active = this.monData.activityStats.thisActive.incrementAndReturn();
                this.monData.totalActive += active;
                if (active >= this.monData.maxActive) {
                    this.monData.maxActive = active;
                    if (this.monData.listeners.listenerArray[2].listener != null && active > 1.0) {
                        this.monData.listeners.listenerArray[2].listener.processEvent(this);
                    }
                }
                if (!this.monData.startHasBeenCalled) {
                    this.monData.startHasBeenCalled = true;
                    if (this.monData.range != null) {
                        this.monData.range.setActivityTracking(true);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor stop() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.activityStats.thisActive.decrement();
                if (this.monData.isPrimary) {
                    this.monData.activityStats.primaryActive.decrement();
                }
                this.monData.activityStats.allActive.decrement();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor add(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                if (!this.monData.isTimeMonitor) {
                    this.setAccessStats(System.currentTimeMillis());
                }
                this.monData.lastValue = value;
                this.monData.hits += 1.0;
                this.monData.total += value;
                this.monData.sumOfSquares += value * value;
                if (this.monData.trackActivity) {
                    this.monData.thisActiveTotal += this.monData.activityStats.thisActive.getCount();
                    this.monData.primaryActiveTotal += this.monData.activityStats.primaryActive.getCount();
                    this.monData.allActiveTotal += this.monData.activityStats.allActive.getCount();
                }
                if (value <= this.monData.min) {
                    this.monData.min = value;
                    if (this.monData.listeners.listenerArray[3].listener != null) {
                        this.monData.listeners.listenerArray[3].listener.processEvent(this);
                    }
                }
                if (value >= this.monData.max) {
                    this.monData.max = value;
                    if (this.monData.listeners.listenerArray[1].listener != null) {
                        this.monData.listeners.listenerArray[1].listener.processEvent(this);
                    }
                }
                if (this.monData.listeners.listenerArray[0].listener != null) {
                    this.monData.listeners.listenerArray[0].listener.processEvent(this);
                }
                if (this.monData.range != null) {
                    this.monData.range.processEvent(this);
                }
            }
        }
        return this;
    }

    public Range getRange() {
        return this.monData.range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getActive() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.activityStats.thisActive.getCount();
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.activityStats.thisActive.setCount(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMaxActive() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return this.monData.maxActive;
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.maxActive = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalActive(double value) {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                this.monData.totalActive = value;
            }
        }
    }

    public boolean isPrimary() {
        return this.monData.isPrimary;
    }

    public void setPrimary(boolean isPrimary) {
        if (this.monData.enabled) {
            this.monData.isPrimary = isPrimary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            return this.monData.listeners.hasListeners();
        }
    }

    public String toString() {
        if (this.monData.enabled) {
            StringBuffer b = new StringBuffer(400);
            b.append(this.getMonKey() + ": (");
            b.append("LastValue=");
            b.append(this.getLastValue());
            b.append(", Hits=");
            b.append(this.getHits());
            b.append(", Avg=");
            b.append(this.getAvg());
            b.append(", Total=");
            b.append(this.getTotal());
            b.append(", Min=");
            b.append(this.getMin());
            b.append(", Max=");
            b.append(this.getMax());
            b.append(", Active=");
            b.append(this.getActive());
            b.append(", Avg Active=");
            b.append(this.getAvgActive());
            b.append(", Max Active=");
            b.append(this.getMaxActive());
            b.append(", First Access=");
            b.append(this.getFirstAccess());
            b.append(", Last Access=");
            b.append(this.getLastAccess());
            b.append(")");
            return b.toString();
        }
        return "";
    }

    public void setActivityTracking(boolean trackActivity) {
        this.monData.trackActivity = trackActivity;
    }

    public boolean isActivityTracking() {
        return this.monData.trackActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double avg(double value) {
        MonInternals monInternals = this.monData;
        synchronized (monInternals) {
            if (this.monData.hits == 0.0) {
                return 0.0;
            }
            return value / this.monData.hits;
        }
    }

    public double getAvgActive() {
        if (this.monData.enabled) {
            if (this.monData.trackActivity) {
                return this.avg(this.monData.thisActiveTotal);
            }
            return this.avg(this.monData.totalActive);
        }
        return 0.0;
    }

    public double getAvgGlobalActive() {
        return this.avg(this.monData.allActiveTotal);
    }

    public double getAvgPrimaryActive() {
        return this.avg(this.monData.primaryActiveTotal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAMonDetailValue getJAMonDetailRow() {
        if (this.monData.enabled) {
            MonInternals monInternals = this.monData;
            synchronized (monInternals) {
                return new JAMonDetailValue(this.getMonKey(), this.monData.lastValue, this.monData.activityStats.thisActive.getCount(), this.monData.lastAccess);
            }
        }
        return JAMonDetailValue.NULL_VALUE;
    }
}

