/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.jotm.JotmRecovery;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.StatusHelper;
import org.objectweb.jotm.TimerManager;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.TransactionImpl;
import org.objectweb.jotm.TransactionRecovery;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.XATerminatorImpl;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;
import org.objectweb.transaction.jta.ResourceManagerEvent;
import org.objectweb.transaction.jta.TransactionManager;

public class Current
implements UserTransaction,
TransactionManager,
Referenceable,
Serializable {
    private static transient ThreadLocal threadTx = new ThreadLocal();
    private static transient Map txXids = Collections.synchronizedMap(new HashMap());
    private static transient Current unique = null;
    private static transient TimerManager timermgr = null;
    private static transient TransactionFactory tm = null;
    private static transient TransactionRecovery tr = null;
    private static final String JOTM_VERSION = "JOTM 2.0.10";
    private static final int DEFAULT_TIMEOUT = 60;
    private int defaultTimeout = 60;
    private int transactionTimeout = 60;
    private static final boolean DEFAULT_RECOVERY = false;
    private static boolean transactionRecovery = false;
    private transient int nb_bg_tx = 0;
    private transient int nb_rb_tx = 0;
    private transient int nb_cm_tx = 0;
    private transient int nb_to = 0;
    private transient ThreadLocal eventListStack = new ThreadLocal();

    public Current() {
        TraceTm.jta.info((Object)JOTM_VERSION);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"no args constructor");
        }
        unique = this;
        timermgr = TimerManager.getInstance();
        try {
            tr = new TransactionRecoveryImpl();
        }
        catch (Exception e) {
            Current.setDefaultRecovery(false);
            TraceTm.recovery.error((Object)"Cannot open Howl Log");
            TraceTm.recovery.error((Object)"JOTM Recovery is being disabled");
        }
    }

    public Current(TransactionFactory tmfact) {
        TraceTm.jta.info((Object)JOTM_VERSION);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionFactory=" + tmfact));
        }
        unique = this;
        tm = tmfact;
        timermgr = TimerManager.getInstance();
        try {
            tr = new TransactionRecoveryImpl();
        }
        catch (Exception e) {
            Current.setDefaultRecovery(false);
            TraceTm.recovery.error((Object)"Cannot open Howl Log");
            TraceTm.recovery.error((Object)"JOTM Recovery is being disabled");
        }
    }

    public static TransactionManager getTransactionManager() {
        return unique;
    }

    public void begin() throws NotSupportedException, SystemException {
        block17: {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"begin transaction");
            }
            TransactionImpl tx = (TransactionImpl)threadTx.get();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
            }
            if (tx != null) {
                if (txXids.containsValue(tx)) {
                    throw new NotSupportedException("Nested transactions not supported");
                }
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("Resetting current tx = " + tx + " since it is already completed."));
                }
            }
            XidImpl otid = new XidImpl();
            tx = new TransactionImpl(otid, this.transactionTimeout);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("tx=" + tx));
            }
            try {
                tx.doAttach(0x200000);
            }
            catch (RollbackException e) {
                TraceTm.jotm.error((Object)"doAttach: RollbackException");
                throw new SystemException("RollbackException in occured in begin() " + e.getMessage());
            }
            threadTx.set(tx);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
            }
            this.putTxXid(otid, tx);
            if (timermgr != null) {
                tx.setTimer(timermgr.addTimer(tx, this.transactionTimeout, null, false));
            }
            Date myDate = new Date();
            tx.setTxDate(myDate.toString());
            Stack curStack = (Stack)this.eventListStack.get();
            if (curStack != null) {
                try {
                    List list = (List)curStack.peek();
                    if (list != null) {
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            ((ResourceManagerEvent)it.next()).enlistConnection(tx);
                        }
                    } else if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)"Current.begin called with null list");
                    }
                }
                catch (EmptyStackException e) {
                    if (!TraceTm.jta.isDebugEnabled()) break block17;
                    TraceTm.jta.debug((Object)"Current.begin called with empty stack");
                }
            }
        }
    }

    public void begin(javax.transaction.xa.Xid passxid) throws NotSupportedException, SystemException {
        this.begin(passxid, this.transactionTimeout);
    }

    public void begin(javax.transaction.xa.Xid passxid, long timeout) throws NotSupportedException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("begin inflow transaction, timeout = " + timeout));
        }
        if (timeout <= 0L) {
            timeout = this.defaultTimeout;
        }
        TransactionImpl tx = (TransactionImpl)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
        }
        if (tx != null) {
            if (txXids.containsValue(tx)) {
                throw new NotSupportedException("Nested transactions not supported");
            }
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("Resetting current tx = " + tx + " since it is already completed."));
            }
        }
        XidImpl pxid = new XidImpl(passxid);
        tx = new TransactionImpl(pxid, (int)timeout);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tx));
        }
        threadTx.set(tx);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
        }
        this.putTxXid(pxid, tx);
        if (timermgr != null) {
            tx.setTimer(timermgr.addTimer(tx, (int)timeout, null, false));
        }
        Date myDate = new Date();
        tx.setTxDate(myDate.toString());
    }

    public XATerminator getXATerminator() throws XAException {
        XATerminatorImpl xaterm;
        block2: {
            xaterm = null;
            try {
                xaterm = new XATerminatorImpl();
            }
            catch (XAException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block2;
                TraceTm.jta.debug((Object)("Cannot create XATerminatorImpl" + e));
            }
        }
        return xaterm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"commit transaction ");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for commit");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tx));
        }
        try {
            tx.commit();
            Object var3_2 = null;
            threadTx.set(null);
            this.transactionTimeout = this.defaultTimeout;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            threadTx.set(null);
            this.transactionTimeout = this.defaultTimeout;
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set= null");
                TraceTm.jta.debug((Object)("reset timeout= " + this.defaultTimeout));
            }
            throw throwable;
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"threadTx.set= null");
            TraceTm.jta.debug((Object)("reset timeout= " + this.defaultTimeout));
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.rollback()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for rollback");
        }
        threadTx.set(null);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"threadTx.set= null");
        }
        tx.rollback();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("reset timeout= " + this.defaultTimeout));
        }
        this.transactionTimeout = this.defaultTimeout;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.setRollbackOnly()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            throw new IllegalStateException("Cannot get Transaction for setRollbackOnly");
        }
        tx.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.getStatus()");
        }
        if ((tx = (TransactionImpl)this.getTransaction()) == null) {
            return 6;
        }
        return tx.getStatus();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        TransactionImpl tx;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("timeout= " + timeout));
        }
        if ((tx = (TransactionImpl)threadTx.get()) != null && txXids.containsValue(tx)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"Cannot reset transaction timeout, tx in execution");
            }
            return;
        }
        this.transactionTimeout = timeout > 0 ? timeout : this.defaultTimeout;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Resetting transaction timeout= " + this.transactionTimeout));
        }
    }

    public void setTransactionRecovery(boolean recovery) throws SystemException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("recovery=" + recovery));
        }
        transactionRecovery = recovery ? recovery : false;
    }

    public Transaction getTransaction() throws SystemException {
        Transaction ret = (Transaction)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
            TraceTm.jta.debug((Object)("Transaction ret= " + ret));
        }
        return ret;
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"resume transaction");
        }
        if (tobj == null) {
            TraceTm.jotm.error((Object)"resume: null arg.");
            throw new InvalidTransactionException("resume(null) is not valid");
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("tx=" + tobj));
        }
        Transaction mytx = (Transaction)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
        }
        if (mytx != null) {
            if (mytx.equals(tobj)) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"nothing to do");
                }
                return;
            }
            TraceTm.jotm.error((Object)"resume: already associated with another transaction.");
            throw new IllegalStateException("the thread is already associated with another transaction.");
        }
        if (!(tobj instanceof TransactionImpl)) {
            TraceTm.jotm.error((Object)"resume: non TransactionImpl arg.");
            throw new InvalidTransactionException("resume(" + tobj.getClass().getName() + ") is not valid");
        }
        threadTx.set(tobj);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
        }
        try {
            ((TransactionImpl)tobj).doAttach(0x8000000);
        }
        catch (RollbackException e) {
            TraceTm.jotm.error((Object)"RollbackException occured in resume()");
            throw new SystemException("RollbackException in occured in resume() " + e.getMessage());
        }
    }

    public Transaction suspend() throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"suspend transaction");
        }
        TransactionImpl tx = (TransactionImpl)threadTx.get();
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
        }
        if (tx != null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("tx=" + tx));
            }
            tx.doDetach(0x2000000);
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set= null");
            }
        }
        return tx;
    }

    public void connectionOpened(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Current.connectionOpened " + this));
        }
        Vector<ResourceManagerEvent> list = null;
        Stack<Vector<ResourceManagerEvent>> curStack = (Stack<Vector<ResourceManagerEvent>>)this.eventListStack.get();
        if (curStack == null) {
            curStack = new Stack<Vector<ResourceManagerEvent>>();
            this.eventListStack.set(curStack);
        } else {
            try {
                list = (Vector<ResourceManagerEvent>)curStack.pop();
            }
            catch (EmptyStackException e) {
                // empty catch block
            }
        }
        if (list == null) {
            list = new Vector<ResourceManagerEvent>(1);
        }
        list.add(event);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("list.add(event) = " + event));
        }
        curStack.push(list);
    }

    public void connectionClosed(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionClosed, remove");
        }
        this.removeFromCurrentStack(event);
    }

    public void connectionErrorOccured(ResourceManagerEvent event) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.connectionErrorOccured");
        }
        this.removeFromCurrentStack(event);
    }

    private void removeFromCurrentStack(ResourceManagerEvent event) {
        Stack curStack;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Current.removeFromCurrentStack " + event));
            TraceTm.jta.debug((Object)("Current = " + this));
        }
        if ((curStack = (Stack)this.eventListStack.get()) == null) {
            return;
        }
        try {
            List list = (List)curStack.peek();
            if (list != null) {
                list.remove(event);
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public void pushThreadLocalRMEventList(List eventList) {
        Stack<List> curStack;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.pushThreadLocalRMEventList");
        }
        if ((curStack = (Stack<List>)this.eventListStack.get()) == null) {
            curStack = new Stack<List>();
            this.eventListStack.set(curStack);
        }
        curStack.push(eventList);
    }

    public List popThreadLocalRMEventList() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.popThreadLocalRMEventList");
        }
        Stack curStack = (Stack)this.eventListStack.get();
        return (List)curStack.pop();
    }

    public Reference getReference() throws NamingException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"Current.getReference()");
        }
        Reference ref = new Reference(this.getClass().getName(), "org.objectweb.jotm.UserTransactionFactory", null);
        Integer i = new Integer(this.transactionTimeout);
        ref.add(new StringRefAddr("jotm.timeout", i.toString()));
        return ref;
    }

    public static Current getCurrent() {
        return unique;
    }

    public static TransactionFactory getJTM() {
        if (tm == null) {
            TraceTm.jotm.error((Object)"Current: TMFactory is null!");
        }
        return tm;
    }

    public static TransactionRecovery getTransactionRecovery() {
        if (tr == null) {
            TraceTm.jotm.error((Object)"Current: Transaction Recovery is null!");
        }
        return tr;
    }

    public void setDefaultTimeout(int timeout) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("timeout= " + timeout));
        }
        if (timeout != 0) {
            this.defaultTimeout = timeout;
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("default timeout= " + this.defaultTimeout));
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public static void setDefaultRecovery(boolean recovery) {
        TraceTm.recovery.info((Object)("Jotm Recovery= " + recovery));
        transactionRecovery = recovery;
    }

    public static boolean getDefaultRecovery() {
        return transactionRecovery;
    }

    public void setPropagationContext(TransactionContext pctx, boolean isReply) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("pctx=" + pctx + ", isReply=" + isReply));
        }
        if (pctx == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"detach tx");
            }
            TransactionImpl tx = (TransactionImpl)threadTx.get();
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.get= " + threadTx.toString()));
            }
            if (tx != null) {
                if (tx.isRemovable()) {
                    this.forgetTx(tx.getXid());
                }
                threadTx.set(null);
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"threadTx.set= null");
                }
            }
            return;
        }
        Xid xid = pctx.getXid();
        TransactionImpl tx = this.getTxXid(xid);
        if (tx == null) {
            if (!isReply) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"new Tx");
                }
                tx = new TransactionImpl(pctx);
                this.putTxXid(xid, tx);
                Date myDate = new Date();
                tx.setTxDate(myDate.toString());
            } else if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("unknown tx:" + xid));
            }
        } else if (isReply) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("updating Xid=" + xid));
            }
            tx.updatePropagationContext(pctx);
        } else if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("transaction already known:" + xid));
        }
        if (!isReply) {
            threadTx.set(tx);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
            }
        }
    }

    public TransactionContext getPropagationContext(boolean hold) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug((Object)("hold=" + hold));
        }
        try {
            TransactionImpl tx = (TransactionImpl)this.getTransaction();
            if (tx != null) {
                return tx.getPropagationContext(hold);
            }
        }
        catch (SystemException e) {
            TraceTm.jotm.error((Object)"getPropagationContext system exception:", (Throwable)e);
        }
        return null;
    }

    public void forgetTx(Xid xid) {
        TransactionImpl txCur = (TransactionImpl)txXids.get(xid);
        if (txCur != null && txCur.equals((TransactionImpl)threadTx.get())) {
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set = null");
            }
        }
        this.removeTxXid(xid);
    }

    public TransactionImpl getTxByXid(Xid xid) {
        TransactionImpl tx = (TransactionImpl)txXids.get(xid);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.transaction.xa.Xid[] getPreparedHeuristicXid() {
        Xid xid = null;
        int xidcount = txXids.size();
        if (xidcount == 0) {
            return null;
        }
        Vector<Xid> xidlist = new Vector<Xid>();
        Set txXidsSet = txXids.keySet();
        Map map = txXids;
        synchronized (map) {
            Iterator txXidsIterator = txXidsSet.iterator();
            while (txXidsIterator.hasNext()) {
                TransactionImpl tx = (TransactionImpl)txXids.get(txXidsIterator.next());
                try {
                    if (tx.getStatus() != 2) continue;
                    xid = tx.getXid();
                    xidlist.add(xid);
                }
                catch (SystemException e) {
                    TraceTm.jotm.error((Object)"getPreparedHeuristicsXid system exception:", (Throwable)e);
                }
            }
        }
        Vector mytxrecovered = JotmRecovery.getTxRecovered();
        return (javax.transaction.xa.Xid[])xidlist.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.transaction.xa.Xid[] getAllXid() {
        Xid xid = null;
        int xidcount = txXids.size();
        if (xidcount == 0) {
            return null;
        }
        Vector<Xid> xidlist = new Vector<Xid>();
        Set txXidsSet = txXids.keySet();
        Map map = txXids;
        synchronized (map) {
            Iterator txXidsIterator = txXidsSet.iterator();
            while (txXidsIterator.hasNext()) {
                TransactionImpl mytx = (TransactionImpl)txXids.get(txXidsIterator.next());
                xid = mytx.getXid();
                xidlist.add(xid);
            }
        }
        return (javax.transaction.xa.Xid[])xidlist.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllTx() {
        int txCount = txXids.size();
        if (txCount == 0) {
            return null;
        }
        Vector<String> txList = new Vector<String>();
        Set txXidsSet = txXids.keySet();
        Map map = txXids;
        synchronized (map) {
            Iterator txXidsIterator = txXidsSet.iterator();
            while (txXidsIterator.hasNext()) {
                String txStatusName;
                TransactionImpl mytx = (TransactionImpl)txXids.get(txXidsIterator.next());
                try {
                    txStatusName = StatusHelper.getStatusName(mytx.getStatus());
                }
                catch (SystemException e) {
                    txStatusName = "No State Defined";
                }
                List txResourceList = mytx.getEnlistedXAResource();
                int txResourceCount = txResourceList.size();
                if (txResourceCount == 0) {
                    txList.add(mytx.getTxDate() + "????" + mytx.toString() + "????" + "NO Resource Defined" + "????" + txStatusName);
                    continue;
                }
                for (int i = 0; i < txResourceCount; ++i) {
                    txList.add(mytx.getTxDate() + "????" + mytx.toString() + "????" + txResourceList.get(i).toString() + "????" + txStatusName);
                }
            }
        }
        String[] myTxString = new String[txCount];
        for (int i = 0; i < txCount; ++i) {
            myTxString[i] = txList.get(i).toString();
        }
        return myTxString;
    }

    public String[] getAllRcTx() {
        Vector vTxRecovered = null;
        JotmRecovery myjr = null;
        if (tr == null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"tr= null");
            }
            return null;
        }
        myjr = tr.getJotmRecovery();
        if (myjr == null) {
            return null;
        }
        vTxRecovered = JotmRecovery.getTxRecovered();
        int txCount = vTxRecovered.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("txcount= " + txCount));
        }
        if (txCount == 0) {
            return null;
        }
        Vector<String> txList = new Vector<String>();
        TxRecovered mytxRecovered = null;
        for (int i = 0; i < txCount; ++i) {
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            XidImpl temptxxid = new XidImpl(mytxRecovered.gettxxid());
            txList.add(new String(mytxRecovered.gettxxid()) + "????" + ((Object)temptxxid).toString() + "????" + mytxRecovered.gettxdatetime() + "????" + mytxRecovered.getxidcount());
        }
        String[] myTxString = new String[txCount];
        for (int i = 0; i < txCount; ++i) {
            myTxString[i] = txList.get(i).toString();
        }
        return myTxString;
    }

    public String[] getAllXaTx(String stx) {
        int myxacount = 0;
        boolean mytxfound = false;
        boolean myrmifound = false;
        boolean myrmregistered = false;
        boolean myxaresfound = false;
        JotmRecovery myjr = null;
        if (tr == null) {
            return null;
        }
        myjr = tr.getJotmRecovery();
        if (myjr == null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"myjr= null");
            }
            return null;
        }
        Vector<String> xaList = new Vector<String>();
        TxxidRecovered mytxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        Vector vTxRecovered = null;
        Vector vRecoverRmInfo = null;
        RmRegistration myRmRegistration = null;
        String myxares = null;
        vTxRecovered = JotmRecovery.getTxRecovered();
        int txCount = vTxRecovered.size();
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("txcount= " + txCount));
        }
        for (int i = 0; i < txCount; ++i) {
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("gettxxid= " + new String(mytxRecovered.gettxxid())));
                TraceTm.recovery.debug((Object)("stx=" + stx));
            }
            if (!new String(mytxRecovered.gettxxid()).equals(stx)) continue;
            mytxfound = true;
            break;
        }
        Vector rmList = new Vector();
        RecoverRmInfo rmInfo = null;
        vRecoverRmInfo = JotmRecovery.getRecoverRmInfo();
        String myrm = null;
        Vector vRmRegistration = tr.getRmRegistration();
        if (mytxfound) {
            myxacount = mytxRecovered.getxidcount();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("myxacount= " + myxacount));
            }
            for (int i = 0; i < myxacount; ++i) {
                myrmregistered = false;
                myrmifound = false;
                myxaresfound = false;
                mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(i);
                if (mytxxidRecovered == null) {
                    xaList.add("NotFound????NotFound????NotFound????NotFound????NotFound");
                    continue;
                }
                int rmiCount = vRecoverRmInfo.size();
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("rmiCount= " + rmiCount));
                }
                for (int j = 0; j < rmiCount; ++j) {
                    rmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(j);
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("getRecoverXaResName()= " + rmInfo.getRecoverXaResName()));
                        TraceTm.recovery.debug((Object)("getRecoverxaresname()=" + mytxxidRecovered.getRecoverxaresname()));
                        TraceTm.recovery.debug((Object)("getRecoverXaRes()= " + new String(rmInfo.getRecoverXaRes())));
                        TraceTm.recovery.debug((Object)("getRecoverxares()=" + new String(mytxxidRecovered.getRecoverxares())));
                    }
                    if (!new String(rmInfo.getRecoverXaRes()).equals(new String(mytxxidRecovered.getRecoverxares()))) continue;
                    myrm = rmInfo.getRecoverRm();
                    myrmifound = true;
                    myxares = new String(mytxxidRecovered.getRecoverxares());
                    if (!TraceTm.recovery.isDebugEnabled()) break;
                    TraceTm.recovery.debug((Object)("myrm= " + myrm));
                    TraceTm.recovery.debug((Object)("myxares= " + myxares));
                    break;
                }
                if (!myrmifound) {
                    myrm = "NotFound";
                }
                if (vRmRegistration == null) {
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)"vRmRegistration is null");
                    }
                    myxares = "NotRegistered";
                } else {
                    int rmregcount = vRmRegistration.size();
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("rmregcount= " + rmregcount));
                    }
                    for (int j = 0; j < rmregcount; ++j) {
                        myRmRegistration = (RmRegistration)vRmRegistration.elementAt(j);
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)("myrm= " + myrm));
                            TraceTm.recovery.debug((Object)("rmGetName= " + myRmRegistration.rmGetName()));
                        }
                        if (!myrm.equals(myRmRegistration.rmGetName())) continue;
                        myrmregistered = true;
                        if (myRmRegistration.rmGetXaRes() == null) {
                            myxares = "IsNull";
                            break;
                        }
                        myxares = myRmRegistration.rmGetXaRes().toString();
                        myxaresfound = true;
                        if (!TraceTm.recovery.isDebugEnabled()) break;
                        TraceTm.recovery.debug((Object)("myxares= " + myxares));
                        break;
                    }
                    if (!myrmregistered) {
                        myxares = "NotRegistered";
                    }
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("myxares= " + myxares));
                    }
                }
                XidImpl tempxid = new XidImpl(mytxxidRecovered.getRecoverxid());
                xaList.add(myrm + "????" + myxares + "????" + new String(mytxxidRecovered.getRecoverxid()) + "????" + new String(((Object)tempxid).toString()) + "????" + StatusHelper.getStatusName(mytxxidRecovered.getRecoverstatus()));
            }
        }
        String[] myTxString = new String[myxacount];
        for (int i = 0; i < myxacount; ++i) {
            myTxString[i] = xaList.get(i).toString();
        }
        return myTxString;
    }

    public int actionXAResource(String xaAction, String xatx) {
        javax.transaction.xa.Xid[] javaxid;
        String sFullXid;
        XAResource xaresource;
        block22: {
            Vector vRmRegistration = null;
            Object vRecoverRmInfo = null;
            boolean mytxfound = false;
            boolean myrmifound = false;
            JotmRecovery myjr = null;
            RmRegistration myRmRegistration = null;
            xaresource = null;
            if (tr == null) {
                return 0;
            }
            myjr = tr.getJotmRecovery();
            if (myjr == null) {
                return 0;
            }
            vRmRegistration = tr.getRmRegistration();
            if (vRmRegistration == null) {
                return 0;
            }
            String mys = xatx;
            int myix1 = mys.indexOf(10);
            String sResmgr = mys.substring(0, myix1);
            int myix2 = mys.indexOf(10, myix1 + 1);
            String sResource = mys.substring(myix1 + 1, myix2);
            int myix3 = mys.indexOf(10, myix2 + 1);
            sFullXid = mys.substring(myix2 + 1, myix3);
            String sXidstate = mys.substring(myix3 + 1);
            int rmregcount = vRmRegistration.size();
            for (int i = 0; i < rmregcount; ++i) {
                myRmRegistration = (RmRegistration)vRmRegistration.elementAt(i);
                if (!sResmgr.equals(myRmRegistration.rmGetName())) continue;
                xaresource = myRmRegistration.rmGetXaRes();
                break;
            }
            int rcflag = 0;
            javaxid = new javax.transaction.xa.Xid[100];
            try {
                javaxid = xaresource.recover(rcflag);
            }
            catch (XAException e) {
                if (!TraceTm.jta.isDebugEnabled()) break block22;
                TraceTm.recovery.debug((Object)("xaResource.recover call failed during recovery " + e.getMessage()));
            }
        }
        if (javaxid == null) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"No XIDs to recover for Xares javaxid is null");
            }
            this.cleanuptxrecovery(sFullXid);
            return 0;
        }
        if (javaxid.length == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("No XIDs to recover for Xares= " + xaresource));
            }
            this.cleanuptxrecovery(sFullXid);
            return 0;
        }
        Xid[] rcxid = new Xid[javaxid.length];
        int xx = 0;
        if (xx < javaxid.length && javaxid[xx] != null && new String(javaxid[xx].toString()).equals(sFullXid)) {
            if (xaAction == "commit") {
                try {
                    xaresource.commit(javaxid[xx], false);
                }
                catch (XAException e) {
                    TraceTm.recovery.error((Object)("Unable to commit Xid during Admin Recovery " + e.getMessage()));
                }
            } else if (xaAction == "rollback") {
                try {
                    xaresource.rollback(javaxid[xx]);
                }
                catch (XAException e) {
                    TraceTm.recovery.error((Object)("Unable to rollback Xid during Admin Recovery " + e.getMessage()));
                }
            } else if (xaAction == "forget") {
                try {
                    xaresource.rollback(javaxid[xx]);
                }
                catch (XAException e) {
                    TraceTm.recovery.error((Object)("Unable to rollback Xid during Admin Recovery " + e.getMessage()));
                }
            }
        }
        this.cleanuptxrecovery(sFullXid);
        return 0;
    }

    private void cleanuptxrecovery(String pFullXid) {
        Vector vTxRecovered = null;
        TxRecovered mytxRecovered = null;
        TxxidRecovered mytxxidRecovered = null;
        int myxacount = 0;
        boolean mytxxidrecoveredfound = false;
        byte[] jotmDone = new byte[11];
        byte[][] jotmDoneRecord = new byte[1][11];
        jotmDone = "RR3JOTMDONE".getBytes();
        vTxRecovered = JotmRecovery.getTxRecovered();
        int txCount = vTxRecovered.size();
        for (int i = 0; i < txCount; ++i) {
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            myxacount = mytxRecovered.getxidcount();
            for (int j = 0; j < myxacount; ++j) {
                mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (mytxxidRecovered == null || !pFullXid.equals(new String(mytxxidRecovered.getRecoverxid()))) continue;
                mytxxidRecovered.setRecoverstatus(3);
                mytxxidrecoveredfound = true;
                break;
            }
            boolean allcompleted = true;
            for (int j = 0; j < myxacount; ++j) {
                mytxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (mytxxidRecovered.getRecoverstatus() == 3) continue;
                allcompleted = false;
                break;
            }
            if (allcompleted) {
                XACommittingTx xaCommitTx = mytxRecovered.getXACommittingTx();
                jotmDoneRecord[0] = jotmDone;
                if (Current.getDefaultRecovery()) {
                    try {
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)"Done howl log, after admin action");
                        }
                        TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(jotmDoneRecord, xaCommitTx);
                    }
                    catch (Exception f) {
                        String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                        TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
                    }
                }
                vTxRecovered.remove(i);
                break;
            }
            if (!mytxxidrecoveredfound) continue;
            return;
        }
    }

    public void associateThreadTx(Xid xid) {
        TransactionImpl tx = this.getTxXid(xid);
        threadTx.set(tx);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("threadTx.set= " + threadTx.toString()));
        }
    }

    public void clearThreadTx() {
        TransactionImpl tx = (TransactionImpl)threadTx.get();
        if (tx != null) {
            threadTx.set(null);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.debug((Object)"threadTx.set=null");
            }
        }
    }

    private void putTxXid(Xid xid, TransactionImpl tx) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Associate tx to xid (xid=" + xid + ")"));
        }
        txXids.put(xid, tx);
    }

    private TransactionImpl getTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("get tx from xid (xid=" + xid + ")"));
        }
        TransactionImpl tx = (TransactionImpl)txXids.get(xid);
        return tx;
    }

    private void removeTxXid(Xid xid) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("remove tx from xid (xid=" + xid + ")"));
        }
        txXids.remove(xid);
    }

    void forget() throws Exception {
        threadTx.set(null);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"threadTx.set= null");
        }
    }

    public int getTotalCurrentTransactions() {
        return txXids.size();
    }

    synchronized void incrementBeginCounter() {
        ++this.nb_bg_tx;
    }

    public int getTotalBegunTransactions() {
        return this.nb_bg_tx;
    }

    synchronized void incrementRollbackCounter() {
        ++this.nb_rb_tx;
    }

    public int getTotalRolledbackTransactions() {
        return this.nb_rb_tx;
    }

    synchronized void incrementCommitCounter() {
        ++this.nb_cm_tx;
    }

    public int getTotalCommittedTransactions() {
        return this.nb_cm_tx;
    }

    public synchronized void resetAllTxTotalCounters() {
        this.nb_bg_tx = 0;
        this.nb_cm_tx = 0;
        this.nb_rb_tx = 0;
        this.nb_to = 0;
    }

    synchronized void incrementExpiredCounter() {
        ++this.nb_to;
    }

    public int getTotalExpiredTransactions() {
        return this.nb_to;
    }

    public synchronized Integer[] getTransactionCounters() {
        Integer[] result = new Integer[]{new Integer(txXids.size()), new Integer(this.nb_bg_tx), new Integer(this.nb_cm_tx), new Integer(this.nb_rb_tx), new Integer(this.nb_to)};
        return result;
    }
}

