/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.tiles.context.MapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServletHeaderValuesMap
implements Map<String, String[]> {
    private HttpServletRequest request = null;

    public ServletHeaderValuesMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getHeader(this.key(key)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String[])) {
            return false;
        }
        String[] test = (String[])value;
        for (String[] actual : this.values()) {
            if (test.length != actual.length) continue;
            boolean matched = true;
            for (int i = 0; i < test.length; ++i) {
                if (test[i].equals(actual[i])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String[]>> entrySet() {
        HashSet<Map.Entry<String, String[]>> set = new HashSet<Map.Entry<String, String[]>>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Enumeration headerEnum = this.request.getHeaders(key);
            set.add(new MapEntry<String, String[]>(key, this.enumeration2array(headerEnum), false));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        HttpServletRequest otherRequest = ((ServletHeaderValuesMap)o).request;
        boolean retValue = true;
        HttpServletRequest httpServletRequest = this.request;
        synchronized (httpServletRequest) {
            Enumeration attribs = this.request.getHeaderNames();
            while (attribs.hasMoreElements() && retValue) {
                String parameterName = (String)attribs.nextElement();
                retValue = this.request.getHeaders(parameterName).equals(otherRequest.getHeaders(parameterName));
            }
        }
        return retValue;
    }

    @Override
    public String[] get(Object key) {
        ArrayList list = new ArrayList();
        Enumeration values = this.request.getHeaders(this.key(key));
        while (values.hasMoreElements()) {
            list.add(values.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public int hashCode() {
        return this.request.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() < 1;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            set.add((String)keys.nextElement());
        }
        return set;
    }

    @Override
    public String[] put(String key, String[] value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String[]> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int n = 0;
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    @Override
    public Collection<String[]> values() {
        ArrayList<String[]> list = new ArrayList<String[]>();
        Enumeration keys = this.request.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Enumeration values = this.request.getHeaders(key);
            list.add(this.enumeration2array(values));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }

    private String[] enumeration2array(Enumeration<String> enumeration) {
        ArrayList<String> list1 = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            list1.add(enumeration.nextElement());
        }
        return list1.toArray(new String[list1.size()]);
    }
}

