/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataMethod;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataTable;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataAccessor {
    private boolean m_isProcessed = false;
    private Boolean m_isRelationship;
    protected MetadataLogger m_logger;
    protected MetadataProject m_project;
    protected MetadataProcessor m_processor;
    protected MetadataValidator m_validator;
    protected MetadataDescriptor m_descriptor;
    protected MetadataAccessibleObject m_accessibleObject;

    public MetadataAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        this(accessibleObject, classAccessor.getProcessor(), classAccessor.getDescriptor());
    }

    public MetadataAccessor(MetadataAccessibleObject accessibleObject, MetadataProcessor processor, MetadataDescriptor descriptor) {
        this.m_processor = processor;
        this.m_descriptor = descriptor;
        this.m_logger = processor.getLogger();
        this.m_project = processor.getProject();
        this.m_validator = processor.getValidator();
        this.m_accessibleObject = accessibleObject;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_accessibleObject.getAnnotatedElement();
    }

    protected <T extends Annotation> T getAnnotation(Class annotation) {
        return this.getAnnotation(annotation, this.getAnnotatedElement());
    }

    protected <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement) {
        return MetadataHelper.getAnnotation(annotation, annotatedElement, this.m_descriptor);
    }

    public String getAttributeName() {
        return this.m_accessibleObject.getAttributeName();
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public String getFetchType() {
        throw new RuntimeException("Development exception. The accessor: [" + this + "] should not call the getFetchType method unless it overrides it.");
    }

    public Class getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    protected Class getMapKeyClass() {
        return this.m_accessibleObject.getMapKeyClass();
    }

    public String getName() {
        return this.m_accessibleObject.getName();
    }

    protected String getName(DatabaseField field, String defaultName, String context) {
        return this.getName(field.getName(), defaultName, context);
    }

    protected String getName(String name, String defaultName, String context) {
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return "";
        }
        this.m_logger.logConfigMessage(context, this.getAnnotatedElement(), (Object)defaultName);
        return defaultName;
    }

    protected MetadataPrimaryKeyJoinColumns getPrimaryKeyJoinColumns(String sourceTableName, String targetTableName) {
        PrimaryKeyJoinColumn primaryKeyJoinColumn = (PrimaryKeyJoinColumn)this.getAnnotation(PrimaryKeyJoinColumn.class);
        PrimaryKeyJoinColumns primaryKeyJoinColumns = (PrimaryKeyJoinColumns)this.getAnnotation(PrimaryKeyJoinColumns.class);
        return new MetadataPrimaryKeyJoinColumns(primaryKeyJoinColumns, primaryKeyJoinColumn, sourceTableName, targetTableName);
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public MetadataProcessor getProcessor() {
        return this.m_processor;
    }

    public Class getRawClass() {
        return this.m_accessibleObject.getRawClass();
    }

    public Class getReferenceClass() {
        return this.m_accessibleObject.getRawClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        return this.m_project.getDescriptor(this.getReferenceClass());
    }

    protected Type getRelationType() {
        return this.m_accessibleObject.getRelationType();
    }

    protected String getSetMethodName() {
        return ((MetadataMethod)this.m_accessibleObject).getSetMethodName();
    }

    protected String getUpperCaseAttributeName() {
        return this.getAttributeName().toUpperCase();
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName(this.getJavaClassName()).toUpperCase();
    }

    public MetadataValidator getValidator() {
        return this.m_validator;
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasPrimaryKeyJoinColumns() {
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class);
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.isAnnotationPresent(annotation, this.getAnnotatedElement());
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotation, AnnotatedElement annotatedElement) {
        return MetadataHelper.isAnnotationPresent(annotation, annotatedElement, this.m_descriptor);
    }

    public boolean isBasic() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    public boolean isOptional() {
        throw new RuntimeException("Development exception. The accessor: [" + this + "] should not call the isOptional method unless it overrides it.");
    }

    public boolean isRelationship() {
        if (this.m_isRelationship == null) {
            this.m_isRelationship = new Boolean(this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne());
        }
        return this.m_isRelationship;
    }

    public boolean isXMLAccessor() {
        return false;
    }

    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    public abstract void process();

    protected ClassAccessor processAccessor(MetadataDescriptor descriptor) {
        ClassAccessor accessor = new ClassAccessor(new MetadataClass(descriptor.getJavaClass()), this.getProcessor(), descriptor);
        descriptor.setClassAccessor(accessor);
        accessor.process();
        return accessor;
    }

    protected List<MetadataPrimaryKeyJoinColumn> processPrimaryKeyJoinColumns(MetadataPrimaryKeyJoinColumns primaryKeyJoinColumns) {
        List<MetadataPrimaryKeyJoinColumn> pkJoinColumns = primaryKeyJoinColumns.values(this.m_descriptor);
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (pkJoinColumns.size() != this.m_descriptor.getPrimaryKeyFields().size()) {
                this.m_validator.throwIncompletePrimaryKeyJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
            }
            for (MetadataPrimaryKeyJoinColumn pkJoinColumn : pkJoinColumns) {
                if (!pkJoinColumn.isPrimaryKeyFieldNotSpecified() && !pkJoinColumn.isForeignKeyFieldNotSpecified()) continue;
                this.m_validator.throwIncompletePrimaryKeyJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
            }
        } else if (pkJoinColumns.size() > 1) {
            this.m_validator.throwExcessivePrimaryKeyJoinColumnsSpecified(this.getJavaClass(), this.getAnnotatedElement());
        }
        return pkJoinColumns;
    }

    protected void processTable(MetadataTable table, String defaultName) {
        String name = this.getName(table.getName(), defaultName, table.getNameContext());
        String catalog = this.getName(table.getCatalog(), this.m_descriptor.getCatalog(), table.getCatalogContext());
        String schema = this.getName(table.getSchema(), this.m_descriptor.getSchema(), table.getSchemaContext());
        table.setName(MetadataHelper.getFullyQualifiedTableName(name, catalog, schema));
    }

    protected void setAccessorMethods(DatabaseMapping mapping) {
        if (this.m_descriptor.usesPropertyAccess()) {
            mapping.setGetMethodName(this.getName());
            mapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_accessibleObject.setAnnotatedElement(annotatedElement);
    }

    protected void setIndirectionPolicy(CollectionMapping mapping, String mapKey) {
        Class rawClass = this.getRawClass();
        if (this.usesIndirection()) {
            if (rawClass == Map.class) {
                mapping.useTransparentMap(mapKey);
            } else if (rawClass == List.class) {
                mapping.useTransparentList();
            } else if (rawClass == Collection.class) {
                mapping.useTransparentCollection();
                mapping.setContainerPolicy(new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (rawClass == Set.class) {
                mapping.useTransparentSet();
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass == Map.class) {
                mapping.useMapClass(Hashtable.class, mapKey);
            } else if (rawClass == Set.class) {
                mapping.useCollectionClass(HashSet.class);
            } else {
                mapping.useCollectionClass(Vector.class);
            }
        }
    }

    public void setIsProcessed() {
        this.m_isProcessed = true;
    }

    public boolean usesIndirection() {
        return this.getFetchType().equals("LAZY");
    }
}

