/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.IdentificationVariableDeclNode;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.QueryNode;
import oracle.toplink.essentials.queryframework.DatabaseQuery;

public abstract class ModifyNode
extends QueryNode {
    private String abstractSchemaIdentifier;
    private String abstractSchemaName;

    public void applyToQuery(DatabaseQuery theQuery, GenerationContext context) {
    }

    public void validate(ParseTreeContext context) {
        String baseVariable = this.abstractSchemaIdentifier != null ? this.abstractSchemaIdentifier : this.abstractSchemaName;
        baseVariable = IdentificationVariableDeclNode.calculateCanonicalName(baseVariable);
        context.setBaseVariable(baseVariable);
        super.validate(context);
    }

    public Expression generateExpression(GenerationContext context) {
        return null;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public String getAbstractSchemaIdentifier() {
        return this.abstractSchemaIdentifier;
    }

    public void setAbstractSchemaIdentifier(String identifierName) {
        this.abstractSchemaIdentifier = identifierName;
    }

    public Class resolveClass(GenerationContext context) {
        String alias = this.abstractSchemaName;
        ClassDescriptor descriptor = context.getSession().getDescriptorForAlias(alias);
        if (descriptor == null) {
            throw EJBQLException.unknownAbstractSchemaType2(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), alias);
        }
        Class theClass = descriptor.getJavaClass();
        if (theClass == null) {
            throw EJBQLException.resolutionClassNotFoundException2(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), alias);
        }
        return theClass;
    }
}

