/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sessions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.queryframework.SQLResultSetMapping;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.DatabaseSession;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.threetier.ConnectionPolicy;
import oracle.toplink.essentials.threetier.Server;
import oracle.toplink.essentials.threetier.ServerSession;

public class Project
implements Serializable,
Cloneable {
    protected String name = "";
    protected Login datasourceLogin;
    protected Map descriptors = new HashMap();
    protected Vector orderedDescriptors;
    protected Vector defaultReadOnlyClasses = NonSynchronizedVector.newInstance();
    protected Map aliasDescriptors;
    protected boolean hasIsolatedClasses = false;
    protected boolean hasGenericHistorySupport = false;
    protected boolean hasProxyIndirection = false;
    protected boolean isPureCMP2Project = false;
    protected Map sqlResultSetMappings;

    public Project() {
        this.orderedDescriptors = NonSynchronizedVector.newInstance();
    }

    public Project(Login login) {
        this();
        this.datasourceLogin = login;
    }

    public Project(DatabaseLogin login) {
        this();
        this.datasourceLogin = login;
    }

    public void addDefaultReadOnlyClass(Class readOnlyClass) {
        this.getDefaultReadOnlyClasses().addElement(readOnlyClass);
    }

    public void addDescriptor(ClassDescriptor descriptor) {
        this.getOrderedDescriptors().add(descriptor);
        String alias = descriptor.getAlias();
        if (alias != null) {
            this.addAlias(alias, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
    }

    public void addDescriptor(ClassDescriptor descriptor, DatabaseSessionImpl session) {
        this.getOrderedDescriptors().add(descriptor);
        String alias = descriptor.getAlias();
        if (alias != null) {
            this.addAlias(alias, descriptor);
        }
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
        }
        session.initializeDescriptorIfSessionAlive(descriptor);
    }

    public void addDescriptors(Vector descriptors, DatabaseSessionImpl session) {
        Enumeration enumeration = descriptors.elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)enumeration.nextElement();
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
        if (session.isConnected()) {
            session.initializeDescriptors(descriptors);
            session.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(descriptors);
    }

    public void addDescriptors(Project project, DatabaseSessionImpl session) {
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
        if (session.isConnected()) {
            session.initializeDescriptors(project.getDescriptors());
            session.getCommitManager().initializeCommitOrder();
        }
        this.getOrderedDescriptors().addAll(project.getOrderedDescriptors());
    }

    public void addSQLResultSetMapping(SQLResultSetMapping sqlResultSetMapping) {
        if (sqlResultSetMapping == null || sqlResultSetMapping.getName() == null) {
            return;
        }
        if (this.sqlResultSetMappings == null) {
            this.sqlResultSetMappings = new HashMap();
        }
        this.sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
    }

    public void conformAllDescriptors() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.setShouldAlwaysConformResultsInUnitOfWork(true);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (ClassDescriptor descriptor : this.orderedDescriptors) {
            descriptor.convertClassNamesToClasses(classLoader);
        }
        if (this.sqlResultSetMappings != null) {
            Iterator mappingIt = this.sqlResultSetMappings.keySet().iterator();
            while (mappingIt.hasNext()) {
                SQLResultSetMapping mapping = (SQLResultSetMapping)this.sqlResultSetMappings.get(mappingIt.next());
                mapping.convertClassNamesToClasses(classLoader);
            }
        }
    }

    public void assumeExistenceForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().assumeExistenceForDoesExist();
        }
    }

    public void checkCacheForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().checkCacheForDoesExist();
        }
    }

    public void checkDatabaseForDoesExist() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.getQueryManager().checkDatabaseForDoesExist();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DatabaseSession createDatabaseSession() {
        return new DatabaseSessionImpl(this);
    }

    public Server createServerSession() {
        return new ServerSession(this);
    }

    public Server createServerSession(int min, int max) {
        return new ServerSession(this, min, max);
    }

    public Server createServerSession(ConnectionPolicy defaultConnectionPolicy) {
        return new ServerSession(this, defaultConnectionPolicy);
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.defaultReadOnlyClasses;
    }

    public ClassDescriptor getClassDescriptor(Class theClass) {
        ClassDescriptor desc = this.getDescriptor(theClass);
        if (desc instanceof ClassDescriptor) {
            return desc;
        }
        throw ValidationException.cannotCastToClass(desc, desc.getClass(), ClassDescriptor.class);
    }

    public ClassDescriptor getDescriptor(Class theClass) {
        return (ClassDescriptor)this.getDescriptors().get(theClass);
    }

    public Map getDescriptors() {
        if (this.descriptors.isEmpty() && !this.orderedDescriptors.isEmpty()) {
            for (ClassDescriptor descriptor : this.orderedDescriptors) {
                this.descriptors.put(descriptor.getJavaClass(), descriptor);
            }
        }
        return this.descriptors;
    }

    public Vector getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    public void setOrderedDescriptors(Vector orderedDescriptors) {
        this.orderedDescriptors = orderedDescriptors;
        Enumeration e = orderedDescriptors.elements();
        while (e.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)e.nextElement();
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
    }

    public DatabaseLogin getLogin() {
        return (DatabaseLogin)this.datasourceLogin;
    }

    public Login getDatasourceLogin() {
        return this.datasourceLogin;
    }

    public String getName() {
        return this.name;
    }

    public SQLResultSetMapping getSQLResultSetMapping(String sqlResultSetMapping) {
        if (sqlResultSetMapping == null || this.sqlResultSetMappings == null) {
            return null;
        }
        return (SQLResultSetMapping)this.sqlResultSetMappings.get(sqlResultSetMapping);
    }

    public boolean hasGenericHistorySupport() {
        return this.hasGenericHistorySupport;
    }

    public void setDefaultReadOnlyClasses(Vector newValue) {
        this.defaultReadOnlyClasses = (Vector)newValue.clone();
    }

    public void setDescriptors(Map descriptors) {
        this.descriptors = descriptors;
        for (ClassDescriptor descriptor : descriptors.values()) {
            String alias = descriptor.getAlias();
            if (alias == null) continue;
            this.addAlias(alias, descriptor);
        }
    }

    public void setHasGenericHistorySupport(boolean hasGenericHistorySupport) {
        this.hasGenericHistorySupport = hasGenericHistorySupport;
    }

    public boolean isPureCMP2Project() {
        return this.isPureCMP2Project;
    }

    public void setIsPureCMP2Project(boolean isPureCMP2Project) {
        this.isPureCMP2Project = isPureCMP2Project;
    }

    public boolean hasIsolatedClasses() {
        return this.hasIsolatedClasses;
    }

    public void setHasIsolatedClasses(boolean hasIsolatedClasses) {
        this.hasIsolatedClasses = hasIsolatedClasses;
    }

    public boolean hasProxyIndirection() {
        return this.hasProxyIndirection;
    }

    public void setHasProxyIndirection(boolean hasProxyIndirection) {
        this.hasProxyIndirection = hasProxyIndirection;
    }

    public void setLogin(DatabaseLogin datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setLogin(Login datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setDatasourceLogin(Login datasourceLogin) {
        this.datasourceLogin = datasourceLogin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + ")";
    }

    public void useCacheIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useCacheIdentityMap();
        }
    }

    public void useCacheIdentityMap(int cacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useCacheIdentityMap();
            descriptor.setIdentityMapSize(cacheSize);
        }
    }

    public void useFullIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useFullIdentityMap();
        }
    }

    public void useFullIdentityMap(int initialCacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useFullIdentityMap();
            descriptor.setIdentityMapSize(initialCacheSize);
        }
    }

    public void useNoIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useNoIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useSoftCacheWeakIdentityMap();
        }
    }

    public void useSoftCacheWeakIdentityMap(int cacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useSoftCacheWeakIdentityMap();
            descriptor.setIdentityMapSize(cacheSize);
        }
    }

    public boolean usesOptimisticLocking() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (!descriptor.usesOptimisticLocking()) continue;
            return true;
        }
        return false;
    }

    public boolean usesSequencing() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (!descriptor.usesSequenceNumbers()) continue;
            return true;
        }
        return false;
    }

    public void useWeakIdentityMap() {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useWeakIdentityMap();
        }
    }

    public void useWeakIdentityMap(int initialCacheSize) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            descriptor.useWeakIdentityMap();
            descriptor.setIdentityMapSize(initialCacheSize);
        }
    }

    public void applyLogin() {
    }

    public Map getAliasDescriptors() {
        return this.aliasDescriptors;
    }

    public void addAlias(String alias, ClassDescriptor descriptor) {
        if (this.aliasDescriptors == null) {
            this.aliasDescriptors = new Hashtable(10);
        }
        this.aliasDescriptors.put(alias, descriptor);
    }

    public void addAliasesFromProject(Project project) {
        for (ClassDescriptor descriptor : this.getDescriptors().values()) {
            if (descriptor.getAlias() == null) continue;
            this.addAlias(descriptor.getAlias(), descriptor);
        }
    }

    public ClassDescriptor getClassDescriptorForAlias(String alias) {
        ClassDescriptor d = null;
        if (this.aliasDescriptors != null) {
            d = (ClassDescriptor)this.aliasDescriptors.get(alias);
        }
        return d;
    }

    public ClassDescriptor getDescriptorForAlias(String alias) {
        ClassDescriptor d = null;
        if (this.aliasDescriptors != null) {
            d = (ClassDescriptor)this.aliasDescriptors.get(alias);
        }
        return d;
    }

    public void setAliasDescriptors(Map aHashtable) {
        this.aliasDescriptors = aHashtable;
    }
}

