/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DynamicMetaDataImpl;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.mbeanserver.StandardMetaDataImpl;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class MetaDataImpl
implements MetaData {
    private static final String dbgTag = "MetaDataImpl";
    private final DynamicMetaDataImpl dynamic;
    private final StandardMetaDataImpl standard;
    protected final MBeanInstantiator instantiator;
    static /* synthetic */ Class class$javax$management$DynamicMBean;

    public MetaDataImpl(MBeanInstantiator mBeanInstantiator) {
        if (mBeanInstantiator == null) {
            throw new IllegalArgumentException("instantiator must not be null.");
        }
        this.instantiator = mBeanInstantiator;
        this.dynamic = new PrivateDynamicMeta();
        this.standard = new PrivateStandardMeta();
    }

    protected MetaData getMetaData(Class clazz) {
        if ((class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = MetaDataImpl.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(clazz)) {
            return this.dynamic;
        }
        return this.standard;
    }

    protected MetaData getMetaData(Object object) {
        if (object instanceof DynamicMBean) {
            return this.dynamic;
        }
        return this.standard;
    }

    public synchronized void testCompliance(Class clazz) throws NotCompliantMBeanException {
        MetaData metaData = this.getMetaData(clazz);
        metaData.testCompliance(clazz);
    }

    public Class getMBeanInterfaceFromClass(Class clazz) {
        return this.standard.getMBeanInterfaceFromClass(clazz);
    }

    public MBeanInfo getMBeanInfoFromClass(Class clazz) throws IntrospectionException, NotCompliantMBeanException {
        return this.standard.getMBeanInfoFromClass(clazz);
    }

    public final String getMBeanClassName(Object object) throws IntrospectionException, NotCompliantMBeanException {
        MetaData metaData = this.getMetaData(object);
        return metaData.getMBeanClassName(object);
    }

    public final MBeanInfo getMBeanInfo(Object object) throws IntrospectionException {
        MetaData metaData = this.getMetaData(object);
        return metaData.getMBeanInfo(object);
    }

    public final Object getAttribute(Object object, String string) throws MBeanException, AttributeNotFoundException, ReflectionException {
        MetaData metaData = this.getMetaData(object);
        return metaData.getAttribute(object, string);
    }

    public final AttributeList getAttributes(Object object, String[] stringArray) throws ReflectionException {
        MetaData metaData = this.getMetaData(object);
        return metaData.getAttributes(object, stringArray);
    }

    public final AttributeList setAttributes(Object object, AttributeList attributeList) throws ReflectionException {
        MetaData metaData = this.getMetaData(object);
        return metaData.setAttributes(object, attributeList);
    }

    public final Object setAttribute(Object object, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MetaData metaData = this.getMetaData(object);
        return metaData.setAttribute(object, attribute);
    }

    public final Object invoke(Object object, String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Operation name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to invoke the operation on the MBean");
        }
        MetaData metaData = this.getMetaData(object);
        return metaData.invoke(object, string, objectArray, stringArray);
    }

    public boolean isInstanceOf(Object object, String string) throws ReflectionException {
        MetaData metaData = this.getMetaData(object);
        return metaData.isInstanceOf(object, string);
    }

    public ObjectName preRegisterInvoker(Object object, ObjectName objectName, MBeanServer mBeanServer) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (!(object instanceof MBeanRegistration)) {
            return objectName;
        }
        MetaData metaData = this.getMetaData(object);
        return metaData.preRegisterInvoker(object, objectName, mBeanServer);
    }

    public void postRegisterInvoker(Object object, boolean bl) {
        if (!(object instanceof MBeanRegistration)) {
            return;
        }
        MetaData metaData = this.getMetaData(object);
        metaData.postRegisterInvoker(object, bl);
    }

    public void preDeregisterInvoker(Object object) throws MBeanRegistrationException {
        if (!(object instanceof MBeanRegistration)) {
            return;
        }
        MetaData metaData = this.getMetaData(object);
        metaData.preDeregisterInvoker(object);
    }

    public void postDeregisterInvoker(Object object) {
        if (!(object instanceof MBeanRegistration)) {
            return;
        }
        MetaData metaData = this.getMetaData(object);
        metaData.postDeregisterInvoker(object);
    }

    protected Class findClass(String string, ClassLoader classLoader) throws ReflectionException {
        return this.instantiator.findClass(string, classLoader);
    }

    protected Class[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        return stringArray == null ? null : this.instantiator.findSignatureClasses(stringArray, classLoader);
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        MetaDataImpl.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        MetaDataImpl.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (MetaDataImpl.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            MetaDataImpl.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            MetaDataImpl.debug(dbgTag, string, string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class PrivateDynamicMeta
    extends DynamicMetaDataImpl {
        PrivateDynamicMeta() {
        }

        protected Class findClass(String string, ClassLoader classLoader) throws ReflectionException {
            return MetaDataImpl.this.findClass(string, classLoader);
        }

        protected Class[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
            return MetaDataImpl.this.findSignatureClasses(stringArray, classLoader);
        }
    }

    private final class PrivateStandardMeta
    extends StandardMetaDataImpl {
        PrivateStandardMeta() {
        }

        protected Class findClass(String string, ClassLoader classLoader) throws ReflectionException {
            return MetaDataImpl.this.findClass(string, classLoader);
        }

        protected Class[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
            return MetaDataImpl.this.findSignatureClasses(stringArray, classLoader);
        }
    }
}

