/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.IArityNode;
import org.jruby.runtime.builtin.IRubyObject;

public final class Arity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map arities;
    private final int value;
    public static final Arity NO_ARGUMENTS;
    public static final Arity ONE_ARGUMENT;
    public static final Arity TWO_ARGUMENTS;
    public static final Arity THREE_ARGUMENTS;
    public static final Arity OPTIONAL;
    public static final Arity ONE_REQUIRED;
    public static final Arity TWO_REQUIRED;
    public static final Arity THREE_REQUIRED;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Arity(int value) {
        this.value = value;
    }

    public static Arity createArity(int value) {
        switch (value) {
            case -4: {
                return THREE_REQUIRED;
            }
            case -3: {
                return TWO_REQUIRED;
            }
            case -2: {
                return ONE_REQUIRED;
            }
            case -1: {
                return OPTIONAL;
            }
            case 0: {
                return NO_ARGUMENTS;
            }
            case 1: {
                return ONE_ARGUMENT;
            }
            case 2: {
                return TWO_ARGUMENTS;
            }
            case 3: {
                return THREE_ARGUMENTS;
            }
        }
        return Arity.newArity(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Arity newArity(int value) {
        Arity result;
        Integer integerValue = new Integer(value);
        Map map = arities;
        synchronized (map) {
            result = (Arity)arities.get(integerValue);
            if (result == null) {
                result = new Arity(value);
                arities.put(integerValue, result);
            }
        }
        return result;
    }

    public static Arity fixed(int arity) {
        if (!$assertionsDisabled && arity < 0) {
            throw new AssertionError();
        }
        return Arity.createArity(arity);
    }

    public static Arity optional() {
        return OPTIONAL;
    }

    public static Arity required(int minimum) {
        if (!$assertionsDisabled && minimum < 0) {
            throw new AssertionError();
        }
        return Arity.createArity(-(1 + minimum));
    }

    public static Arity noArguments() {
        return NO_ARGUMENTS;
    }

    public static Arity singleArgument() {
        return ONE_ARGUMENT;
    }

    public static Arity twoArguments() {
        return TWO_ARGUMENTS;
    }

    public static Arity procArityOf(Node node) {
        if (node instanceof AttrAssignNode && node != null) {
            node = ((AttrAssignNode)node).getArgsNode();
        }
        if (node == null) {
            return Arity.optional();
        }
        if (node instanceof IArityNode) {
            return ((IArityNode)((Object)node)).getArity();
        }
        if (node instanceof CallNode) {
            return Arity.singleArgument();
        }
        if (node instanceof ArrayNode) {
            return Arity.singleArgument();
        }
        throw new Error("unexpected type " + node.getClass() + " at " + node.getPosition());
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(Ruby runtime, IRubyObject[] args) {
        if (this.isFixed() ? args.length != this.required() : args.length < this.required()) {
            throw runtime.newArgumentError("wrong number of arguments(" + args.length + " for " + this.required() + ")");
        }
    }

    public boolean isFixed() {
        return this.value >= 0;
    }

    public int required() {
        if (this.value < 0) {
            return -(1 + this.value);
        }
        return this.value;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.isFixed()) {
            return "Fixed" + this.required();
        }
        return "Opt";
    }

    public static int checkArgumentCount(Ruby runtime, IRubyObject[] args, int min, int max) {
        if (args.length < min) {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + min + ")");
        }
        if (max > -1 && args.length > max) {
            throw runtime.newArgumentError("wrong number of arguments (" + args.length + " for " + max + ")");
        }
        return args.length;
    }

    public static IRubyObject[] scanArgs(Ruby runtime, IRubyObject[] args, int required, int optional) {
        int total = required + optional;
        int real = Arity.checkArgumentCount(runtime, args, required, total);
        IRubyObject[] narr = new IRubyObject[total];
        System.arraycopy(args, 0, narr, 0, real);
        for (int i = real; i < total; ++i) {
            narr[i] = runtime.getNil();
        }
        return narr;
    }

    static {
        $assertionsDisabled = !Arity.class.desiredAssertionStatus();
        arities = new HashMap();
        NO_ARGUMENTS = Arity.newArity(0);
        ONE_ARGUMENT = Arity.newArity(1);
        TWO_ARGUMENTS = Arity.newArity(2);
        THREE_ARGUMENTS = Arity.newArity(3);
        OPTIONAL = Arity.newArity(-1);
        ONE_REQUIRED = Arity.newArity(-2);
        TWO_REQUIRED = Arity.newArity(-3);
        THREE_REQUIRED = Arity.newArity(-3);
    }
}

