/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jruby.util.NormalizedFile;

public class Glob {
    private final List patterns;
    private static final Pattern BRACE_PATTERN = Pattern.compile("(.*)\\{([^\\{\\}]*)\\}(.*)");

    public Glob(String cwd, String pattern) {
        List expansion = new ArrayList<String>();
        expansion.add(pattern);
        expansion = Glob.splitPatternBraces(expansion);
        cwd = Glob.canonicalize(cwd);
        int size = expansion.size();
        this.patterns = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            String newPattern = (String)expansion.get(i);
            this.patterns.add(i, new GlobPattern(cwd, newPattern));
        }
    }

    private static String canonicalize(String path) {
        try {
            return new NormalizedFile(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    private static List splitPatternBraces(List dirs) {
        for (int i = 0; i < dirs.size(); ++i) {
            String fragment = (String)dirs.get(i);
            Matcher matcher = BRACE_PATTERN.matcher(fragment);
            if (!matcher.find()) continue;
            dirs.remove(i);
            String beforeBrace = matcher.group(1);
            String[] subElementList = matcher.group(2).split(",");
            String afterBrace = matcher.group(3);
            for (int j = 0; j < subElementList.length; ++j) {
                dirs.add(beforeBrace + subElementList[j] + afterBrace);
            }
        }
        return dirs;
    }

    private void getFiles() {
        String pathSplitter = "/";
        Iterator iter = this.patterns.iterator();
        while (iter.hasNext()) {
            GlobPattern globPattern = (GlobPattern)iter.next();
            String[] dirs = globPattern.getPattern().split(pathSplitter);
            NormalizedFile root = new NormalizedFile(dirs[0]);
            int idx = 1;
            if (Glob.glob2Regexp(dirs[0]) != null) {
                root = new NormalizedFile(".");
                idx = 0;
            }
            int size = dirs.length;
            while (idx < size && Glob.glob2Regexp(dirs[idx]) == null) {
                root = new NormalizedFile(root, dirs[idx]);
                ++idx;
            }
            ArrayList<NormalizedFile> matchingFiles = new ArrayList<NormalizedFile>();
            if (idx == dirs.length) {
                if (root.exists()) {
                    matchingFiles.add(root);
                }
                globPattern.setMatchedFiles(matchingFiles);
                continue;
            }
            matchingFiles.add(root);
            int length = dirs.length;
            while (idx < length) {
                ArrayList currentMatchingFiles = new ArrayList();
                int size2 = matchingFiles.size();
                for (int i = 0; i < size2; ++i) {
                    boolean isDirectory = idx + 1 != length;
                    String pattern = dirs[idx];
                    NormalizedFile parent = (NormalizedFile)matchingFiles.get(i);
                    currentMatchingFiles.addAll(Glob.getMatchingFiles(parent, pattern, isDirectory));
                }
                matchingFiles = currentMatchingFiles;
                ++idx;
            }
            globPattern.setMatchedFiles(matchingFiles);
        }
    }

    private static Collection getMatchingFiles(NormalizedFile parent, String pattern, final boolean isDirectory) {
        String expandedPattern = Glob.glob2Regexp(pattern);
        if (expandedPattern == null) {
            expandedPattern = pattern;
        }
        final Pattern p = Pattern.compile(expandedPattern);
        final boolean firstDot = pattern.length() > 0 && pattern.charAt(0) == '.';
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                String n = pathname.getName();
                return !(!pathname.isDirectory() && isDirectory || !p.matcher(n).matches() || !firstDot && n.length() != 0 && n.charAt(0) == '.');
            }
        };
        NormalizedFile[] matchArray = (NormalizedFile[])parent.listFiles(filter);
        ArrayList<NormalizedFile> matchingFiles = new ArrayList<NormalizedFile>();
        if (matchArray != null) {
            for (int i = 0; i < matchArray.length; ++i) {
                matchingFiles.add(matchArray[i]);
                if (!pattern.equals("**") || !matchArray[i].isDirectory()) continue;
                matchingFiles.addAll(Glob.getMatchingFiles(matchArray[i], pattern, isDirectory));
            }
        }
        if ("**".equals(pattern)) {
            matchingFiles.add(parent);
        }
        return matchingFiles;
    }

    public String[] getNames() {
        try {
            this.getFiles();
        }
        catch (PatternSyntaxException e) {
            return new String[0];
        }
        TreeSet allMatchedNames = new TreeSet();
        Iterator iter = this.patterns.iterator();
        while (iter.hasNext()) {
            GlobPattern pattern = (GlobPattern)iter.next();
            allMatchedNames.addAll(pattern.getMatchedFiles());
        }
        return allMatchedNames.toArray(new String[allMatchedNames.size()]);
    }

    private static String glob2Regexp(String s) {
        StringBuffer t = new StringBuffer(s.length());
        boolean pattern = false;
        int mode = 0;
        boolean escape = false;
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (escape) {
                t.append(c);
                escape = false;
                continue;
            }
            switch (mode) {
                case 0: {
                    switch (c) {
                        case '*': {
                            pattern = true;
                            t.append(".*");
                            continue block10;
                        }
                        case '?': {
                            pattern = true;
                            t.append('.');
                            continue block10;
                        }
                        case '[': {
                            pattern = true;
                            t.append(c);
                            mode = 1;
                            continue block10;
                        }
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case '.': 
                        case '^': 
                        case '|': {
                            t.append('\\');
                        }
                    }
                    t.append(c);
                    continue block10;
                }
                case 1: {
                    t.append(c);
                    if (c != ']') continue block10;
                    mode = 0;
                    continue block10;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return pattern ? t.toString() : null;
    }

    private class GlobPattern {
        private String pattern;
        private String cwd;
        private boolean endsWithDelimeter;
        private boolean patternIsRelative;
        private ArrayList files = null;

        public GlobPattern(String cwd, String pattern) {
            this.cwd = cwd;
            boolean bl = this.endsWithDelimeter = pattern.endsWith("/") || pattern.endsWith("\\");
            if (new NormalizedFile(pattern).isAbsolute()) {
                this.patternIsRelative = false;
                this.pattern = Glob.canonicalize(pattern);
            } else {
                this.patternIsRelative = true;
                this.pattern = Glob.canonicalize(new NormalizedFile(cwd, pattern).getAbsolutePath());
            }
        }

        public ArrayList getMatchedFiles() {
            ArrayList<String> fileNames = new ArrayList<String>();
            int size = this.files.size();
            int offset = this.cwd.endsWith("/") ? 0 : 1;
            for (int i = 0; i < size; ++i) {
                String path = ((NormalizedFile)this.files.get(i)).getPath();
                String name = this.patternIsRelative && !path.equals(this.cwd) && path.startsWith(this.cwd) ? path.substring(this.cwd.length() + offset) : path;
                if (this.endsWithDelimeter) {
                    name = name + "/";
                }
                fileNames.add(name.replace('\\', '/'));
            }
            return fileNames;
        }

        public void setMatchedFiles(ArrayList files) {
            this.files = files;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

