/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.PrimaryRow;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.SecondaryRow;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.util.InternalException;

public class RowManagerImpl
implements RowManager {
    private Map _inserts = null;
    private Map _updates = null;
    private Map _deletes = null;
    private Collection _secondaryUpdates = null;
    private Collection _secondaryDeletes = null;
    private Collection _allRowUpdates = null;
    private Collection _allRowDeletes = null;
    private final List _primaryOrder;
    private boolean _auto = false;
    private Key _key = null;
    private PrimaryRow _row = null;

    public RowManagerImpl(boolean order) {
        this._primaryOrder = order ? new ArrayList() : null;
    }

    public boolean hasAutoAssignConstraints() {
        return this._auto;
    }

    public List getOrdered() {
        return this._primaryOrder == null ? Collections.EMPTY_LIST : this._primaryOrder;
    }

    public Collection getInserts() {
        return this._inserts == null ? Collections.EMPTY_LIST : this._inserts.values();
    }

    public Collection getUpdates() {
        return this._updates == null ? Collections.EMPTY_LIST : this._updates.values();
    }

    public Collection getDeletes() {
        return this._deletes == null ? Collections.EMPTY_LIST : this._deletes.values();
    }

    public Collection getSecondaryUpdates() {
        return this._secondaryUpdates == null ? Collections.EMPTY_LIST : this._secondaryUpdates;
    }

    public Collection getSecondaryDeletes() {
        return this._secondaryDeletes == null ? Collections.EMPTY_LIST : this._secondaryDeletes;
    }

    public Collection getAllRowUpdates() {
        return this._allRowUpdates == null ? Collections.EMPTY_LIST : this._allRowUpdates;
    }

    public Collection getAllRowDeletes() {
        return this._allRowDeletes == null ? Collections.EMPTY_LIST : this._allRowDeletes;
    }

    public Row getSecondaryRow(Table table, int action) {
        return new SecondaryRow(table, action);
    }

    public void flushSecondaryRow(Row row) throws SQLException {
        if (!row.isValid()) {
            return;
        }
        SecondaryRow srow = (SecondaryRow)row;
        if (srow.getAction() == 2) {
            if (this._secondaryDeletes == null) {
                this._secondaryDeletes = new ArrayList();
            }
            this._secondaryDeletes.add(srow.clone());
        } else {
            if (this._secondaryUpdates == null) {
                this._secondaryUpdates = new ArrayList();
            }
            this._secondaryUpdates.add(srow.clone());
        }
    }

    public Row getAllRows(Table table, int action) {
        return new RowImpl(table, action);
    }

    public void flushAllRows(Row row) {
        if (!row.isValid()) {
            return;
        }
        switch (row.getAction()) {
            case 0: {
                if (this._allRowUpdates == null) {
                    this._allRowUpdates = new ArrayList();
                }
                this._allRowUpdates.add(row);
                break;
            }
            case 2: {
                if (this._allRowDeletes == null) {
                    this._allRowDeletes = new ArrayList();
                }
                this._allRowDeletes.add(row);
                break;
            }
            default: {
                throw new InternalException("action = " + row.getAction());
            }
        }
    }

    public Row getRow(Table table, int action, OpenJPAStateManager sm, boolean create) {
        Map map;
        if (sm == null) {
            return null;
        }
        if (this._key != null && this._key.table == table && this._key.sm == sm && this._row != null && this._row.getAction() == action) {
            return this._row;
        }
        if (action == 2) {
            if (this._deletes == null && create) {
                this._deletes = new HashMap();
            }
            map = this._deletes;
        } else if (action == 1) {
            if (this._inserts == null && create) {
                this._inserts = new HashMap();
            }
            map = this._inserts;
        } else {
            if (this._updates == null && create) {
                this._updates = new HashMap();
            }
            map = this._updates;
        }
        if (map == null) {
            return null;
        }
        this._key = new Key(table, sm);
        this._row = (PrimaryRow)map.get(this._key);
        if (this._row == null && create) {
            this._row = new PrimaryRow(table, action, sm);
            map.put(this._key, this._row);
            if (this._primaryOrder != null) {
                this._row.setIndex(this._primaryOrder.size());
                this._primaryOrder.add(this._row);
            }
            if (!this._auto && action == 1) {
                boolean bl = this._auto = table.getAutoAssignedColumns().length > 0;
            }
        }
        if (this._row != null) {
            this._row.setFailedObject(sm.getManagedInstance());
        }
        return this._row;
    }

    private static class Key {
        public final Table table;
        public final OpenJPAStateManager sm;

        public Key(Table table, OpenJPAStateManager sm) {
            this.table = table;
            this.sm = sm;
        }

        public int hashCode() {
            return (this.table.hashCode() + this.sm.hashCode()) % Integer.MAX_VALUE;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            Key key = (Key)other;
            return this.table == key.table && this.sm == key.sm;
        }
    }
}

