/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.BootstrapException;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.ProductDerivation;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Services;

public class ProductDerivations {
    private static final Localizer _loc;
    private static final ProductDerivation[] _derivations;
    private static final String[] _derivationNames;
    private static final Throwable[] _derivationErrors;
    private static String[] _prefixes;

    public static ProductDerivation[] getProductDerivations() {
        return _derivations;
    }

    public static String[] getConfigurationPrefixes() {
        return _prefixes;
    }

    static void setConfigurationPrefixes(String[] prefixes) {
        _prefixes = prefixes;
    }

    public static String getConfigurationKey(String partialKey, Map map) {
        String firstKey = null;
        for (int i = 0; map != null && i < _prefixes.length; ++i) {
            String fullKey = _prefixes[i] + "." + partialKey;
            if (!map.containsKey(fullKey)) continue;
            if (firstKey == null) {
                firstKey = fullKey;
                continue;
            }
            throw new IllegalStateException(_loc.get("dup-with-different-prefixes", firstKey, fullKey).getMessage());
        }
        if (firstKey == null) {
            return _prefixes[0] + "." + partialKey;
        }
        return firstKey;
    }

    public static void beforeConfigurationConstruct(ConfigurationProvider cp) {
        for (int i = 0; i < _derivations.length; ++i) {
            try {
                _derivations[i].beforeConfigurationConstruct(cp);
                continue;
            }
            catch (BootstrapException be) {
                if (!be.isFatal()) continue;
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void beforeConfigurationLoad(Configuration conf) {
        for (int i = 0; i < _derivations.length; ++i) {
            try {
                _derivations[i].beforeConfigurationLoad(conf);
                continue;
            }
            catch (BootstrapException be) {
                if (!be.isFatal()) continue;
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void afterSpecificationSet(Configuration conf) {
        for (int i = 0; i < _derivations.length; ++i) {
            try {
                _derivations[i].afterSpecificationSet(conf);
                continue;
            }
            catch (BootstrapException be) {
                if (!be.isFatal()) continue;
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void beforeClose(Configuration conf) {
        for (int i = 0; i < _derivations.length; ++i) {
            try {
                _derivations[i].beforeConfigurationClose(conf);
                continue;
            }
            catch (Exception e) {
                conf.getConfigurationLog().warn(_loc.get("before-close-ex"), e);
            }
        }
    }

    public static ConfigurationProvider load(String resource, String anchor, ClassLoader loader) {
        if (StringUtils.isEmpty((String)resource)) {
            return null;
        }
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        ConfigurationProvider provider = null;
        StringBuffer errs = null;
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                provider = _derivations[i].load(resource, anchor, loader);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuffer() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + t);
            }
        }
        ProductDerivations.reportErrors(errs, resource, err);
        String rsrc = resource + "#" + anchor;
        throw (MissingResourceException)JavaVersions.initCause(new MissingResourceException(rsrc, ProductDerivations.class.getName(), rsrc), err);
    }

    public static ConfigurationProvider load(File file, String anchor, ClassLoader loader) {
        if (file == null) {
            return null;
        }
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        ConfigurationProvider provider = null;
        StringBuffer errs = null;
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                provider = _derivations[i].load(file, anchor);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuffer() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + t);
            }
        }
        String aPath = (String)AccessController.doPrivileged(J2DoPrivHelper.getAbsolutePathAction(file));
        ProductDerivations.reportErrors(errs, aPath, err);
        String rsrc = aPath + "#" + anchor;
        throw (MissingResourceException)JavaVersions.initCause(new MissingResourceException(rsrc, ProductDerivations.class.getName(), rsrc), err);
    }

    public static ConfigurationProvider loadDefaults(ClassLoader loader) {
        return ProductDerivations.load(loader, false);
    }

    public static ConfigurationProvider loadGlobals(ClassLoader loader) {
        return ProductDerivations.load(loader, true);
    }

    private static ConfigurationProvider load(ClassLoader loader, boolean globals) {
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        ConfigurationProvider provider = null;
        StringBuffer errs = null;
        String type = globals ? "globals" : "defaults";
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                ConfigurationProvider configurationProvider = provider = globals ? _derivations[i].loadGlobals(loader) : _derivations[i].loadDefaults(loader);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuffer() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + t);
            }
        }
        ProductDerivations.reportErrors(errs, type, err);
        return null;
    }

    private static void reportErrors(StringBuffer errs, String resource, Throwable nested) {
        if (errs == null) {
            return;
        }
        throw (MissingResourceException)JavaVersions.initCause(new MissingResourceException(errs.toString(), ProductDerivations.class.getName(), resource), nested);
    }

    public static List getFullyQualifiedAnchorsInPropertiesLocation(String propertiesLocation) {
        ArrayList fqAnchors = new ArrayList();
        StringBuffer errs = null;
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                if (propertiesLocation == null) {
                    String loc = _derivations[i].getDefaultResourceLocation();
                    ProductDerivations.addAll(fqAnchors, loc, _derivations[i].getAnchorsInResource(loc));
                    continue;
                }
                File f = new File(propertiesLocation);
                if (((Boolean)J2DoPrivHelper.isFileAction(f).run()).booleanValue()) {
                    ProductDerivations.addAll(fqAnchors, propertiesLocation, _derivations[i].getAnchorsInFile(f));
                    continue;
                }
                f = new File("META-INF" + File.separatorChar + propertiesLocation);
                if (((Boolean)J2DoPrivHelper.isFileAction(f).run()).booleanValue()) {
                    ProductDerivations.addAll(fqAnchors, propertiesLocation, _derivations[i].getAnchorsInFile(f));
                    continue;
                }
                ProductDerivations.addAll(fqAnchors, propertiesLocation, _derivations[i].getAnchorsInResource(propertiesLocation));
                continue;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuffer() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + t);
            }
        }
        ProductDerivations.reportErrors(errs, propertiesLocation, err);
        return fqAnchors;
    }

    private static void addAll(Collection collection, String base, Collection newMembers) {
        if (newMembers == null || collection == null) {
            return;
        }
        Iterator iter = newMembers.iterator();
        while (iter.hasNext()) {
            String fqLoc = base + "#" + iter.next();
            if (collection.contains(fqLoc)) continue;
            collection.add(fqLoc);
        }
    }

    public static void main(String[] args) {
        System.err.println(ProductDerivations.derivationErrorsToString());
    }

    private static String derivationErrorsToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ProductDerivations: ").append(_derivationNames.length);
        for (int i = 0; i < _derivationNames.length; ++i) {
            buf.append("\n").append(i + 1).append(". ").append(_derivationNames[i]).append(": ");
            if (_derivationErrors[i] == null) {
                buf.append("OK");
                continue;
            }
            buf.append(_derivationErrors[i].toString());
        }
        return buf.toString();
    }

    static {
        int i;
        _loc = Localizer.forPackage(ProductDerivations.class);
        ClassLoader l = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(ProductDerivation.class));
        _derivationNames = Services.getImplementors(ProductDerivation.class, l);
        _derivationErrors = new Throwable[_derivationNames.length];
        ArrayList<ProductDerivation> derivations = new ArrayList<ProductDerivation>(_derivationNames.length);
        for (i = 0; i < _derivationNames.length; ++i) {
            try {
                ProductDerivation d = (ProductDerivation)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(Class.forName(_derivationNames[i], true, l)));
                d.validate();
                derivations.add(d);
                continue;
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                ProductDerivations._derivationErrors[i] = t2;
            }
        }
        if (derivations.isEmpty()) {
            throw new MissingResourceException(_loc.get("no-product-derivations", ProductDerivation.class.getName(), ProductDerivations.derivationErrorsToString()).getMessage(), ProductDerivations.class.getName(), "derivations");
        }
        for (i = 0; i < _derivationErrors.length; ++i) {
            if (_derivationErrors[i] == null) continue;
            System.err.println(_loc.get("bad-product-derivations", ProductDerivations.class.getName()));
            break;
        }
        Collections.sort(derivations, new ProductDerivationComparator());
        _derivations = derivations.toArray(new ProductDerivation[derivations.size()]);
        ArrayList<String> prefixes = new ArrayList<String>(2);
        for (int i2 = 0; i2 < _derivations.length; ++i2) {
            if (_derivations[i2].getConfigurationPrefix() == null || "openjpa".equals(_derivations[i2].getConfigurationPrefix())) continue;
            prefixes.add(_derivations[i2].getConfigurationPrefix());
        }
        String[] prefixArray = new String[1 + prefixes.size()];
        prefixArray[0] = "openjpa";
        for (int i3 = 0; i3 < prefixes.size(); ++i3) {
            prefixArray[i3 + 1] = (String)prefixes.get(i3);
        }
        ProductDerivations.setConfigurationPrefixes(prefixArray);
    }

    private static class ProductDerivationComparator
    implements Comparator {
        private ProductDerivationComparator() {
        }

        public int compare(Object o1, Object o2) {
            int type2;
            int type1 = ((ProductDerivation)o1).getType();
            if (type1 != (type2 = ((ProductDerivation)o2).getType())) {
                return type1 - type2;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    }
}

