/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataInheritanceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceOrderedMetaDataList
implements Serializable {
    private MetaDataInheritanceComparator _comp = new MetaDataInheritanceComparator();
    private LinkedList<ClassMetaData> buffer = new LinkedList();

    public boolean add(ClassMetaData meta) {
        if (meta == null || this.buffer.contains(meta)) {
            return false;
        }
        ListIterator<ClassMetaData> itr = this.buffer.listIterator();
        while (itr.hasNext()) {
            int ord = this._comp.compare(meta, itr.next());
            if (ord > 0) continue;
            if (ord == 0) {
                return false;
            }
            itr.previous();
            itr.add(meta);
            return true;
        }
        this.buffer.add(meta);
        return true;
    }

    public boolean remove(ClassMetaData meta) {
        return this.buffer.remove(meta);
    }

    public ClassMetaData peek() {
        return this.buffer.peek();
    }

    public int size() {
        return this.buffer.size();
    }

    public Iterator<ClassMetaData> iterator() {
        return this.buffer.iterator();
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void clear() {
        this.buffer.clear();
    }
}

