/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.LockModeType;
import org.apache.openjpa.kernel.DelegatingFetchConfiguration;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.PersistenceExceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchPlanImpl
implements FetchPlan {
    private final DelegatingFetchConfiguration _fetch;

    public FetchPlanImpl(FetchConfiguration fetch) {
        this._fetch = this.newDelegatingFetchConfiguration(fetch);
    }

    protected DelegatingFetchConfiguration newDelegatingFetchConfiguration(FetchConfiguration fetch) {
        return new DelegatingFetchConfiguration(fetch, PersistenceExceptions.TRANSLATOR);
    }

    @Override
    public FetchConfiguration getDelegate() {
        return this._fetch.getDelegate();
    }

    @Override
    public int getMaxFetchDepth() {
        return this._fetch.getMaxFetchDepth();
    }

    @Override
    public FetchPlan setMaxFetchDepth(int depth) {
        this._fetch.setMaxFetchDepth(depth);
        return this;
    }

    @Override
    public int getFetchBatchSize() {
        return this._fetch.getFetchBatchSize();
    }

    @Override
    public FetchPlan setFetchBatchSize(int fetchBatchSize) {
        this._fetch.setFetchBatchSize(fetchBatchSize);
        return this;
    }

    @Override
    public boolean getQueryResultCacheEnabled() {
        return this._fetch.getQueryCacheEnabled();
    }

    @Override
    public FetchPlan setQueryResultCacheEnabled(boolean cache) {
        this._fetch.setQueryCacheEnabled(cache);
        return this;
    }

    @Override
    public boolean getQueryResultCache() {
        return this.getQueryResultCacheEnabled();
    }

    @Override
    public FetchPlan setQueryResultCache(boolean cache) {
        return this.setQueryResultCacheEnabled(cache);
    }

    @Override
    public Collection<String> getFetchGroups() {
        return this._fetch.getFetchGroups();
    }

    @Override
    public FetchPlan addFetchGroup(String group) {
        this._fetch.addFetchGroup(group);
        return this;
    }

    @Override
    public FetchPlan addFetchGroups(String ... groups) {
        return this.addFetchGroups(Arrays.asList(groups));
    }

    @Override
    public FetchPlan addFetchGroups(Collection groups) {
        this._fetch.addFetchGroups(groups);
        return this;
    }

    @Override
    public FetchPlan removeFetchGroup(String group) {
        this._fetch.removeFetchGroup(group);
        return this;
    }

    @Override
    public FetchPlan removeFetchGroups(String ... groups) {
        return this.removeFetchGroups(Arrays.asList(groups));
    }

    @Override
    public FetchPlan removeFetchGroups(Collection groups) {
        this._fetch.removeFetchGroups(groups);
        return this;
    }

    @Override
    public FetchPlan clearFetchGroups() {
        this._fetch.clearFetchGroups();
        return this;
    }

    @Override
    public FetchPlan resetFetchGroups() {
        this._fetch.resetFetchGroups();
        return this;
    }

    @Override
    public Collection<String> getFields() {
        return this._fetch.getFields();
    }

    @Override
    public boolean hasField(String field) {
        return this._fetch.hasField(field);
    }

    @Override
    public boolean hasField(Class cls, String field) {
        return this.hasField(FetchPlanImpl.toFieldName(cls, field));
    }

    @Override
    public FetchPlan addField(String field) {
        this._fetch.addField(field);
        return this;
    }

    @Override
    public FetchPlan addField(Class cls, String field) {
        return this.addField(FetchPlanImpl.toFieldName(cls, field));
    }

    @Override
    public FetchPlan addFields(String ... fields) {
        return this.addFields(Arrays.asList(fields));
    }

    @Override
    public FetchPlan addFields(Class cls, String ... fields) {
        return this.addFields(cls, Arrays.asList(fields));
    }

    @Override
    public FetchPlan addFields(Collection fields) {
        this._fetch.addFields(fields);
        return this;
    }

    @Override
    public FetchPlan addFields(Class cls, Collection fields) {
        return this.addFields(FetchPlanImpl.toFieldNames(cls, fields));
    }

    @Override
    public FetchPlan removeField(String field) {
        this._fetch.removeField(field);
        return this;
    }

    @Override
    public FetchPlan removeField(Class cls, String field) {
        return this.removeField(FetchPlanImpl.toFieldName(cls, field));
    }

    @Override
    public FetchPlan removeFields(String ... fields) {
        return this.removeFields(Arrays.asList(fields));
    }

    @Override
    public FetchPlan removeFields(Class cls, String ... fields) {
        return this.removeFields(cls, Arrays.asList(fields));
    }

    @Override
    public FetchPlan removeFields(Collection fields) {
        this._fetch.removeFields(fields);
        return this;
    }

    @Override
    public FetchPlan removeFields(Class cls, Collection fields) {
        return this.removeFields(FetchPlanImpl.toFieldNames(cls, fields));
    }

    @Override
    public FetchPlan clearFields() {
        this._fetch.clearFields();
        return this;
    }

    private static String toFieldName(Class cls, String field) {
        return cls.getName() + "." + field;
    }

    private static Collection toFieldNames(Class cls, Collection fields) {
        if (fields.isEmpty()) {
            return fields;
        }
        ArrayList<String> names = new ArrayList<String>(fields);
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            names.add(FetchPlanImpl.toFieldName(cls, (String)itr.next()));
        }
        return names;
    }

    @Override
    public int getLockTimeout() {
        return this._fetch.getLockTimeout();
    }

    @Override
    public FetchPlan setLockTimeout(int timeout) {
        this._fetch.setLockTimeout(timeout);
        return this;
    }

    @Override
    public LockModeType getReadLockMode() {
        return EntityManagerImpl.fromLockLevel(this._fetch.getReadLockLevel());
    }

    @Override
    public FetchPlan setReadLockMode(LockModeType mode) {
        this._fetch.setReadLockLevel(EntityManagerImpl.toLockLevel(mode));
        return this;
    }

    @Override
    public LockModeType getWriteLockMode() {
        return EntityManagerImpl.fromLockLevel(this._fetch.getWriteLockLevel());
    }

    @Override
    public FetchPlan setWriteLockMode(LockModeType mode) {
        this._fetch.setWriteLockLevel(EntityManagerImpl.toLockLevel(mode));
        return this;
    }

    public int hashCode() {
        return this._fetch.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FetchPlanImpl)) {
            return false;
        }
        return this._fetch.equals(((FetchPlanImpl)other)._fetch);
    }
}

