/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.io.IRepeatableInputStream;
import org.jets3t.service.io.InputStreamWrapper;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.io.RepeatableInputStream;
import org.jets3t.service.utils.ServiceUtils;

public class RepeatableRequestEntity
implements RequestEntity {
    private final Log log = LogFactory.getLog((Class)RepeatableRequestEntity.class);
    private String name = null;
    private InputStream is = null;
    private String contentType = null;
    private long contentLength = 0L;
    private long bytesWritten = 0L;
    private IRepeatableInputStream repeatableInputStream = null;
    private ProgressMonitoredInputStream progressMonitoredIS = null;
    protected static long MAX_BYTES_PER_SECOND = 0L;
    private static volatile long bytesWrittenThisSecond = 0L;
    private static volatile long currentSecondMonitored = 0L;
    private static final Random random = new Random();
    private MessageDigest messageDigest = null;

    public RepeatableRequestEntity(String name, InputStream is, String contentType, long contentLength) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = is;
        this.name = name;
        this.contentLength = contentLength;
        this.contentType = contentType;
        InputStream inputStream = is;
        while (inputStream instanceof InputStreamWrapper) {
            if (inputStream instanceof ProgressMonitoredInputStream) {
                this.progressMonitoredIS = (ProgressMonitoredInputStream)inputStream;
            }
            if (inputStream instanceof IRepeatableInputStream) {
                this.repeatableInputStream = (IRepeatableInputStream)((Object)inputStream);
            }
            inputStream = ((InputStreamWrapper)((Object)inputStream)).getWrappedInputStream();
        }
        if (this.repeatableInputStream == null) {
            this.log.debug((Object)"Wrapping non-repeatable input stream in a RepeatableInputStream");
            this.is = new RepeatableInputStream(is);
            this.repeatableInputStream = (IRepeatableInputStream)((Object)this.is);
        }
        MAX_BYTES_PER_SECOND = 1024L * Jets3tProperties.getInstance("jets3t.properties").getLongProperty("httpclient.read-throttle", 0L);
        if (this.log.isDebugEnabled()) {
            try {
                this.messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                this.log.warn((Object)"Unable to calculate MD5 hash of data sent as algorithm is not available");
            }
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeRequest(OutputStream out) throws IOException {
        if (this.bytesWritten > 0L) {
            this.repeatableInputStream.repeatInputStream();
            this.log.warn((Object)("Repeating transmission of " + this.bytesWritten + " bytes"));
            if (this.progressMonitoredIS != null) {
                this.progressMonitoredIS.resetProgressMonitor();
            }
            this.bytesWritten = 0L;
        }
        if (this.messageDigest != null) {
            this.messageDigest.reset();
        }
        byte[] tmp = new byte[1024];
        int count = 0;
        while ((count = this.is.read(tmp)) >= 0) {
            RepeatableRequestEntity.throttle(count);
            this.bytesWritten += (long)count;
            out.write(tmp, 0, count);
            if (this.messageDigest == null) continue;
            this.messageDigest.update(tmp, 0, count);
        }
        if (this.messageDigest != null) {
            byte[] hash = this.messageDigest.digest();
            this.log.debug((Object)("MD5 digest of data sent for '" + this.name + "' - B64:" + ServiceUtils.toBase64(hash) + " Hex:" + ServiceUtils.toHex(hash)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void throttle(int bytesToWrite) throws IOException {
        boolean willExceedThrottle;
        if (MAX_BYTES_PER_SECOND <= 0L) {
            return;
        }
        long currentSecond = System.currentTimeMillis() / 1000L;
        Random random = RepeatableRequestEntity.random;
        synchronized (random) {
            boolean isCurrentSecond = currentSecond == currentSecondMonitored;
            boolean bl = willExceedThrottle = isCurrentSecond && bytesWrittenThisSecond + (long)bytesToWrite > MAX_BYTES_PER_SECOND;
            if (!isCurrentSecond) {
                currentSecondMonitored = currentSecond;
                bytesWrittenThisSecond = bytesToWrite;
            }
            if (!willExceedThrottle) {
                bytesWrittenThisSecond += (long)bytesToWrite;
            }
        }
        if (willExceedThrottle) {
            try {
                Thread.sleep(RepeatableRequestEntity.random.nextInt(250));
            }
            catch (InterruptedException e) {
                throw new IOException("Throttling of transmission was interrupted");
            }
            RepeatableRequestEntity.throttle(bytesToWrite);
        }
    }
}

