/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.tools.ant.BuildException;

public class IvyInfo
extends IvyTask {
    private File file = null;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        if (this.file == null) {
            this.file = this.getProject().resolveFile(this.getProperty(settings, "ivy.dep.file"));
        }
        try {
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(settings, this.file.toURL(), this.doValidate(settings));
            ModuleRevisionId mrid = md.getModuleRevisionId();
            this.getProject().setProperty("ivy.organisation", mrid.getOrganisation());
            this.getProject().setProperty("ivy.module", mrid.getName());
            if (mrid.getBranch() != null) {
                this.getProject().setProperty("ivy.branch", mrid.getBranch());
            }
            this.getProject().setProperty("ivy.revision", mrid.getRevision());
            this.getProject().setProperty("ivy.status", md.getStatus());
            Map extra = mrid.getExtraAttributes();
            Iterator iter = extra.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.getProject().setProperty("ivy.extra." + entry.getKey(), (String)entry.getValue());
            }
            this.getProject().setProperty("ivy.configurations", this.mergeConfs(md.getConfigurationsNames()));
            Configuration[] configs = md.getConfigurations();
            ArrayList<String> publicConfigsList = new ArrayList<String>();
            for (int i = 0; i < configs.length; ++i) {
                if (!Configuration.Visibility.PUBLIC.equals(configs[i].getVisibility())) continue;
                publicConfigsList.add(configs[i].getName());
            }
            String[] publicConfigs = publicConfigsList.toArray(new String[publicConfigsList.size()]);
            this.getProject().setProperty("ivy.public.configurations", this.mergeConfs(publicConfigs));
        }
        catch (MalformedURLException e) {
            throw new BuildException("unable to convert given ivy file to url: " + this.file + ": " + e, (Throwable)e);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e, (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException("impossible to resolve dependencies: " + e, (Throwable)e);
        }
    }
}

