/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.context;

import java.io.IOException;
import java.util.ArrayList;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.context.ClassPathScanningConfigurationProvider;
import org.springframework.config.java.context.ConfigurableJavaConfigApplicationContext;
import org.springframework.config.java.context.DefaultBeanFactoryProvider;
import org.springframework.config.java.internal.factory.TypeSafeBeanFactoryUtils;
import org.springframework.config.java.internal.process.InternalConfigurationPostProcessor;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.config.java.naming.MethodNameStrategy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConfigApplicationContext
extends AbstractRefreshableApplicationContext
implements ConfigurableJavaConfigApplicationContext {
    private final ClassPathScanningConfigurationProvider scanner = new ClassPathScanningConfigurationProvider((ResourceLoader)this);
    private final ArrayList<Class<?>> configClasses = new ArrayList();
    private final ArrayList<String> basePackages = new ArrayList();
    private BeanNamingStrategy beanNamingStrategy = new MethodNameStrategy();
    private boolean openForConfiguration = true;

    public JavaConfigApplicationContext() {
    }

    public JavaConfigApplicationContext(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.addConfigClass(cls);
            ++n2;
        }
        this.refresh();
    }

    public JavaConfigApplicationContext(String ... basePackages) {
        String[] stringArray = basePackages;
        int n = basePackages.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            this.addBasePackage(pkg);
            ++n2;
        }
        this.refresh();
    }

    public JavaConfigApplicationContext(JavaConfigApplicationContext parent) {
        super((ApplicationContext)parent);
    }

    public JavaConfigApplicationContext(Class<?>[] classes, String[] basePackages) {
        Object[] objectArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = objectArray[n2];
            this.addConfigClass(cls);
            ++n2;
        }
        objectArray = basePackages;
        n = basePackages.length;
        n2 = 0;
        while (n2 < n) {
            Object basePackage = objectArray[n2];
            this.addBasePackage((String)basePackage);
            ++n2;
        }
        this.refresh();
    }

    public JavaConfigApplicationContext(ApplicationContext parent, Class<?> ... classes) {
        super(parent);
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.addConfigClass(cls);
            ++n2;
        }
        this.refresh();
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        new InternalConfigurationPostProcessor((AbstractApplicationContext)this, this.getBeanNamingStrategy(), new DefaultBeanFactoryProvider()).postProcessBeanFactory(beanFactory);
        super.invokeBeanFactoryPostProcessors(beanFactory);
    }

    protected void finishRefresh() {
        super.finishRefresh();
        this.openForConfiguration = false;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException, BeansException {
        for (Class<?> configClass : this.configClasses) {
            this.loadBeanDefinitionForConfigurationClass(beanFactory, configClass);
        }
        for (String basePackage : this.basePackages) {
            this.loadBeanDefinitionsForBasePackage(beanFactory, basePackage);
        }
    }

    private void loadBeanDefinitionForConfigurationClass(DefaultListableBeanFactory beanFactory, Class<?> configClass) {
        String configBeanName = configClass.getName();
        RootBeanDefinition configBeanDef = new RootBeanDefinition();
        configBeanDef.setBeanClassName(configBeanName);
        configBeanDef.addMetadataAttribute(new BeanMetadataAttribute("IS_CONFIGURATION_CLASS", (Object)true));
        beanFactory.registerBeanDefinition(configBeanName, (BeanDefinition)configBeanDef);
    }

    private void loadBeanDefinitionsForBasePackage(DefaultListableBeanFactory beanFactory, String basePackage) {
        for (BeanDefinition beanDef : this.scanner.findCandidateComponents(basePackage)) {
            String configBeanName = beanDef.getBeanClassName();
            ((AbstractBeanDefinition)beanDef).addMetadataAttribute(new BeanMetadataAttribute("IS_CONFIGURATION_CLASS", (Object)true));
            beanFactory.registerBeanDefinition(configBeanName, beanDef);
        }
    }

    public void setParent(ApplicationContext parent) {
        this.assertOpenForConfiguration("setParent");
        super.setParent(parent);
    }

    public void setBeanNamingStrategy(BeanNamingStrategy namingStrategy) {
        this.beanNamingStrategy = namingStrategy;
    }

    public BeanNamingStrategy getBeanNamingStrategy() {
        return this.beanNamingStrategy;
    }

    @Override
    public void addBasePackage(String basePackage) {
        this.assertOpenForConfiguration("addBasePackage");
        this.basePackages.add(basePackage);
    }

    @Override
    public void addConfigClass(Class<?> cls) {
        this.assertOpenForConfiguration("addConfigClass");
        this.configClasses.add(cls);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type);
    }

    @Override
    public <T> T getBean(Class<T> type, String beanName) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type, beanName);
    }

    private void assertOpenForConfiguration(String attemptedMethod) {
        if (!this.openForConfiguration) {
            throw new IllegalStateException(String.format("context is closed for configuration. %s() must be called before refresh(), consider using the no-arg constructor for %s", attemptedMethod, this.getClass().getSimpleName()));
        }
    }
}

