/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.internal.enhancement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.config.java.internal.enhancement.ThreadLocalMapEntryData;
import org.springframework.config.java.internal.enhancement.ThreadLocalUtils;
import org.springframework.config.java.internal.enhancement.ThreadLocalVisitor;
import org.springframework.util.Assert;

class ThreadLocalReader {
    private static final Log log = LogFactory.getLog(ThreadLocalReader.class);

    ThreadLocalReader() {
    }

    public void accept(ThreadLocalVisitor visitor) {
        Assert.notNull((Object)visitor);
        this.accept(visitor, this.rootThreadGroup());
    }

    public void accept(ThreadLocalVisitor visitor, ThreadGroup group) {
        Assert.notNull((Object)visitor);
        Assert.notNull((Object)group);
        log.debug((Object)String.format("accepting visitor [%s] for thread group %s", visitor, group));
        int numThreads = group.activeCount();
        int numGroups = group.activeGroupCount();
        Thread[] threads = new Thread[numThreads];
        ThreadGroup[] groups = new ThreadGroup[numGroups];
        group.enumerate(threads, false);
        group.enumerate(groups, false);
        Object[] objectArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadGroup childGroup = objectArray[n2];
            this.accept(visitor, childGroup);
            ++n2;
        }
        objectArray = threads;
        n = threads.length;
        n2 = 0;
        while (n2 < n) {
            Object childThread = objectArray[n2];
            if (childThread != null) {
                this.accept(visitor, (Thread)childThread);
            }
            ++n2;
        }
    }

    public void accept(ThreadLocalVisitor visitor, Thread thread) {
        Assert.notNull((Object)visitor);
        Assert.notNull((Object)thread);
        log.debug((Object)String.format("accepting visitor [%s] for thread %s", visitor, thread));
        try {
            Object[] table;
            Object threadLocalMap = ThreadLocalUtils.FIELD_THREAD_LOCALS.get(thread);
            if (threadLocalMap == null) {
                return;
            }
            Object[] objectArray = table = (Object[])ThreadLocalUtils.FIELD_TABLE.get(threadLocalMap);
            int n = table.length;
            int n2 = 0;
            while (n2 < n) {
                Object mapEntry = objectArray[n2];
                if (mapEntry != null) {
                    visitor.visit(new ThreadLocalMapEntryData(thread, threadLocalMap, mapEntry));
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private ThreadGroup rootThreadGroup() {
        ThreadGroup currentThreadGroup;
        ThreadGroup rootThreadGroup = currentThreadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = rootThreadGroup.getParent();
        while (parent != null) {
            rootThreadGroup = parent;
            parent = parent.getParent();
        }
        return rootThreadGroup;
    }
}

