/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.config.java.model.ModelClass;
import org.springframework.util.Assert;

public class ModelMethod {
    private final String name;
    private final int modifiers;
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private ModelClass declaringClass;
    private int lineNumber;

    public ModelMethod(String name, int modifiers, Annotation[] annotations) {
        Assert.hasText((String)name);
        this.name = name;
        Assert.notNull((Object)annotations);
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.annotations.add(annotation);
            ++n2;
        }
        Assert.isTrue((modifiers >= 0 ? 1 : 0) != 0, (String)("modifiers must be non-negative: " + modifiers));
        this.modifiers = modifiers;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    protected Annotation[] getAnnotations() {
        return this.annotations.toArray(new Annotation[0]);
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public void setDeclaringClass(ModelClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public ModelClass getDeclaringClass() {
        return this.declaringClass;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static ModelMethod forMethod(Method method) {
        ModelMethod modelMethod = new ModelMethod(method.getName(), method.getModifiers(), method.getAnnotations());
        modelMethod.setDeclaringClass(ModelClass.forClass(method.getDeclaringClass()));
        return modelMethod;
    }

    public String toString() {
        return String.format("%s: name=%s; modifiers=%d", this.getClass().getSimpleName(), this.name, this.modifiers);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + this.modifiers;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelMethod other = (ModelMethod)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.modifiers != other.modifiers) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

