/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.plugin.aop;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.config.java.plugin.aop.AopNamespaceUtils;
import org.springframework.config.java.plugin.aop.AspectJAutoProxyDeclaration;

class AspectJAutoProxyBeanDefinitionParser {
    AspectJAutoProxyBeanDefinitionParser() {
    }

    public BeanDefinition parse(AspectJAutoProxyDeclaration dec, BeanDefinitionRegistry registry) {
        AopNamespaceUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary(registry, dec);
        this.extendBeanDefinition(dec, registry);
        return null;
    }

    private void extendBeanDefinition(AspectJAutoProxyDeclaration dec, BeanDefinitionRegistry registry) {
        BeanDefinition beanDef = registry.getBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
        if (dec.getIncludePatterns().length > 0) {
            this.addIncludePatterns(dec, registry, beanDef);
        }
    }

    private void addIncludePatterns(AspectJAutoProxyDeclaration dec, BeanDefinitionRegistry parserContext, BeanDefinition beanDef) {
        ManagedList includePatterns = new ManagedList();
        String[] stringArray = dec.getIncludePatterns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            TypedStringValue valueHolder = new TypedStringValue(pattern);
            includePatterns.add((Object)valueHolder);
            ++n2;
        }
        if (!includePatterns.isEmpty()) {
            beanDef.getPropertyValues().addPropertyValue("includePatterns", (Object)includePatterns);
        }
    }
}

