/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.internal.factory.TypeSafeBeanFactoryUtils;
import org.springframework.config.java.support.FactoryBeanObjectCreationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public abstract class ConfigurationSupport
implements BeanFactoryAware,
ApplicationContextAware {
    private BeanFactory beanFactory;
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private ApplicationContext applicationContext;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            this.autowireCapableBeanFactory = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setApplicationContext(ApplicationContext ac) {
        this.applicationContext = ac;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Object getBean(String beanName) {
        return this.beanFactory.getBean(beanName);
    }

    public <T> T getBean(Class<T> type) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.beanFactory, type);
    }

    public <T> T getBean(Class<T> type, String beanName) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.beanFactory, type, beanName);
    }

    protected Object getObject(FactoryBean factoryBean) throws FactoryBeanObjectCreationException {
        try {
            return this.getConfigured(factoryBean).getObject();
        }
        catch (Exception ex) {
            throw new FactoryBeanObjectCreationException(factoryBean, ex);
        }
    }

    public <T> T getObject(FactoryBean factoryBean, Class<T> requiredType) {
        Class actualType = factoryBean.getObjectType();
        if (!requiredType.isAssignableFrom(actualType)) {
            throw new FactoryBeanObjectCreationException(String.format("FactoryBean object type mismatch: expected [%s], but FactoryBean actually creates [%s]. Offending FactoryBean instance is: %s", requiredType, actualType, factoryBean));
        }
        return (T)this.getObject(factoryBean);
    }

    protected <T> T getConfigured(T object) {
        if (this.autowireCapableBeanFactory == null) {
            throw new UnsupportedOperationException("Cannot configure object - not running in an AutowireCapableBeanFactory");
        }
        Object configuredObject = this.autowireCapableBeanFactory.initializeBean(object, null);
        if (this.applicationContext != null) {
            if (configuredObject instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)configuredObject).setResourceLoader((ResourceLoader)this.applicationContext);
            }
            if (configuredObject instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)configuredObject).setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
            }
            if (configuredObject instanceof MessageSourceAware) {
                ((MessageSourceAware)configuredObject).setMessageSource((MessageSource)this.applicationContext);
            }
            if (configuredObject instanceof ApplicationContextAware) {
                ((ApplicationContextAware)configuredObject).setApplicationContext(this.applicationContext);
            }
        }
        return (T)configuredObject;
    }
}

