/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.internal.parsing.asm;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.junit.Assert.*;
import static org.springframework.config.java.internal.parsing.asm.MutableAnnotationUtils.createMutableAnnotation;
import static org.springframework.config.java.internal.util.AnnotationExtractionUtils.extractClassAnnotation;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Test;
import org.springframework.config.java.internal.parsing.asm.MutableAnnotation;


/** TODO: JAVADOC */
public class DynamicMutableAnnotationTests {
    @Test
    public void test() {
        ExampleAnno actual;
        {
            @ExampleAnno
            class Prototype { }
            actual = extractClassAnnotation(ExampleAnno.class, Prototype.class);
        }

        ExampleAnno dynamic = createMutableAnnotation(ExampleAnno.class);

        // ---

        assertThat(actual.anAttribute(), equalTo("aValue"));
        assertThat(dynamic.anAttribute(), equalTo("aValue"));

        // ---

        assertThat(actual, equalTo(dynamic));
        assertThat(dynamic, equalTo(actual));

        // ---

        {
            @ExampleAnno(anAttribute="otherValue")
            class Prototype { }
            actual = extractClassAnnotation(ExampleAnno.class, Prototype.class);
        }

        assertThat(dynamic, not(equalTo(actual)));
        assertThat(actual, not(equalTo(dynamic)));

        ((MutableAnnotation)dynamic).setAttributeValue("anAttribute", "otherValue");

        assertThat(dynamic, equalTo(actual));
        assertThat(actual, equalTo(dynamic));

        // ---

        assertFalse(dynamic.equals(new Object()));
        assertTrue(dynamic.equals(dynamic));
        assertFalse(dynamic.equals(null));

    }

    @Retention(RetentionPolicy.RUNTIME)
    @interface ExampleAnno {
        String anAttribute() default "aValue";
    }

}
