/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.atconfiguration;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.*;
import static test.common.util.Assert.assertBeanDefinitionCount;

import org.junit.Test;

import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import test.feature.xmlbootstrap.ConfigurationPostProcessorTests.ExternalBeanConfiguration;
import test.feature.xmlbootstrap.ConfigurationPostProcessorTests.ExternalBeanProvidingConfiguration;


/**
 * System test ensuring that abstract {@link Configuration} semantics are supported.
 *
 * @author  Chris Beams
 */
public class SystemAbstractConfigurationTests {

    /**
     * Tests that empty abstract configurations do not cause any problem.
     *
     * @see SJC-207
     * @see {@link org.springframework.config.java.internal.model.ConfigurationClassTests#validateEmptyAbstractConfigurationIsValid()}
     */
    @Test
    public void testEmptyAbstractConfigurationIsSupported() {
        // should not throw any exception
        JavaConfigApplicationContext ctx =
            new JavaConfigApplicationContext(EmptyAbstractConfiguration.class);
        
        // should be just one bean in the container - the configuration bean itself
        assertThat(ctx.getBeanDefinitionCount(), equalTo(1));
    }


    @Test
    public void testAbstractConfigurationWithExternalBeanDoesGetProcessed() {
        JavaConfigApplicationContext ctx =
            new JavaConfigApplicationContext(ExternalBeanConfiguration.class, ExternalBeanProvidingConfiguration.class);

        int configClasses = 2;
        int beansInClasses = 2;

        assertBeanDefinitionCount(ctx, (configClasses + beansInClasses));
    }

    @Configuration
    public abstract static class EmptyAbstractConfiguration {
    }

}
