/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.atimport;

import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.config.java.plugin.Plugin;
import test.common.beans.TestBean;

/**
 * {@code @ImportAnnotation} exists as an extension mechanism, so users can write their
 * own {@code ImportFoo} annotations.  Let's try it out and prove it here.
 *
 * @author Chris Beams
 */
public class ImportAnnotationProgrammingModelTests {

    @Test
    public void testImportProperties() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(Config.class);

        assertTrue("should have contained java-configured bean",
                ctx.containsBeanDefinition("javaConfiguredBean"));

        assertTrue("should have contained properties-configured bean",
                ctx.containsBeanDefinition("propConfiguredBean"));
    }

    @Configuration
    @ImportProperties(locations="classpath:test/feature/atimport/foo.properties")
    static class Config {
        public @Bean TestBean javaConfiguredBean() {
            return new TestBean("java.configured");
        }
    }

    @Plugin(handler=ImportPropertiesHandler.class)
    @interface ImportProperties {
        String[] locations();
    }

    static class ImportPropertiesHandler implements ConfigurationPlugin<ImportProperties> {
        public void handle(ImportProperties importAnno, BeanDefinitionRegistry registry) {
            BeanDefinitionReader reader = new PropertiesBeanDefinitionReader(registry);
            reader.loadBeanDefinitions(importAnno.locations());
        }
    }

}
