/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.lifecycle.aware;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import org.springframework.beans.factory.BeanNameAware;

import org.springframework.config.java.context.JavaConfigApplicationContext;

import test.common.beans.TestBean;

import test.common.config.BaseConfiguration;


/**
 * System test ensuring that {@link BeanNameAware} semantics are supported by
 * {@link JavaConfigApplicationContext}.
 *
 * @author  Chris Beams
 */
public class BeanNameAwareTests {

    /**
     * Beans that implement {@link BeanNameAware} should be injected with their bean names
     * appropriately.
     */
    @Test
    public void testBeanNameAware() {
        JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(BaseConfiguration.class);
        assertTrue(ctx.containsBean(BaseConfiguration.class.getName()));

        TestBean tom = (TestBean) ctx.getBean("tom");
        assertEquals("tom", tom.getName());
        assertEquals("tom", tom.getBeanName());
    }

}
