/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.plugin.tx.annotationdriven;

import org.junit.Test;
import org.springframework.config.java.context.JavaConfigApplicationContext;


/**
 * Isolates a really obscure bug where, given a very particular
 * configuration (see {@link Config}), JavaConfig attempts to register
 * the same bean twice.
 *
 * @author Chris Beams
 */
public class MultipleSingletonRegistrationBugTests {

    /**
     * This was the offending configuration.
     */
    @Test
    public void reproIssue() {
        new JavaConfigApplicationContext(Config.class);
    }

    @Test
    public void reproIssue2() {
        new JavaConfigApplicationContext(Config2.class);
    }

}
