/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.feature.testingsupport;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.junit.Assert.assertThat;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.config.java.test.JavaConfigContextLoader;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import test.common.beans.TestBean;


/**
 * Tests that demonstrate JavaConfig's support for Spring 2.5's Test Context framework.
 *
 * @see JavaConfigContextLoader
 *
 * @author Chris Beams
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations="test.feature.testingsupport",
                      loader=JavaConfigContextLoader.class)
public class JavaConfigContextLoaderPackageLocationsTests {
    @Autowired TestBean testBean;

    public @Test void test() {
        assertThat(testBean, notNullValue());
        assertThat(testBean.getName(), equalTo("alice"));
    }
}
