/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.validation;

import org.springframework.samples.petclinic.Visit;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;

/**
 * {@code Validator} for {@code Visit} forms.
 * 
 * @see src/main/resources/messages.properties
 * @see src/main/resources/messages_en.properties
 * @see src/main/resources/messages_de.properties
 *
 * @author Ken Krebs
 * @author Juergen Hoeller
 * @author Chris Beams
 */
public class VisitValidator {

    public void validate(Visit visit, Errors errors) {
        if (!StringUtils.hasLength(visit.getDescription())) {
            errors.rejectValue("description", "required", "required");
        }
    }

}
