/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.samples.petclinic.web;

import static org.springframework.samples.petclinic.web.PageType.SHOW;

import org.springframework.samples.petclinic.Owner;

public class ViewUtils {

    public static final String VET   = "vet";
    public static final String OWNER = "owner";
    public static final String PET   = "pet";
    public static final String VISIT = "visit";

    static final String ALL_VET_REQUESTS   = "/vet/*";
    static final String ALL_OWNER_REQUESTS = "/owner/*";
    static final String ALL_PET_REQUESTS   = "/pet/*";
    static final String ALL_VISIT_REQUESTS = "/visit/*";

    static final String OWNER_SHOW_REDIRECT = String.format("redirect:../%s/%s?id=", OWNER, SHOW);

    public static final String PET_OBJ_NAME = "pet";


    private ViewUtils() { }

    public static String buildViewName(String... pathElements) {
        StringBuilder builder = new StringBuilder();
        for(int i=0; i<pathElements.length; i++) {
            String pathElement = pathElements[i];
            builder.append(pathElement);
            if(i < pathElements.length-1)
                builder.append('/');
        }
        return builder.toString();
    }

    public static String getRedirectForOwner(Owner owner) {
        return OWNER_SHOW_REDIRECT + owner.getId();
    }

}
