package org.springframework.samples.petclinic.web;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;
import static org.springframework.samples.petclinic.web.ViewUtils.OWNER_SHOW_REDIRECT;

import org.junit.Test;
import org.springframework.samples.petclinic.Owner;

public class ViewUtilsTests {
    @Test
    public void getRedirectForOwner() {
        Owner o = new Owner();
        o.setId(5);
        assertThat(ViewUtils.getRedirectForOwner(o), equalTo(OWNER_SHOW_REDIRECT + 5));
    }

    @Test
    public void buildViewNameWithOneToken() {
        assertThat(ViewUtils.buildViewName("foo"), equalTo("foo"));
    }

    @Test
    public void buildViewNameWithTwoTokens() {
        assertThat(ViewUtils.buildViewName("foo", "bar"), equalTo("foo/bar"));
    }
}
