/*
 * Copyright 2002-2008 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.config.java.plugin.context;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.config.java.plugin.ConfigurationPlugin;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.annotation.AnnotationUtils;


/** TODO: JAVADOC */
class ComponentScanHandler implements ConfigurationPlugin<ComponentScan> {

    public void handle(ComponentScan scanAnno, BeanDefinitionRegistry registry) {
        ComponentScanDeclaration scanDec = new ComponentScanDeclaration();
        scanDec.setBasePackages(scanAnno.value());
        scanDec.setScopedProxy(scanAnno.scopedProxy());
        scanDec.setAnnotationConfig(scanAnno.annotationConfig());
        scanDec.setUseDefaultFilters(scanAnno.useDefaultFilters());
        // TODO: SJC-223
        // scanDec.setIncludeFilters(scanAnno.includeFilters());
        // scanDec.setExcludeFilters(scanAnno.excludeFilters());
	
        Class<? extends ScopeMetadataResolver> resolver = scanAnno.scopeResolver();
        Object defaultResolver = AnnotationUtils.getDefaultValue(scanAnno, "scopeResolver");
        if(resolver != defaultResolver)
            scanDec.setScopeResolver(resolver);

        Class<? extends BeanNameGenerator> nameGenerator = scanAnno.nameGenerator();
        Object defaultNameGenerator = AnnotationUtils.getDefaultValue(scanAnno, "nameGenerator");
        if(nameGenerator != defaultNameGenerator)
            scanDec.setNameGenerator(nameGenerator);

        String resourcePattern = scanAnno.resourcePattern();
        Object defaultResourcePattern = AnnotationUtils.getDefaultValue(scanAnno, "resourcePattern");
        if(!resourcePattern.equals(defaultResourcePattern))
            scanDec.setResourcePattern(resourcePattern);


        new GeneralizedComponentScanBeanDefinitionParser().parse(scanDec, registry);
    }

}
