/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "mzn" locale.
 */
public class LocalizedNamesImpl_mzn extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IR",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "EZ",
        "UN",
        "XA",
        "XB",
        "AZ",
        "AW",
        "AR",
        "AC",
        "AL",
        "DE",
        "AX",
        "VI",
        "AS",
        "UM",
        "AG",
        "AD",
        "AO",
        "AI",
        "AT",
        "ET",
        "JO",
        "AM",
        "EU",
        "UY",
        "ER",
        "UZ",
        "AU",
        "GQ",
        "EE",
        "SK",
        "SI",
        "AF",
        "DZ",
        "SV",
        "ID",
        "QO",
        "UA",
        "UG",
        "EC",
        "IT",
        "IR",
        "IE",
        "IL",
        "IS",
        "ES",
        "BB",
        "BS",
        "BH",
        "BR",
        "BM",
        "BN",
        "GB",
        "IO",
        "VG",
        "BY",
        "BG",
        "BE",
        "BZ",
        "BD",
        "BJ",
        "BT",
        "BW",
        "BI",
        "BF",
        "BA",
        "BO",
        "BV",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TM",
        "TR",
        "TA",
        "TT",
        "TC",
        "TN",
        "TO",
        "TV",
        "TK",
        "TG",
        "TL",
        "JM",
        "JP",
        "GI",
        "JE",
        "ZA",
        "GS",
        "SS",
        "KR",
        "AQ",
        "DJ",
        "DK",
        "DM",
        "DO",
        "DG",
        "RE",
        "RW",
        "RU",
        "RO",
        "ZM",
        "ZW",
        "ST",
        "WS",
        "LK",
        "SB",
        "BL",
        "LC",
        "SX",
        "MF",
        "SH",
        "VC",
        "KN",
        "SM",
        "PM",
        "SN",
        "SG",
        "SE",
        "SZ",
        "SJ",
        "EA",
        "SD",
        "SR",
        "SY",
        "SO",
        "CH",
        "SL",
        "SC",
        "MP",
        "KP",
        "CL",
        "RS",
        "CI",
        "IQ",
        "SA",
        "OM",
        "EH",
        "GH",
        "FO",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "PS",
        "FI",
        "FJ",
        "PH",
        "CY",
        "KG",
        "KZ",
        "QA",
        "IC",
        "LA",
        "LV",
        "LB",
        "LT",
        "LS",
        "PL",
        "LU",
        "LR",
        "LY",
        "LI",
        "MG",
        "MQ",
        "MH",
        "MW",
        "MT",
        "MV",
        "MY",
        "ML",
        "MO",
        "YT",
        "US",
        "AE",
        "HU",
        "MA",
        "CF",
        "EG",
        "MN",
        "MK",
        "IM",
        "MU",
        "MR",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MX",
        "MM",
        "FM",
        "NR",
        "NA",
        "NO",
        "NF",
        "NP",
        "NU",
        "NE",
        "NG",
        "NZ",
        "NC",
        "NI",
        "HM",
        "HT",
        "NL",
        "BQ",
        "IN",
        "HN",
        "HK",
        "VA",
        "WF",
        "VU",
        "VE",
        "VN",
        "PY",
        "PW",
        "PA",
        "PG",
        "PK",
        "PT",
        "PE",
        "PR",
        "PN",
        "TD",
        "CZ",
        "CN",
        "CR",
        "KH",
        "CM",
        "CA",
        "HR",
        "CX",
        "CO",
        "CP",
        "CG",
        "CD",
        "KE",
        "CU",
        "CW",
        "XK",
        "KM",
        "CC",
        "CK",
        "KW",
        "KI",
        "KY",
        "CV",
        "GA",
        "GM",
        "GD",
        "GE",
        "GG",
        "GL",
        "GU",
        "GT",
        "GP",
        "GY",
        "GN",
        "GW",
        "YE",
        "GR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "جهون");
    namesMap.put("002", "آفریقا");
    namesMap.put("003", "شمالی آمریکا");
    namesMap.put("005", "جنوبی آمریکا");
    namesMap.put("009", "اوقیانوسیه");
    namesMap.put("011", "غربی آفریقا");
    namesMap.put("013", "میونی آمریکا");
    namesMap.put("014", "شرقی آفریقا");
    namesMap.put("015", "شمالی ۀفریقا");
    namesMap.put("017", "میونی آفریقا");
    namesMap.put("018", "جنوبی آفریقا");
    namesMap.put("019", "آمریکا");
    namesMap.put("021", "شمالی امریکا");
    namesMap.put("029", "کاراییب");
    namesMap.put("030", "شرقی آسیا");
    namesMap.put("034", "جنوبی آسیا");
    namesMap.put("035", "آسیای ِجنوب‌شرقی‌وَر");
    namesMap.put("039", "جنوبی اروپا");
    namesMap.put("053", "اوسترالزی");
    namesMap.put("054", "ملانزی");
    namesMap.put("057", "میکرونزی منقطه");
    namesMap.put("061", "پولی‌نزی");
    namesMap.put("142", "آسیا");
    namesMap.put("143", "میونی آسیا");
    namesMap.put("145", "غربی آسیا");
    namesMap.put("150", "اروپا");
    namesMap.put("151", "شرقی اروپا");
    namesMap.put("154", "شمالی اروپا");
    namesMap.put("155", "غربی اروپا");
    namesMap.put("419", "لاتین آمریکا");
    namesMap.put("AC", "آسنسیون جزیره");
    namesMap.put("AD", "آندورا");
    namesMap.put("AE", "متحده عربی امارات");
    namesMap.put("AF", "افغانستون");
    namesMap.put("AG", "آنتیگوا و باربودا");
    namesMap.put("AI", "آنگویلا");
    namesMap.put("AL", "آلبانی");
    namesMap.put("AM", "ارمنستون");
    namesMap.put("AO", "آنگولا");
    namesMap.put("AQ", "جنوبی یخ‌بزه قطب");
    namesMap.put("AR", "آرژانتین");
    namesMap.put("AS", "آمریکای ِساموآ");
    namesMap.put("AT", "اتریش");
    namesMap.put("AU", "استرالیا");
    namesMap.put("AW", "آروبا");
    namesMap.put("AX", "آلند جزیره");
    namesMap.put("AZ", "آذربایجون");
    namesMap.put("BA", "بوسنی و هرزگوین");
    namesMap.put("BB", "باربادوس");
    namesMap.put("BD", "بنگلادش");
    namesMap.put("BE", "بلژیک");
    namesMap.put("BF", "بورکینا فاسو");
    namesMap.put("BG", "بلغارستون");
    namesMap.put("BH", "بحرین");
    namesMap.put("BI", "بوروندی");
    namesMap.put("BJ", "بنین");
    namesMap.put("BL", "سنت بارتلمی");
    namesMap.put("BM", "برمودا");
    namesMap.put("BN", "برونئی");
    namesMap.put("BO", "بولیوی");
    namesMap.put("BQ", "هلند ِکاراییبی جزایر");
    namesMap.put("BR", "برزیل");
    namesMap.put("BS", "باهاما");
    namesMap.put("BT", "بوتان");
    namesMap.put("BV", "بووت جزیره");
    namesMap.put("BW", "بوتساوانا");
    namesMap.put("BY", "بلاروس");
    namesMap.put("BZ", "بلیز");
    namesMap.put("CA", "کانادا");
    namesMap.put("CC", "کوک (کیلینگ) جزایر");
    namesMap.put("CD", "کنگو کینشاسا");
    namesMap.put("CF", "مرکزی آفریقای جمهوری");
    namesMap.put("CG", "کنگو برازاویل");
    namesMap.put("CH", "سوییس");
    namesMap.put("CI", "عاج ِساحل");
    namesMap.put("CK", "کوک جزایر");
    namesMap.put("CL", "شیلی");
    namesMap.put("CM", "کامرون");
    namesMap.put("CN", "چین");
    namesMap.put("CO", "کلمبیا");
    namesMap.put("CP", "کلیپرتون جزیره");
    namesMap.put("CR", "کاستاریکا");
    namesMap.put("CU", "کوبا");
    namesMap.put("CV", "کیپ ورد");
    namesMap.put("CW", "کوراسائو");
    namesMap.put("CX", "کریسمس جزیره");
    namesMap.put("CY", "قبرس");
    namesMap.put("CZ", "چک جمهوری");
    namesMap.put("DE", "آلمان");
    namesMap.put("DG", "دیگو گارسیا");
    namesMap.put("DJ", "جیبوتی");
    namesMap.put("DK", "دانمارک");
    namesMap.put("DM", "دومنیکا");
    namesMap.put("DO", "دومنیکن جمهوری");
    namesMap.put("DZ", "الجزیره");
    namesMap.put("EA", "سوتا و ملیله");
    namesMap.put("EC", "اکوادر");
    namesMap.put("EE", "استونی");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "غربی صحرا");
    namesMap.put("ER", "اریتره");
    namesMap.put("ES", "ایسپانیا");
    namesMap.put("ET", "اتیوپی");
    namesMap.put("EU", "اروپا اتحادیه");
    namesMap.put("FI", "فنلاند");
    namesMap.put("FJ", "فیجی");
    namesMap.put("FK", "فالکلند جزیره‌ئون");
    namesMap.put("FM", "میکرونزی");
    namesMap.put("FO", "فارو جزایر");
    namesMap.put("FR", "فرانسه");
    namesMap.put("GA", "گابون");
    namesMap.put("GB", "بریتانیا");
    namesMap.put("GD", "گرانادا");
    namesMap.put("GE", "گرجستون");
    namesMap.put("GF", "فرانسه‌ی ِگویان");
    namesMap.put("GG", "گرنزی");
    namesMap.put("GH", "غنا");
    namesMap.put("GI", "جبل طارق");
    namesMap.put("GL", "گرینلند");
    namesMap.put("GM", "گامبیا");
    namesMap.put("GN", "گینه");
    namesMap.put("GP", "گوادلوپ");
    namesMap.put("GQ", "استوایی گینه");
    namesMap.put("GR", "یونان");
    namesMap.put("GS", "جنوبی جورجیا و جنوبی ساندویچ جزایر");
    namesMap.put("GT", "گواتمالا");
    namesMap.put("GU", "گوئام");
    namesMap.put("GW", "گینه بیسائو");
    namesMap.put("GY", "گویان");
    namesMap.put("HK", "هنگ کنگ");
    namesMap.put("HM", "هارد و مک‌دونالد جزایر");
    namesMap.put("HN", "هندوراس");
    namesMap.put("HR", "کرواسی");
    namesMap.put("HT", "هاییتی");
    namesMap.put("HU", "مجارستون");
    namesMap.put("IC", "قناری جزایر");
    namesMap.put("ID", "اندونزی");
    namesMap.put("IE", "ایرلند");
    namesMap.put("IL", "ایسراییل");
    namesMap.put("IM", "من ِجزیره");
    namesMap.put("IN", "هند");
    namesMap.put("IO", "بریتانیای هند ِاوقیانوس ِمناطق");
    namesMap.put("IQ", "عراق");
    namesMap.put("IR", "ایران");
    namesMap.put("IS", "ایسلند");
    namesMap.put("IT", "ایتالیا");
    namesMap.put("JE", "جرسی");
    namesMap.put("JM", "جاماییکا");
    namesMap.put("JO", "اردن");
    namesMap.put("JP", "جاپون");
    namesMap.put("KE", "کنیا");
    namesMap.put("KG", "قرقیزستون");
    namesMap.put("KH", "کامبوج");
    namesMap.put("KI", "کیریباتی");
    namesMap.put("KM", "کومور");
    namesMap.put("KN", "سنت کیتس و نویس");
    namesMap.put("KP", "شمالی کُره");
    namesMap.put("KR", "جنوبی کُره");
    namesMap.put("KW", "کویت");
    namesMap.put("KY", "کیمن جزیره‌ئون");
    namesMap.put("KZ", "قزاقستون");
    namesMap.put("LA", "لائوس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سنت لوسیا");
    namesMap.put("LI", "لیختن اشتاین");
    namesMap.put("LK", "سریلانکا");
    namesMap.put("LR", "لیبریا");
    namesMap.put("LS", "لسوتو");
    namesMap.put("LT", "لتونی");
    namesMap.put("LU", "لوکزامبورگ");
    namesMap.put("LV", "لاتویا");
    namesMap.put("LY", "لیبی");
    namesMap.put("MA", "مراکش");
    namesMap.put("MC", "موناکو");
    namesMap.put("MD", "مولداوی");
    namesMap.put("ME", "مونته‌نگرو");
    namesMap.put("MF", "سنت مارتین");
    namesMap.put("MG", "ماداگاسکار");
    namesMap.put("MH", "مارشال جزایر");
    namesMap.put("MK", "مقدونیه");
    namesMap.put("ML", "مالی");
    namesMap.put("MM", "میانمار");
    namesMap.put("MN", "مغولستون");
    namesMap.put("MO", "ماکائو (چین دله)");
    namesMap.put("MP", "شمالی ماریانا جزایر");
    namesMap.put("MQ", "مارتینیک جزیره‌ئون");
    namesMap.put("MR", "موریتانی");
    namesMap.put("MS", "مونتسرات");
    namesMap.put("MT", "مالت");
    namesMap.put("MU", "مورى تيوس");
    namesMap.put("MV", "مالدیو");
    namesMap.put("MW", "مالاوی");
    namesMap.put("MX", "مکزیک");
    namesMap.put("MY", "مالزی");
    namesMap.put("MZ", "موزامبیک");
    namesMap.put("NA", "نامبیا");
    namesMap.put("NC", "نیو کالیدونیا");
    namesMap.put("NE", "نیجر");
    namesMap.put("NF", "نورفولک جزیره");
    namesMap.put("NG", "نیجریه");
    namesMap.put("NI", "نیکاراگوئه");
    namesMap.put("NL", "هلند");
    namesMap.put("NO", "نروژ");
    namesMap.put("NP", "نپال");
    namesMap.put("NR", "نائورو");
    namesMap.put("NU", "نیئو");
    namesMap.put("NZ", "نیوزلند");
    namesMap.put("OM", "عمان");
    namesMap.put("PA", "پاناما");
    namesMap.put("PE", "پرو");
    namesMap.put("PF", "فرانسه‌ی پولی‌نزی");
    namesMap.put("PG", "پاپوا نو گینه");
    namesMap.put("PH", "فیلیپین");
    namesMap.put("PK", "پاکستون");
    namesMap.put("PL", "لهستون");
    namesMap.put("PM", "سن پییر و میکلن");
    namesMap.put("PN", "پیتکارین جزایر");
    namesMap.put("PR", "پورتوریکو");
    namesMap.put("PS", "فلسطین ِسرزمین");
    namesMap.put("PT", "پرتغال");
    namesMap.put("PW", "پالائو");
    namesMap.put("PY", "پاراگوئه");
    namesMap.put("QA", "قطر");
    namesMap.put("QO", "اوقیانوسیه‌ی ِپرت ِجائون");
    namesMap.put("RE", "رئونیون");
    namesMap.put("RO", "رومانی");
    namesMap.put("RS", "صربستون");
    namesMap.put("RU", "روسیه");
    namesMap.put("RW", "روآندا");
    namesMap.put("SA", "عربستون");
    namesMap.put("SB", "سلیمون جزیره");
    namesMap.put("SC", "سیشل");
    namesMap.put("SD", "سودان");
    namesMap.put("SE", "سوئد");
    namesMap.put("SG", "سنگاپور");
    namesMap.put("SH", "سنت هلنا");
    namesMap.put("SI", "اسلوونی");
    namesMap.put("SJ", "سوالبارد و يان ماين");
    namesMap.put("SK", "اسلواکی");
    namesMap.put("SL", "سیرالئون");
    namesMap.put("SM", "سن مارینو");
    namesMap.put("SN", "سنگال");
    namesMap.put("SO", "سومالی");
    namesMap.put("SR", "سورینام");
    namesMap.put("SS", "جنوبی سودان");
    namesMap.put("ST", "سائوتومه و پرینسیپ");
    namesMap.put("SV", "السالوادور");
    namesMap.put("SX", "سنت مارتن");
    namesMap.put("SY", "سوریه");
    namesMap.put("SZ", "سوازیلند");
    namesMap.put("TA", "تریستان دا جونها");
    namesMap.put("TC", "تورکس و کایکوس جزایر");
    namesMap.put("TD", "چاد");
    namesMap.put("TF", "فرانسه‌ی جنوبی مناطق");
    namesMap.put("TG", "توگو");
    namesMap.put("TH", "تایلند");
    namesMap.put("TJ", "تاجیکستون");
    namesMap.put("TK", "توکلائو");
    namesMap.put("TL", "تیمور شرقی");
    namesMap.put("TM", "ترکمونستون");
    namesMap.put("TN", "تونس");
    namesMap.put("TO", "تونگا");
    namesMap.put("TR", "ترکیه");
    namesMap.put("TT", "ترینیداد و توباگو");
    namesMap.put("TV", "تووالو");
    namesMap.put("TW", "تایوان");
    namesMap.put("TZ", "تانزانیا");
    namesMap.put("UA", "اوکراین");
    namesMap.put("UG", "اوگاندا");
    namesMap.put("UM", "آمریکای پَرتِ‌پِلا جزیره‌ئون");
    namesMap.put("US", "متحده ایالات");
    namesMap.put("UY", "اروگوئه");
    namesMap.put("UZ", "ازبکستون");
    namesMap.put("VA", "واتیکان");
    namesMap.put("VC", "سنت وینسنت و گرنادین");
    namesMap.put("VE", "ونزوئلا");
    namesMap.put("VG", "بریتانیای ویرجین");
    namesMap.put("VI", "آمریکای ویرجین");
    namesMap.put("VN", "ویتنام");
    namesMap.put("VU", "وانواتو");
    namesMap.put("WF", "والیس و فوتونا");
    namesMap.put("WS", "ساموآ");
    namesMap.put("XK", "کوزوو");
    namesMap.put("YE", "یمن");
    namesMap.put("YT", "مایوت");
    namesMap.put("ZA", "جنوبی افریقا");
    namesMap.put("ZM", "زامبیا");
    namesMap.put("ZW", "زیمبابوه");
    namesMap.put("ZZ", "نامَیِّن منطقه");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "جهون",
        "002": "آفریقا",
        "003": "شمالی آمریکا",
        "005": "جنوبی آمریکا",
        "009": "اوقیانوسیه",
        "011": "غربی آفریقا",
        "013": "میونی آمریکا",
        "014": "شرقی آفریقا",
        "015": "شمالی ۀفریقا",
        "017": "میونی آفریقا",
        "018": "جنوبی آفریقا",
        "019": "آمریکا",
        "021": "شمالی امریکا",
        "029": "کاراییب",
        "030": "شرقی آسیا",
        "034": "جنوبی آسیا",
        "035": "آسیای ِجنوب‌شرقی‌وَر",
        "039": "جنوبی اروپا",
        "053": "اوسترالزی",
        "054": "ملانزی",
        "057": "میکرونزی منقطه",
        "061": "پولی‌نزی",
        "142": "آسیا",
        "143": "میونی آسیا",
        "145": "غربی آسیا",
        "150": "اروپا",
        "151": "شرقی اروپا",
        "154": "شمالی اروپا",
        "155": "غربی اروپا",
        "419": "لاتین آمریکا",
        "AC": "آسنسیون جزیره",
        "AD": "آندورا",
        "AE": "متحده عربی امارات",
        "AF": "افغانستون",
        "AG": "آنتیگوا و باربودا",
        "AI": "آنگویلا",
        "AL": "آلبانی",
        "AM": "ارمنستون",
        "AO": "آنگولا",
        "AQ": "جنوبی یخ‌بزه قطب",
        "AR": "آرژانتین",
        "AS": "آمریکای ِساموآ",
        "AT": "اتریش",
        "AU": "استرالیا",
        "AW": "آروبا",
        "AX": "آلند جزیره",
        "AZ": "آذربایجون",
        "BA": "بوسنی و هرزگوین",
        "BB": "باربادوس",
        "BD": "بنگلادش",
        "BE": "بلژیک",
        "BF": "بورکینا فاسو",
        "BG": "بلغارستون",
        "BH": "بحرین",
        "BI": "بوروندی",
        "BJ": "بنین",
        "BL": "سنت بارتلمی",
        "BM": "برمودا",
        "BN": "برونئی",
        "BO": "بولیوی",
        "BQ": "هلند ِکاراییبی جزایر",
        "BR": "برزیل",
        "BS": "باهاما",
        "BT": "بوتان",
        "BV": "بووت جزیره",
        "BW": "بوتساوانا",
        "BY": "بلاروس",
        "BZ": "بلیز",
        "CA": "کانادا",
        "CC": "کوک (کیلینگ) جزایر",
        "CD": "کنگو کینشاسا",
        "CF": "مرکزی آفریقای جمهوری",
        "CG": "کنگو برازاویل",
        "CH": "سوییس",
        "CI": "عاج ِساحل",
        "CK": "کوک جزایر",
        "CL": "شیلی",
        "CM": "کامرون",
        "CN": "چین",
        "CO": "کلمبیا",
        "CP": "کلیپرتون جزیره",
        "CR": "کاستاریکا",
        "CU": "کوبا",
        "CV": "کیپ ورد",
        "CW": "کوراسائو",
        "CX": "کریسمس جزیره",
        "CY": "قبرس",
        "CZ": "چک جمهوری",
        "DE": "آلمان",
        "DG": "دیگو گارسیا",
        "DJ": "جیبوتی",
        "DK": "دانمارک",
        "DM": "دومنیکا",
        "DO": "دومنیکن جمهوری",
        "DZ": "الجزیره",
        "EA": "سوتا و ملیله",
        "EC": "اکوادر",
        "EE": "استونی",
        "EG": "مصر",
        "EH": "غربی صحرا",
        "ER": "اریتره",
        "ES": "ایسپانیا",
        "ET": "اتیوپی",
        "EU": "اروپا اتحادیه",
        "FI": "فنلاند",
        "FJ": "فیجی",
        "FK": "فالکلند جزیره‌ئون",
        "FM": "میکرونزی",
        "FO": "فارو جزایر",
        "FR": "فرانسه",
        "GA": "گابون",
        "GB": "بریتانیا",
        "GD": "گرانادا",
        "GE": "گرجستون",
        "GF": "فرانسه‌ی ِگویان",
        "GG": "گرنزی",
        "GH": "غنا",
        "GI": "جبل طارق",
        "GL": "گرینلند",
        "GM": "گامبیا",
        "GN": "گینه",
        "GP": "گوادلوپ",
        "GQ": "استوایی گینه",
        "GR": "یونان",
        "GS": "جنوبی جورجیا و جنوبی ساندویچ جزایر",
        "GT": "گواتمالا",
        "GU": "گوئام",
        "GW": "گینه بیسائو",
        "GY": "گویان",
        "HK": "هنگ کنگ",
        "HM": "هارد و مک‌دونالد جزایر",
        "HN": "هندوراس",
        "HR": "کرواسی",
        "HT": "هاییتی",
        "HU": "مجارستون",
        "IC": "قناری جزایر",
        "ID": "اندونزی",
        "IE": "ایرلند",
        "IL": "ایسراییل",
        "IM": "من ِجزیره",
        "IN": "هند",
        "IO": "بریتانیای هند ِاوقیانوس ِمناطق",
        "IQ": "عراق",
        "IR": "ایران",
        "IS": "ایسلند",
        "IT": "ایتالیا",
        "JE": "جرسی",
        "JM": "جاماییکا",
        "JO": "اردن",
        "JP": "جاپون",
        "KE": "کنیا",
        "KG": "قرقیزستون",
        "KH": "کامبوج",
        "KI": "کیریباتی",
        "KM": "کومور",
        "KN": "سنت کیتس و نویس",
        "KP": "شمالی کُره",
        "KR": "جنوبی کُره",
        "KW": "کویت",
        "KY": "کیمن جزیره‌ئون",
        "KZ": "قزاقستون",
        "LA": "لائوس",
        "LB": "لبنان",
        "LC": "سنت لوسیا",
        "LI": "لیختن اشتاین",
        "LK": "سریلانکا",
        "LR": "لیبریا",
        "LS": "لسوتو",
        "LT": "لتونی",
        "LU": "لوکزامبورگ",
        "LV": "لاتویا",
        "LY": "لیبی",
        "MA": "مراکش",
        "MC": "موناکو",
        "MD": "مولداوی",
        "ME": "مونته‌نگرو",
        "MF": "سنت مارتین",
        "MG": "ماداگاسکار",
        "MH": "مارشال جزایر",
        "MK": "مقدونیه",
        "ML": "مالی",
        "MM": "میانمار",
        "MN": "مغولستون",
        "MO": "ماکائو (چین دله)",
        "MP": "شمالی ماریانا جزایر",
        "MQ": "مارتینیک جزیره‌ئون",
        "MR": "موریتانی",
        "MS": "مونتسرات",
        "MT": "مالت",
        "MU": "مورى تيوس",
        "MV": "مالدیو",
        "MW": "مالاوی",
        "MX": "مکزیک",
        "MY": "مالزی",
        "MZ": "موزامبیک",
        "NA": "نامبیا",
        "NC": "نیو کالیدونیا",
        "NE": "نیجر",
        "NF": "نورفولک جزیره",
        "NG": "نیجریه",
        "NI": "نیکاراگوئه",
        "NL": "هلند",
        "NO": "نروژ",
        "NP": "نپال",
        "NR": "نائورو",
        "NU": "نیئو",
        "NZ": "نیوزلند",
        "OM": "عمان",
        "PA": "پاناما",
        "PE": "پرو",
        "PF": "فرانسه‌ی پولی‌نزی",
        "PG": "پاپوا نو گینه",
        "PH": "فیلیپین",
        "PK": "پاکستون",
        "PL": "لهستون",
        "PM": "سن پییر و میکلن",
        "PN": "پیتکارین جزایر",
        "PR": "پورتوریکو",
        "PS": "فلسطین ِسرزمین",
        "PT": "پرتغال",
        "PW": "پالائو",
        "PY": "پاراگوئه",
        "QA": "قطر",
        "QO": "اوقیانوسیه‌ی ِپرت ِجائون",
        "RE": "رئونیون",
        "RO": "رومانی",
        "RS": "صربستون",
        "RU": "روسیه",
        "RW": "روآندا",
        "SA": "عربستون",
        "SB": "سلیمون جزیره",
        "SC": "سیشل",
        "SD": "سودان",
        "SE": "سوئد",
        "SG": "سنگاپور",
        "SH": "سنت هلنا",
        "SI": "اسلوونی",
        "SJ": "سوالبارد و يان ماين",
        "SK": "اسلواکی",
        "SL": "سیرالئون",
        "SM": "سن مارینو",
        "SN": "سنگال",
        "SO": "سومالی",
        "SR": "سورینام",
        "SS": "جنوبی سودان",
        "ST": "سائوتومه و پرینسیپ",
        "SV": "السالوادور",
        "SX": "سنت مارتن",
        "SY": "سوریه",
        "SZ": "سوازیلند",
        "TA": "تریستان دا جونها",
        "TC": "تورکس و کایکوس جزایر",
        "TD": "چاد",
        "TF": "فرانسه‌ی جنوبی مناطق",
        "TG": "توگو",
        "TH": "تایلند",
        "TJ": "تاجیکستون",
        "TK": "توکلائو",
        "TL": "تیمور شرقی",
        "TM": "ترکمونستون",
        "TN": "تونس",
        "TO": "تونگا",
        "TR": "ترکیه",
        "TT": "ترینیداد و توباگو",
        "TV": "تووالو",
        "TW": "تایوان",
        "TZ": "تانزانیا",
        "UA": "اوکراین",
        "UG": "اوگاندا",
        "UM": "آمریکای پَرتِ‌پِلا جزیره‌ئون",
        "US": "متحده ایالات",
        "UY": "اروگوئه",
        "UZ": "ازبکستون",
        "VA": "واتیکان",
        "VC": "سنت وینسنت و گرنادین",
        "VE": "ونزوئلا",
        "VG": "بریتانیای ویرجین",
        "VI": "آمریکای ویرجین",
        "VN": "ویتنام",
        "VU": "وانواتو",
        "WF": "والیس و فوتونا",
        "WS": "ساموآ",
        "XK": "کوزوو",
        "YE": "یمن",
        "YT": "مایوت",
        "ZA": "جنوبی افریقا",
        "ZM": "زامبیا",
        "ZW": "زیمبابوه",
        "ZZ": "نامَیِّن منطقه"
    };
  }-*/;
}
