/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.GroupDefinitionException;
import javax.validation.groups.Default;

public final class GroupChain {
    private final List<Group> groupList = new ArrayList<Group>();
    private final Map<Class<?>, List<Group>> sequenceMap = new HashMap();

    public void checkDefaultGroupSequenceIsExpandable(List<Class<?>> defaultGroupSequence) throws GroupDefinitionException {
        for (Map.Entry<Class<?>, List<Group>> entry : this.sequenceMap.entrySet()) {
            Class<?> sequence = entry.getKey();
            List<Group> groups = entry.getValue();
            List<Group> defaultGroupList = this.buildTempGroupList(defaultGroupSequence, sequence);
            int defaultGroupIndex = this.containsDefaultGroupAtIndex(sequence, groups);
            if (defaultGroupIndex == -1) continue;
            this.ensureDefaultGroupSequenceIsExpandable(groups, defaultGroupList, defaultGroupIndex);
        }
    }

    public Collection<Group> getAllGroups() {
        return this.groupList;
    }

    public Iterator<Group> getGroupIterator() {
        return this.groupList.iterator();
    }

    public Iterator<List<Group>> getSequenceIterator() {
        return this.sequenceMap.values().iterator();
    }

    public void insertGroup(Group group) {
        if (!this.groupList.contains(group)) {
            this.groupList.add(group);
        }
    }

    public void insertSequence(List<Group> groups) {
        if (groups != null && groups.size() != 0 && !this.sequenceMap.containsValue(groups)) {
            this.sequenceMap.put(groups.get(0).getSequence(), groups);
        }
    }

    public String toString() {
        return "GroupChain{groupList=" + this.groupList + ", sequenceMap=" + this.sequenceMap + "}";
    }

    private List<Group> buildTempGroupList(List<Class<?>> defaultGroupSequence, Class<?> sequence) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Class<?> clazz : defaultGroupSequence) {
            Group g = new Group(clazz, sequence);
            groups.add(g);
        }
        return groups;
    }

    private int containsDefaultGroupAtIndex(Class<?> sequence, List<Group> groupList) {
        Group defaultGroup = new Group(Default.class, sequence);
        return groupList.indexOf(defaultGroup);
    }

    private void ensureDefaultGroupSequenceIsExpandable(List<Group> groupList, List<Group> defaultGroupList, int defaultGroupIndex) throws GroupDefinitionException {
        for (int i = 0; i < defaultGroupList.size(); ++i) {
            int index;
            Group group = defaultGroupList.get(i);
            if (group.getGroup().equals(Default.class) || (index = groupList.indexOf(group)) == -1 || i == 0 && index == defaultGroupIndex - 1 || i == defaultGroupList.size() - 1 && index == defaultGroupIndex + 1) continue;
            throw new GroupDefinitionException("Unable to expand default group list " + defaultGroupList + " into sequence " + groupList);
        }
    }
}

