/* key_data.c
 *
 * Copyright (C) 2006-2023 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */


#include "key_data.h"

/*-------------------------------------------------------------------------
      TSIP v1.09 or later
--------------------------------------------------------------------------*/
#if defined(WOLFSSL_RENESAS_TSIP_TLS) && (WOLFSSL_RENESAS_TSIP_VER >=109)

const st_key_block_data_t g_key_block_data =
{
    /* uint8_t encrypted_provisioning_key[R_TSIP_AES_CBC_IV_BYTE_SIZE * 2]; */
    {
        0x94, 0x4D, 0x99, 0x53, 0xE9, 0x15, 0xD1, 0xD9, 0x0A, 0x2C, 0x17, 0x48,
        0x87, 0x2F, 0x22, 0xA8, 0x90, 0xB3, 0xDE, 0x25, 0x17, 0xEA, 0xE6, 0x31,
        0x28, 0x3F, 0xB9, 0x8F, 0xC6, 0xE3, 0xE4, 0x85
    },
    /* uint8_t iv[R_TSIP_AES_CBC_IV_BYTE_SIZE]; */
    {
        0xF6, 0xA9, 0x83, 0x5A, 0xA1, 0x65, 0x1D, 0x28, 0xC8, 0x1A, 0xA6, 0x9D, 
        0x34, 0xB2, 0x4D, 0x92
    },
    /* 
     * uint8_t 
     * encrypted_user_rsa2048_ne_key[R_TSIP_RSA2048_NE_KEY_BYTE_SIZE + 16];
     */
    {
        0xD9, 0x9A, 0x75, 0x0E, 0x9D, 0x4F, 0x63, 0xA4, 0x02, 0x96, 0xE1, 0xF1,
        0x49, 0x44, 0xB5, 0x90, 0x59, 0x24, 0xC4, 0x23, 0xF7, 0xA0, 0x32, 0x65,
        0x68, 0x7B, 0x70, 0xE7, 0xA5, 0xC8, 0x12, 0xD1, 0xCD, 0x55, 0x36, 0x5F,
        0xE6, 0xEB, 0xD0, 0xAD, 0x5A, 0x7F, 0x9F, 0x41, 0x79, 0x8B, 0x2F, 0x3B,
        0x17, 0xC9, 0xEE, 0xA7, 0xCB, 0xB5, 0x40, 0xFA, 0x3B, 0x43, 0x1D, 0xF8,
        0x34, 0xCC, 0xB1, 0xB4, 0x8E, 0x67, 0xF6, 0xA0, 0x49, 0xAA, 0x76, 0x33,
        0xA4, 0x56, 0xCD, 0x16, 0xE9, 0x76, 0x16, 0x92, 0xBE, 0x3F, 0x3A, 0x3A,
        0xD7, 0x7A, 0xCD, 0xC9, 0xE2, 0xA0, 0xC8, 0x16, 0x2A, 0x0D, 0xBD, 0x3C,
        0xEA, 0xC8, 0x26, 0x82, 0xDA, 0x5D, 0x19, 0x71, 0x7B, 0x90, 0x03, 0xEF,
        0x1E, 0x24, 0x01, 0x62, 0x15, 0x3D, 0x2B, 0x4C, 0xA7, 0x8F, 0xBC, 0xD3,
        0xD9, 0xC8, 0x9F, 0xBB, 0x4A, 0x62, 0x57, 0xE8, 0xE2, 0x86, 0x8C, 0x56,
        0x36, 0x64, 0xE7, 0xB9, 0x47, 0x5C, 0x02, 0xF4, 0x87, 0x50, 0x16, 0x9C,
        0xFB, 0xF6, 0xE9, 0x73, 0x96, 0x78, 0x94, 0x59, 0x12, 0x28, 0x03, 0x37,
        0x75, 0x56, 0x00, 0x2F, 0xCE, 0x54, 0x7C, 0x34, 0xFD, 0x0B, 0x10, 0x5B,
        0x4A, 0xEE, 0x11, 0x1B, 0x39, 0xE9, 0x80, 0x8B, 0x27, 0x2D, 0x29, 0x12,
        0x68, 0x87, 0xD2, 0xC9, 0x78, 0xED, 0xED, 0xF2, 0xA6, 0x4D, 0x6B, 0x10,
        0x98, 0x9D, 0x52, 0x1C, 0xCE, 0x69, 0x0D, 0x5C, 0x46, 0xEB, 0x5D, 0x9B,
        0xC8, 0x6A, 0x8E, 0x1F, 0x56, 0x05, 0xBA, 0xD2, 0x50, 0x9F, 0x92, 0xB7,
        0xD4, 0x4D, 0xCD, 0x58, 0x5B, 0xA7, 0x87, 0x10, 0x6D, 0xF3, 0xDB, 0xA8,
        0x1D, 0x23, 0x00, 0xE4, 0x81, 0x69, 0x3E, 0x7D, 0xEA, 0x5B, 0x33, 0xF4,
        0x73, 0xD8, 0x7C, 0xDD, 0x64, 0x74, 0x40, 0x30, 0x93, 0x8D, 0x2C, 0xA5,
        0x2C, 0x24, 0x11, 0xB2, 0x26, 0x56, 0xE3, 0x41, 0x72, 0xAE, 0x41, 0x56,
        0x9C, 0x75, 0x11, 0x8E, 0x53, 0x59, 0x77, 0xBF, 0x48, 0x71, 0x86, 0x7C,
        0x7C, 0xCE, 0x04, 0xB9, 0x73, 0x62, 0xE6, 0x1D, 0xF8, 0xED, 0x93, 0x87
    },
    /* uint8_t encrypted_user_update_key[R_TSIP_AES256_KEY_BYTE_SIZE + 16]; */
    {
        0
    },
    /* uint8_t
     * encrypted_user_rsa2048_public_key[R_TSIP_RSA2048_NE_KEY_BYTE_SIZE + 16]
     */
    {
        0x22, 0xEC, 0xE3, 0x79, 0xD1, 0x0C, 0xB4, 0xED, 0xE0, 0xA9, 0x0F, 0xBD, 
        0xC7, 0x0B, 0xB4, 0x1E, 0x82, 0x27, 0x79, 0x20, 0x6A, 0x15, 0x56, 0xD6,
        0x0F, 0xFA, 0xE4, 0x61, 0x04, 0xDA, 0x81, 0x33, 0x42, 0xBA, 0x6D, 0xB9,
        0x34, 0x81, 0xFD, 0x67, 0xDF, 0x1D, 0xCB, 0x52, 0x64, 0x9A, 0x2E, 0x30,
        0x12, 0x60, 0xCB, 0x48, 0x27, 0xB6, 0x38, 0x0B, 0x54, 0x5A, 0x70, 0xCB,
        0x6F, 0x05, 0x53, 0x46, 0x8B, 0x08, 0x86, 0x24, 0xCB, 0xA2, 0x36, 0x54,
        0xCD, 0xC9, 0x61, 0x37, 0x43, 0xCB, 0xCC, 0x7C, 0x6B, 0x20, 0x07, 0xB6,
        0x01, 0x96, 0x32, 0xF5, 0x30, 0x0E, 0x96, 0x05, 0xC4, 0xF5, 0xF0, 0xB0,
        0xD3, 0x26, 0xAF, 0x6E, 0x39, 0x01, 0x2D, 0xAC, 0x7E, 0x39, 0xCF, 0x48,
        0x74, 0x7D, 0x98, 0x00, 0xA6, 0x95, 0xDA, 0x4C, 0xAC, 0x81, 0xC7, 0x9A,
        0x93, 0x69, 0x23, 0xD4, 0x39, 0xCD, 0xB3, 0x62, 0x4A, 0x4A, 0x26, 0x95,
        0x51, 0xE1, 0x06, 0x8F, 0xB2, 0x3C, 0x8F, 0xDE, 0xF1, 0xC3, 0x69, 0xFC,
        0xF5, 0xC3, 0xCE, 0x39, 0x3F, 0x7F, 0x2D, 0xA8, 0x8B, 0xB3, 0x2D, 0xE4,
        0xB8, 0xA4, 0x19, 0x55, 0x29, 0xEC, 0x9C, 0x6A, 0xD7, 0xD7, 0x45, 0x3E,
        0x1D, 0x18, 0x52, 0xB5, 0x8A, 0xB1, 0x26, 0x43, 0x8C, 0x7A, 0x65, 0xF1,
        0x17, 0x5E, 0x75, 0x4A, 0x1A, 0x30, 0xD8, 0xEA, 0xC2, 0x19, 0x3C, 0x1E,
        0x2E, 0xFB, 0xDB, 0xC9, 0x1F, 0x73, 0xC9, 0x95, 0x53, 0x8C, 0x99, 0x5D,
        0x3B, 0x59, 0xFE, 0x8B, 0xA1, 0xD2, 0xBB, 0xBC, 0xBC, 0x4B, 0x78, 0x0A,
        0x6B, 0xD8, 0xBE, 0x85, 0x60, 0x08, 0x1E, 0x2F, 0x38, 0x77, 0xA3, 0xC4,
        0x46, 0xC1, 0x42, 0x39, 0xA6, 0x59, 0x98, 0x59, 0x21, 0x94, 0x1F, 0xDC,
        0xB3, 0xAE, 0xA3, 0xB6, 0xCC, 0x35, 0x82, 0x6F, 0x87, 0x58, 0x91, 0x70,
        0xEC, 0x3F, 0x05, 0x86, 0x5E, 0x04, 0x1E, 0xF4, 0xCD, 0xF5, 0xF9, 0x4C,
        0x0D, 0x65, 0x5E, 0x92, 0x1B, 0x67, 0xC5, 0xC5, 0xB6, 0x18, 0x3E, 0x7F,
        0xF7, 0x39, 0xCF, 0xA9, 0x32, 0x44, 0x2B, 0xB6, 0xCB, 0x52, 0x12, 0xAA
    },
    /* uint8_t
     * encrypted_user_rsa2048_private_key[R_TSIP_RSA2048_ND_KEY_BYTE_SIZE + 16]
     */
    {
        0x22, 0xEC, 0xE3, 0x79, 0xD1, 0x0C, 0xB4, 0xED, 0xE0, 0xA9, 0x0F, 0xBD, 
        0xC7, 0x0B, 0xB4, 0x1E, 0x82, 0x27, 0x79, 0x20, 0x6A, 0x15, 0x56, 0xD6,
        0x0F, 0xFA, 0xE4, 0x61, 0x04, 0xDA, 0x81, 0x33, 0x42, 0xBA, 0x6D, 0xB9,
        0x34, 0x81, 0xFD, 0x67, 0xDF, 0x1D, 0xCB, 0x52, 0x64, 0x9A, 0x2E, 0x30,
        0x12, 0x60, 0xCB, 0x48, 0x27, 0xB6, 0x38, 0x0B, 0x54, 0x5A, 0x70, 0xCB,
        0x6F, 0x05, 0x53, 0x46, 0x8B, 0x08, 0x86, 0x24, 0xCB, 0xA2, 0x36, 0x54,
        0xCD, 0xC9, 0x61, 0x37, 0x43, 0xCB, 0xCC, 0x7C, 0x6B, 0x20, 0x07, 0xB6,
        0x01, 0x96, 0x32, 0xF5, 0x30, 0x0E, 0x96, 0x05, 0xC4, 0xF5, 0xF0, 0xB0,
        0xD3, 0x26, 0xAF, 0x6E, 0x39, 0x01, 0x2D, 0xAC, 0x7E, 0x39, 0xCF, 0x48,
        0x74, 0x7D, 0x98, 0x00, 0xA6, 0x95, 0xDA, 0x4C, 0xAC, 0x81, 0xC7, 0x9A,
        0x93, 0x69, 0x23, 0xD4, 0x39, 0xCD, 0xB3, 0x62, 0x4A, 0x4A, 0x26, 0x95,
        0x51, 0xE1, 0x06, 0x8F, 0xB2, 0x3C, 0x8F, 0xDE, 0xF1, 0xC3, 0x69, 0xFC,
        0xF5, 0xC3, 0xCE, 0x39, 0x3F, 0x7F, 0x2D, 0xA8, 0x8B, 0xB3, 0x2D, 0xE4,
        0xB8, 0xA4, 0x19, 0x55, 0x29, 0xEC, 0x9C, 0x6A, 0xD7, 0xD7, 0x45, 0x3E,
        0x1D, 0x18, 0x52, 0xB5, 0x8A, 0xB1, 0x26, 0x43, 0x8C, 0x7A, 0x65, 0xF1,
        0x17, 0x5E, 0x75, 0x4A, 0x1A, 0x30, 0xD8, 0xEA, 0xC2, 0x19, 0x3C, 0x1E,
        0x2E, 0xFB, 0xDB, 0xC9, 0x1F, 0x73, 0xC9, 0x95, 0x53, 0x8C, 0x99, 0x5D,
        0x3B, 0x59, 0xFE, 0x8B, 0xA1, 0xD2, 0xBB, 0xBC, 0xBC, 0x4B, 0x78, 0x0A,
        0x6B, 0xD8, 0xBE, 0x85, 0x60, 0x08, 0x1E, 0x2F, 0x38, 0x77, 0xA3, 0xC4,
        0x46, 0xC1, 0x42, 0x39, 0xA6, 0x59, 0x98, 0x59, 0x21, 0x94, 0x1F, 0xDC,
        0xB3, 0xAE, 0xA3, 0xB6, 0xCC, 0x35, 0x82, 0x6F, 0x87, 0x58, 0x91, 0x70,
        0xEC, 0x3F, 0x05, 0x86, 0x3C, 0xD1, 0x83, 0xB0, 0xBA, 0xE8, 0xD7, 0xF6,
        0xE5, 0x9E, 0x50, 0xA4, 0x04, 0xF3, 0x95, 0x9C, 0x41, 0xAF, 0xEB, 0x9D,
        0xB6, 0xA2, 0xF7, 0x80, 0x5A, 0xC4, 0x67, 0xD4, 0xFD, 0x0C, 0x2A, 0x7C,
        0x24, 0x03, 0xE5, 0x7F, 0x08, 0x69, 0x18, 0x4E, 0x33, 0x22, 0x7E, 0x03,
        0x8E, 0x13, 0xFB, 0xC6, 0x9B, 0xA3, 0x44, 0x5B, 0xEC, 0xF9, 0x5C, 0x93,
        0x3E, 0x9F, 0xBD, 0x72, 0x50, 0x52, 0xF3, 0xEA, 0x34, 0x2B, 0x8E, 0xEC,
        0x17, 0x42, 0x1A, 0xDF, 0x57, 0xA2, 0x66, 0xA7, 0x0B, 0x3B, 0xE5, 0xF7,
        0x64, 0x44, 0xA2, 0xA3, 0x5F, 0xB7, 0x5B, 0xF5, 0x99, 0x8C, 0xA0, 0x64,
        0x04, 0x46, 0x7C, 0x60, 0x75, 0xE4, 0xD9, 0xD5, 0xED, 0x21, 0x1D, 0x65,
        0x5D, 0x25, 0x21, 0x90, 0x7D, 0xA4, 0x95, 0x15, 0x54, 0x91, 0xD6, 0xB8,
        0xF9, 0xB7, 0x30, 0xD9, 0x7D, 0x2C, 0x7E, 0x85, 0x6A, 0xCF, 0x31, 0x1C,
        0xDC, 0x90, 0xA3, 0x75, 0xA4, 0xE4, 0x89, 0x5F, 0x2B, 0xED, 0x93, 0x4E,
        0xA8, 0x35, 0xD3, 0x20, 0x36, 0x7A, 0x02, 0x23, 0x70, 0xB7, 0xC2, 0x39,
        0xA4, 0x69, 0xB2, 0xBF, 0xA4, 0x3A, 0x6D, 0xB7, 0xB1, 0x32, 0x32, 0x9A,
        0x95, 0xEA, 0x02, 0xD2, 0x35, 0xE7, 0x8C, 0xD8, 0x22, 0xA9, 0xC3, 0x4C,
        0x68, 0x09, 0xA1, 0x2B, 0xB0, 0xE4, 0x55, 0x72, 0x7E, 0xE6, 0x00, 0xDD,
        0xC6, 0xD1, 0x83, 0x56, 0x08, 0x35, 0xC7, 0x9A, 0x98, 0x0C, 0x79, 0xBD,
        0x49, 0xBC, 0x3F, 0x45, 0x4A, 0x38, 0x1B, 0x55, 0x2D, 0x52, 0x57, 0x00,
        0xFC, 0xDB, 0xE7, 0xA0, 0x53, 0xB4, 0x63, 0xE4, 0x37, 0xEC, 0x9F, 0xF0,
        0xA4, 0x0F, 0xEF, 0x06, 0xF0, 0xC6, 0x5F, 0x0C, 0x4A, 0xB8, 0xC1, 0x96,
        0x1D, 0x0D, 0x9A, 0x43, 0x89, 0xA4, 0xF6, 0x55, 0x4A, 0x83, 0x54, 0x3F,
        0xCC, 0x09, 0x65, 0x34, 0xC0, 0x0F, 0x42, 0xF2, 0xE6, 0xDD, 0x2D, 0x8C,
        0x93, 0x42, 0x09, 0xF6, 0xE4, 0xDF, 0xB2, 0x64, 0x2A, 0x12, 0x7A, 0x59
    },
    /* uint8_t
     * encrypted_user_ecc256_public_key[R_TSIP_ECC_PUBLIC_KEY_BYTE_SIZE + 16];
     */
    {   
        0xD5, 0xC3, 0x55, 0x9A, 0xA4, 0xFB, 0xB0, 0x86, 0x0A, 0x75, 0x20, 0x6A,
        0xF9, 0x20, 0x63, 0xC6, 0xA0, 0xB8, 0xED, 0x91, 0xAF, 0x42, 0xD0, 0x23,
        0x99, 0xF8, 0x21, 0xF1, 0x22, 0x6C, 0xB5, 0x42, 0x6A, 0x29, 0xB4, 0xC4,
        0x96, 0xA4, 0x9C, 0xB2, 0xA2, 0x79, 0xC1, 0xAB, 0x55, 0xEE, 0xDE, 0xF6,
        0xFE, 0xA1, 0xD7, 0x99, 0x3A, 0x91, 0xF7, 0x4E, 0xC1, 0xB2, 0xE0, 0x3F,
        0x07, 0xD6, 0xA4, 0xFB, 0xF6, 0x61, 0x00, 0xAE, 0x52, 0x6B, 0x1A, 0xCC,
        0x70, 0x2F, 0xC4, 0xE2, 0x60, 0x36, 0x01, 0x17
    },
    /* uint8_t
     * encrypted_user_ecc256_private_key[R_TSIP_ECC_PRIVATE_KEY_BYTE_SIZE + 16];
     */
    {
        0x25, 0x7A, 0x0C, 0x8C, 0x9B, 0xF9, 0x3C, 0xF5, 0x49, 0x08, 0x86, 0x92,
        0x00, 0x7D, 0xAB, 0x21, 0x23, 0x38, 0xF8, 0xEA, 0xB0, 0x95, 0x59, 0x9B,
        0x04, 0xC8, 0xAA, 0xEA, 0x8C, 0x2D, 0x68, 0xF4, 0xD5, 0xD7, 0xA9, 0x6F,
        0x2C, 0x8C, 0x13, 0x93, 0xA3, 0x80, 0x11, 0xF9, 0x0F, 0x36, 0x14, 0xA8
    },
};

/* Public key type of CA root cert: 0: RSA-2048 2: ECDSA-P256*/
#if defined(USE_ECC_CERT)
const uint32_t              encrypted_user_key_type =
                                    R_TSIP_TLS_PUBLIC_KEY_TYPE_ECDSA_P256;
#else
const uint32_t              encrypted_user_key_type =
                                    R_TSIP_TLS_PUBLIC_KEY_TYPE_RSA2048;
#endif

const unsigned char ca_ecc_cert_der_sig[] =
{
    0xc0, 0x3c, 0x28, 0xef, 0x6c, 0xd5, 0x6c, 0x36, 0xc5, 0xe5, 0xb0, 0xaa,
    0xd0, 0x6a, 0x33, 0x1d, 0x7b, 0x28, 0x9f, 0xb2, 0x12, 0x8c, 0x0c, 0x5c,
    0x30, 0xdf, 0x8f, 0x3f, 0x2e, 0x72, 0x0f, 0x3d, 0x8d, 0x4a, 0x1d, 0xa6,
    0xc5, 0x1f, 0xb4, 0xf2, 0x18, 0xf1, 0x65, 0x40, 0x8e, 0xf2, 0x06, 0x0a,
    0xda, 0xa4, 0xd6, 0x3d, 0x87, 0x61, 0x00, 0xd6, 0x89, 0x4e, 0x77, 0xbd,
    0x57, 0xd7, 0x5f, 0x04, 0xe9, 0x0c, 0x96, 0x68, 0xa9, 0x72, 0xa2, 0xba,
    0x46, 0x3f, 0x35, 0xeb, 0xf9, 0x4f, 0x10, 0xfd, 0x51, 0x39, 0x7c, 0x44,
    0xa8, 0xa8, 0xd3, 0x62, 0x81, 0x2f, 0x82, 0x90, 0x3e, 0xea, 0xe9, 0xbc,
    0x2e, 0xd1, 0x19, 0xc0, 0xb6, 0xd7, 0xc0, 0x22, 0x7c, 0xc1, 0x64, 0x61,
    0xd2, 0x79, 0x01, 0x2d, 0x19, 0x7a, 0xf0, 0x34, 0x68, 0x78, 0x01, 0x35,
    0x7f, 0xe2, 0xbe, 0x11, 0x8f, 0x0d, 0x04, 0xa8, 0xa4, 0x7b, 0x4e, 0x7a,
    0x9c, 0xa0, 0x91, 0x3f, 0x7d, 0xdf, 0xe4, 0x69, 0x2f, 0x9b, 0x73, 0xc6,
    0x1d, 0x4b, 0x3e, 0xcd, 0xa8, 0x2d, 0xf1, 0xfc, 0x35, 0x5c, 0xae, 0x7e,
    0xef, 0xd9, 0x91, 0x7c, 0x32, 0xc3, 0x5a, 0xcb, 0x5f, 0xd9, 0x99, 0x1b,
    0xb3, 0x6d, 0xa1, 0xaf, 0x69, 0x45, 0x41, 0xca, 0x92, 0x01, 0x93, 0x18,
    0xb7, 0x4c, 0x35, 0xe0, 0x11, 0x16, 0xc7, 0xf2, 0xf9, 0xf1, 0x9e, 0xa5,
    0xda, 0x60, 0x41, 0x78, 0x67, 0xef, 0x2f, 0x85, 0x08, 0xfe, 0x21, 0x1f,
    0xdd, 0x31, 0xce, 0x70, 0xf2, 0xe2, 0x6f, 0xc1, 0x5f, 0xce, 0xa7, 0x4c,
    0x3a, 0x1a, 0x81, 0x5d, 0xec, 0x35, 0xad, 0xf3, 0xb4, 0x46, 0x83, 0x9b,
    0x95, 0x98, 0xcc, 0xa5, 0x46, 0x74, 0xdf, 0xca, 0xf9, 0x2e, 0x86, 0xe8,
    0x04, 0x18, 0x33, 0x91, 0x94, 0xb7, 0xca, 0x98, 0xf7, 0xc2, 0xfe, 0x99,
    0xc0, 0x73, 0x11, 0x1e
};
const int sizeof_ca_ecc_cert_sig = sizeof(ca_ecc_cert_der_sig);

/* ./ca-cert.der.sign,  */
const unsigned char ca_cert_der_sig[] =
{
    0x97, 0x8f, 0x90, 0x03, 0x0b, 0xca, 0xdf, 0x8f, 0xe8, 0x51, 0x23, 0xba,
    0x14, 0xfb, 0x28, 0xb8, 0x5c, 0x58, 0x0d, 0x6e, 0x8b, 0x97, 0x0f, 0x89,
    0x63, 0xc2, 0xd6, 0xb3, 0xf0, 0x16, 0x35, 0x74, 0x9d, 0xb9, 0xd7, 0x18,
    0x14, 0x86, 0x91, 0xe0, 0xcd, 0xb3, 0x28, 0x63, 0x16, 0xf4, 0x6c, 0xb1,
    0xd3, 0x93, 0xb6, 0x6e, 0xd9, 0x66, 0xcd, 0x65, 0x39, 0x7b, 0x1b, 0x74,
    0x5c, 0xde, 0x20, 0xd4, 0x46, 0x60, 0x2f, 0xc0, 0x10, 0xf5, 0x49, 0x4a,
    0x8d, 0x31, 0x29, 0x9b, 0x8a, 0xea, 0xf4, 0x8a, 0xaf, 0xc4, 0x84, 0xd7,
    0x42, 0xef, 0xaf, 0x14, 0x17, 0x44, 0xed, 0x6e, 0x2b, 0xd9, 0x70, 0xed,
    0x3e, 0x40, 0xf0, 0xef, 0x75, 0x4c, 0x05, 0x1f, 0xc3, 0x37, 0xec, 0xc2,
    0xcd, 0xcc, 0xce, 0x39, 0x61, 0xa0, 0xea, 0x16, 0x84, 0x6d, 0xde, 0xe7,
    0xf4, 0x0d, 0x8c, 0xf7, 0x69, 0x81, 0x64, 0x09, 0x16, 0xa7, 0x5b, 0x34,
    0x83, 0xe5, 0x73, 0xcf, 0x02, 0xf4, 0x37, 0x96, 0x93, 0x27, 0x72, 0x47,
    0x71, 0xca, 0x56, 0xcd, 0xd2, 0x85, 0x48, 0xe5, 0x9e, 0x1f, 0x39, 0x52,
    0xc1, 0xc3, 0x9c, 0x6b, 0x98, 0x41, 0xc2, 0x0a, 0x77, 0x94, 0xe5, 0x84,
    0x44, 0xe7, 0x94, 0xee, 0x5f, 0x05, 0x62, 0xad, 0xe5, 0xe5, 0xc9, 0x7e,
    0x02, 0x31, 0x85, 0xca, 0x28, 0x2d, 0x0d, 0x7f, 0x30, 0x5d, 0xb5, 0xaa,
    0x12, 0x81, 0x25, 0x37, 0x4a, 0xf2, 0x95, 0x81, 0xda, 0x76, 0xb4, 0x89,
    0x76, 0x8a, 0x0c, 0x8d, 0xdf, 0xed, 0xd5, 0x48, 0xa8, 0xc8, 0x6d, 0xf4,
    0xbf, 0x98, 0xa3, 0xc5, 0x42, 0x7d, 0xd2, 0x21, 0x2c, 0x8d, 0x57, 0xd0,
    0x91, 0x16, 0xee, 0x83, 0xd0, 0xa1, 0x8f, 0x05, 0x50, 0x2b, 0x6e, 0xe8,
    0x52, 0xf7, 0xbe, 0x96, 0x89, 0x40, 0xca, 0x9c, 0x19, 0x5a, 0xfc, 0xae,
    0x1d, 0xdb, 0x57, 0xb8
};
const int sizeof_ca_cert_sig = sizeof(ca_cert_der_sig);
/* ./client-cert.der.sign,  */
const unsigned char client_cert_der_sign[] =
{
    0x9a, 0x0e, 0xbc, 0x0f, 0x7a, 0xbe, 0xb6, 0x47, 0x79, 0x71, 0xcc, 0x51,
    0x87, 0xaa, 0x28, 0xbd, 0x9c, 0x04, 0x08, 0x0b, 0xb9, 0x78, 0x84, 0xeb,
    0x1d, 0xf9, 0x0e, 0x38, 0x23, 0xfe, 0x8f, 0x6e, 0x75, 0x21, 0xcc, 0x39,
    0x79, 0xf8, 0x9d, 0x80, 0x6b, 0xa9, 0x63, 0x79, 0x13, 0xd8, 0xc9, 0x5d,
    0xd5, 0x84, 0x17, 0xdc, 0xe4, 0x56, 0xae, 0x55, 0x64, 0x69, 0x8c, 0x95,
    0xa4, 0x03, 0xc1, 0x4a, 0xe8, 0xb6, 0xd5, 0x1b, 0xfa, 0x26, 0x3f, 0x2c,
    0xff, 0xfc, 0xea, 0x83, 0xca, 0xf7, 0x4d, 0x9e, 0xf4, 0xbf, 0xca, 0xb6,
    0x19, 0x46, 0x55, 0x45, 0xf4, 0x7d, 0xcd, 0x4b, 0xbc, 0x3d, 0xb7, 0xff,
    0x57, 0xbf, 0xe8, 0x0e, 0xbc, 0x16, 0x45, 0xa1, 0xdb, 0xf0, 0xb4, 0x44,
    0x64, 0x76, 0x0b, 0xe5, 0x86, 0x32, 0xbe, 0xd7, 0xf0, 0x26, 0x6c, 0x48,
    0xb6, 0x7f, 0x1a, 0x2a, 0xe6, 0x1b, 0xbd, 0x5b, 0x9e, 0xca, 0xd0, 0xf4,
    0xbb, 0xe4, 0x7f, 0x29, 0x66, 0xf6, 0x31, 0x6d, 0x70, 0x6f, 0xfd, 0x4d,
    0x7f, 0xc8, 0x7f, 0x9a, 0x5b, 0x1e, 0x37, 0xf7, 0x0c, 0x66, 0xb2, 0x62,
    0xd8, 0x3e, 0xca, 0x79, 0x6c, 0xec, 0x05, 0x01, 0xda, 0xd9, 0xe2, 0xc3,
    0xd5, 0x9b, 0xf9, 0x43, 0xa6, 0x14, 0x9a, 0x1f, 0x32, 0xd3, 0x68, 0x63,
    0x65, 0xb8, 0xb1, 0x63, 0xd5, 0xe2, 0xaa, 0x06, 0x27, 0x62, 0x4a, 0x95,
    0x48, 0x3f, 0xee, 0xde, 0x3b, 0x89, 0xd4, 0x61, 0x74, 0x39, 0xef, 0xe6,
    0x6e, 0x16, 0x2d, 0x8b, 0x54, 0x29, 0xe9, 0x71, 0xbc, 0xd4, 0x30, 0x42,
    0x35, 0x1e, 0x89, 0xfb, 0xf7, 0x4a, 0x47, 0x87, 0x41, 0x66, 0x49, 0xe5,
    0x8e, 0x16, 0x7f, 0x17, 0x07, 0xd6, 0xff, 0xe1, 0x2a, 0x4d, 0x7c, 0x70,
    0x0d, 0x72, 0x5d, 0x3d, 0x1f, 0xd8, 0x41, 0x1a, 0x43, 0x00, 0x31, 0x81,
    0x60, 0xa8, 0x6c, 0xef
};
const int sizeof_client_cert_der_sign = sizeof(client_cert_der_sign);

uint32_t s_inst1[R_TSIP_SINST_WORD_SIZE] = { 0 };
uint32_t s_inst2[R_TSIP_SINST2_WORD_SIZE]= { 0 };
#endif
