/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.policy;

import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;

public class JmsDefaultRedeliveryPolicy
implements JmsRedeliveryPolicy {
    public static final int DEFAULT_MAX_REDELIVERIES = -1;
    public static final int DEFAULT_OUTCOME = 5;
    private int maxRedeliveries;
    private int outcome;

    public JmsDefaultRedeliveryPolicy() {
        this.maxRedeliveries = -1;
        this.outcome = 5;
    }

    public JmsDefaultRedeliveryPolicy(JmsDefaultRedeliveryPolicy source) {
        this.maxRedeliveries = source.maxRedeliveries;
        this.outcome = source.outcome;
    }

    @Override
    public JmsDefaultRedeliveryPolicy copy() {
        return new JmsDefaultRedeliveryPolicy(this);
    }

    @Override
    public int getMaxRedeliveries(JmsDestination destination) {
        return this.maxRedeliveries;
    }

    @Override
    public int getOutcome(JmsDestination destination) {
        return this.outcome;
    }

    public int getOutcome() {
        return this.outcome;
    }

    public void setOutcome(int outcome) {
        this.outcome = OUTCOME.getMappedOutcome(outcome).getOutcomeOrdinal();
    }

    public void setOutcome(String outcome) {
        try {
            this.outcome = OUTCOME.valueOf(outcome.toUpperCase()).getOutcomeOrdinal();
        }
        catch (IllegalArgumentException iae) {
            try {
                this.setOutcome(Integer.parseInt(outcome));
            }
            catch (NumberFormatException e) {
                throw iae;
            }
        }
    }

    public int getMaxRedeliveries() {
        return this.maxRedeliveries;
    }

    public void setMaxRedeliveries(int maxRedeliveries) {
        this.maxRedeliveries = maxRedeliveries;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxRedeliveries;
        result = 31 * result + this.outcome;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsDefaultRedeliveryPolicy other = (JmsDefaultRedeliveryPolicy)obj;
        return this.maxRedeliveries == other.maxRedeliveries && this.outcome == other.outcome;
    }

    private static enum OUTCOME {
        ACCEPTED(1),
        REJECTED(2),
        RELEASED(3),
        MODIFIED_FAILED(4),
        MODIFIED_FAILED_UNDELIVERABLE(5);

        private final int outcome;

        private OUTCOME(int outcome) {
            this.outcome = outcome;
        }

        public int getOutcomeOrdinal() {
            return this.outcome;
        }

        public static OUTCOME getMappedOutcome(int value) {
            switch (value) {
                case 1: {
                    return ACCEPTED;
                }
                case 2: {
                    return REJECTED;
                }
                case 3: {
                    return RELEASED;
                }
                case 4: {
                    return MODIFIED_FAILED;
                }
                case 5: {
                    return MODIFIED_FAILED_UNDELIVERABLE;
                }
            }
            throw new IllegalArgumentException("Specified outcome is not a legal value: " + value);
        }
    }
}

