/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleStateSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWiring;

public abstract class BaseResource {
    final BundleContext bundleContext;
    final Bundle framework;
    @Context
    volatile UriInfo uriInfo;
    @Context
    volatile HttpHeaders headers;

    public BaseResource(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.framework = bundleContext.getBundle(0L);
    }

    BundleStateSchema bundleStateSchema(Bundle bundle) {
        int state = bundle.getState();
        BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return BundleStateSchema.build(state, (bundleStartLevel.isActivationPolicyUsed() ? 2 : 0) | ((state & 0x38) != 0 ? (bundleStartLevel.isPersistentlyStarted() ? 0 : 1) : 0));
    }

    BundleSchema bundleSchema(Bundle bundle) {
        return BundleSchema.build(bundle.getBundleId(), bundle.getLastModified(), bundle.getState(), bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getLocation());
    }

    static Predicate<Bundle> fromNamespaceQuery(UriInfo info) {
        MultivaluedMap parameters = info.getQueryParameters(true);
        if (parameters.isEmpty()) {
            return b -> true;
        }
        Map filters = parameters.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), (String)v))).map(e -> new AbstractMap.SimpleEntry<String, Filter>((String)e.getKey(), BaseResource.create((String)e.getValue()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        if (filters.isEmpty()) {
            return b -> true;
        }
        return b -> {
            BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
            return filters.entrySet().stream().allMatch(entry -> {
                String namespace = (String)entry.getKey();
                List caps = wiring.getCapabilities(namespace);
                return ((List)entry.getValue()).stream().anyMatch(f -> caps.stream().anyMatch(cap -> f.matches(cap.getAttributes())));
            });
        };
    }

    static Predicate<ServiceReferenceDTO> fromFilterQuery(String filter) {
        return Optional.ofNullable(filter).map(BaseResource::create).map(BaseResource.toPredicate()).orElseGet(() -> sr -> true);
    }

    static Filter create(String filter) {
        try {
            return FrameworkUtil.createFilter((String)filter);
        }
        catch (InvalidSyntaxException e) {
            throw new WebApplicationException(String.format("Malformed filter [%s]", filter), Response.Status.BAD_REQUEST);
        }
    }

    static Function<Filter, Predicate<ServiceReferenceDTO>> toPredicate() {
        return f -> sr -> f.matches(sr.properties);
    }
}

