/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchemaListSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FrameworkBundlesRepresentationsResource
extends BaseResource {
    public FrameworkBundlesRepresentationsResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.bundles.representations+json", "application/org.osgi.bundles.representations+xml"})
    @Path(value="framework/bundles/representations{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/bundles/representations", summary="Retrieve the bundle representation of each installed bundle", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=BundleSchemaListSchema.class))}), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")}, parameters={@Parameter(name="<capability_namespace>", in=ParameterIn.QUERY, description="A query parameter whose name is an osgi capability namespace and whose value is a filter expression that follows the Core Specifications Framework Filter Syntax; see OSGi Core, Chapter 3.2.7 Filter Syntax. Filters are matched against the attributes of capabilities in the respective namespaces. If multiple capabilities for a given namespace are present, then a filter succeeds when one of these capabilities matches. When multiple filter expressions across namespaces are given, these are combined with the and operator.", examples={@ExampleObject(summary="format: <capability_namespace>=<filter_string>", value="osgi.identity=(osgi.identity=foo)&osgi.package.wiring=(osgi.package.wiring=com.foo)")})})
    public Response bundlesRepresentations(@Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Predicate<Bundle> predicate = FrameworkBundlesRepresentationsResource.fromNamespaceQuery(this.uriInfo);
        Response.ResponseBuilder builder = Response.ok((Object)((Object)BundleSchemaListSchema.build(Stream.of(this.bundleContext.getBundles()).filter(predicate).map(this::bundleSchema).collect(Collectors.toList()))));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundles.representations+json" : "application/org.osgi.bundles.representations+xml").map(type -> builder.type(type)).orElse(builder).build();
    }
}

