/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public final class MBeans {
    private static final Logger LOG = LoggerFactory.getLogger(MBeans.class);
    private static final String DOMAIN_PREFIX = "Hadoop:";
    private static final String SERVICE_PREFIX = "service=";
    private static final String NAME_PREFIX = "name=";
    private static final Pattern MBEAN_NAME_PATTERN = Pattern.compile("^Hadoop:service=([^,]+),name=(.+)$");

    private MBeans() {
    }

    public static ObjectName register(String serviceName, String nameName, Object theMbean) {
        return MBeans.register(serviceName, nameName, new HashMap<String, String>(), theMbean);
    }

    public static ObjectName register(String serviceName, String nameName, Map<String, String> properties, Object theMbean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Preconditions.checkNotNull(properties, "JMX bean properties should not be null for bean registration.");
        ObjectName name = MBeans.getMBeanName(serviceName, nameName, properties);
        if (name != null) {
            try {
                mbs.registerMBean(theMbean, name);
                LOG.debug("Registered " + name);
                return name;
            }
            catch (InstanceAlreadyExistsException iaee) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Failed to register MBean \"" + name + "\"", iaee);
                } else {
                    LOG.warn("Failed to register MBean \"" + name + "\": Instance already exists.");
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to register MBean \"" + name + "\"", e);
            }
        }
        return null;
    }

    public static String getMbeanNameService(ObjectName objectName) {
        Matcher matcher = MBEAN_NAME_PATTERN.matcher(objectName.toString());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException(objectName + " is not a valid Hadoop mbean");
    }

    public static String getMbeanNameName(ObjectName objectName) {
        Matcher matcher = MBEAN_NAME_PATTERN.matcher(objectName.toString());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        throw new IllegalArgumentException(objectName + " is not a valid Hadoop mbean");
    }

    public static void unregister(ObjectName mbeanName) {
        LOG.debug("Unregistering " + mbeanName);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbeanName == null) {
            LOG.debug("Stacktrace: ", new Throwable());
            return;
        }
        try {
            mbs.unregisterMBean(mbeanName);
        }
        catch (Exception e) {
            LOG.warn("Error unregistering " + mbeanName, e);
        }
        DefaultMetricsSystem.removeMBeanName(mbeanName);
    }

    @VisibleForTesting
    static ObjectName getMBeanName(String serviceName, String nameName, Map<String, String> additionalParameters) {
        String additionalKeys = additionalParameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
        String nameStr = "Hadoop:service=" + serviceName + "," + NAME_PREFIX + nameName + (additionalKeys.isEmpty() ? "" : "," + additionalKeys);
        try {
            return DefaultMetricsSystem.newMBeanName(nameStr);
        }
        catch (Exception e) {
            LOG.warn("Error creating MBean object name: " + nameStr, e);
            return null;
        }
    }
}

