/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.zookeeper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperDriver;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNodeImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;

public class ZooKeeperSshDriver
extends JavaSoftwareProcessSshDriver
implements ZooKeeperDriver {
    public ZooKeeperSshDriver(ZooKeeperNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "console.out"});
    }

    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"zookeeperPort", (Object)this.getZooKeeperPort());
    }

    protected String getConfigFileName() {
        return (String)this.entity.getConfig(ZooKeeperNode.ZOOKEEPER_CONFIG_TEMPLATE);
    }

    protected Integer getMyId() {
        return (Integer)this.entity.config().get(ZooKeeperNode.MY_ID);
    }

    public List<ZooKeeperServerConfig> getZookeeperServers() throws ExecutionException, InterruptedException {
        ArrayList result = Lists.newArrayList();
        if (this.entity.getParent() instanceof ZooKeeperEnsemble) {
            ZooKeeperEnsemble ensemble = (ZooKeeperEnsemble)this.entity.getParent();
            for (Entity member : ensemble.getMembers()) {
                Integer memberId = (Integer)member.config().get(ZooKeeperNode.MY_ID);
                if (memberId == null) {
                    throw new IllegalStateException(member + " has null value for " + ZooKeeperNode.MY_ID);
                }
                String hostname = (String)Entities.attributeSupplierWhenReady((Entity)member, (AttributeSensor)ZooKeeperNode.SUBNET_HOSTNAME).get();
                Integer port = (Integer)Entities.attributeSupplierWhenReady((Entity)member, (AttributeSensor)ZooKeeperNode.ZOOKEEPER_PORT).get();
                Integer leaderPort = (Integer)Entities.attributeSupplierWhenReady((Entity)member, (AttributeSensor)ZooKeeperNode.ZOOKEEPER_LEADER_PORT).get();
                Integer electionPort = (Integer)Entities.attributeSupplierWhenReady((Entity)member, (AttributeSensor)ZooKeeperNode.ZOOKEEPER_ELECTION_PORT).get();
                result.add(new ZooKeeperServerConfig(memberId, hostname, port, leaderPort, electionPort));
            }
        }
        return result;
    }

    @Override
    public Integer getZooKeeperPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)ZooKeeperNode.ZOOKEEPER_PORT);
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)BashCommands.INSTALL_TAR).add((Object)("tar xzfv " + saveAs)).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        log.debug("Customizing {}", (Object)this.entity);
        Networking.checkPortsValid(this.getPortMap());
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("cp -R %s/* .", this.getExpandedInstallDir()), String.format("mkdir %s/zookeeper", this.getRunDir()), String.format("echo %d > %s/zookeeper/myid", this.getMyId(), this.getRunDir())}).execute();
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf/zoo.cfg"});
        this.copyTemplate(this.getConfigFileName(), destinationConfigFile);
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "zookeeper.pid"});
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").body.append((CharSequence)String.format("nohup java $JAVA_OPTS -cp zookeeper-%s.jar:lib/*:conf org.apache.zookeeper.server.quorum.QuorumPeerMain conf/zoo.cfg > %s 2>&1 &", this.getVersion(), this.getLogFileLocation())).execute();
    }

    public static class ZooKeeperServerConfig {
        private final Integer myid;
        private final String hostname;
        private final Integer port;
        private final Integer leaderPort;
        private final Integer electionPort;

        public ZooKeeperServerConfig(Integer myid, String hostname, Integer port, Integer leaderPort, Integer electionPort) {
            this.myid = myid;
            this.hostname = hostname;
            this.port = port;
            this.leaderPort = leaderPort;
            this.electionPort = electionPort;
        }

        public Integer getMyid() {
            return this.myid;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Integer getPort() {
            return this.port;
        }

        public Integer getLeaderPort() {
            return this.leaderPort;
        }

        public Integer getElectionPort() {
            return this.electionPort;
        }
    }
}

