/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T, L extends KubernetesResourceList>
implements Watch {
    private static final Logger logger = LoggerFactory.getLogger(WatchConnectionManager.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AtomicBoolean forceClosed = new AtomicBoolean();
    private final AtomicReference<String> resourceVersion;
    private final BaseOperation<T, L, ?, ?> baseOperation;
    private final Watcher<T> watcher;
    private final int reconnectLimit;
    private final int reconnectInterval;
    private final long websocketTimeout;
    private final long websocketPingInterval;
    private final AtomicInteger currentReconnectAttempt = new AtomicInteger(0);
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private WebSocketCall webSocketCall;
    private ScheduledFuture pingFuture;
    private OkHttpClient clonedClient;

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?, ?> baseOperation, String version, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout, long websocketPingInterval) throws InterruptedException, ExecutionException, MalformedURLException {
        if (version == null) {
            L currentList = baseOperation.list();
            this.resourceVersion = new AtomicReference<String>(currentList.getMetadata().getResourceVersion());
        } else {
            this.resourceVersion = new AtomicReference<String>(version);
        }
        this.baseOperation = baseOperation;
        this.watcher = watcher;
        this.reconnectInterval = reconnectInterval;
        this.reconnectLimit = reconnectLimit;
        this.websocketTimeout = websocketTimeout;
        this.websocketPingInterval = websocketPingInterval;
        this.clonedClient = client.newBuilder().readTimeout(this.websocketTimeout, TimeUnit.MILLISECONDS).build();
        this.runWatch();
    }

    private final void runWatch() throws MalformedURLException, ExecutionException, InterruptedException {
        URL requestUrl = this.baseOperation.getNamespacedUrl();
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)requestUrl).newBuilder();
        String labelQueryParam = this.baseOperation.getLabelQueryParam();
        if (Utils.isNotNullOrEmpty(labelQueryParam)) {
            httpUrlBuilder.addQueryParameter("labelSelector", labelQueryParam);
        }
        String fieldQueryString = this.baseOperation.getFieldQueryParam();
        String name = this.baseOperation.getName();
        if (name != null && name.length() > 0) {
            if (fieldQueryString.length() > 0) {
                fieldQueryString = fieldQueryString + ",";
            }
            fieldQueryString = fieldQueryString + "metadata.name=" + name;
        }
        if (Utils.isNotNullOrEmpty(fieldQueryString)) {
            httpUrlBuilder.addQueryParameter("fieldSelector", fieldQueryString);
        }
        httpUrlBuilder.addQueryParameter("resourceVersion", this.resourceVersion.get()).addQueryParameter("watch", "true");
        Request request = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", requestUrl.getProtocol() + "://" + requestUrl.getHost() + ":" + requestUrl.getPort()).build();
        this.webSocketCall = WebSocketCall.create((OkHttpClient)this.clonedClient, (Request)request);
        this.webSocketCall.enqueue(new WebSocketListener(){

            public void onOpen(final WebSocket webSocket, Response response) {
                if (response != null && response.body() != null) {
                    response.body().close();
                }
                logger.debug("WebSocket successfully opened");
                WatchConnectionManager.this.webSocketRef.set(webSocket);
                WatchConnectionManager.this.currentReconnectAttempt.set(0);
                WatchConnectionManager.this.started.set(true);
                WatchConnectionManager.this.queue.clear();
                WatchConnectionManager.this.queue.add(true);
                WatchConnectionManager.this.pingFuture = WatchConnectionManager.this.executor.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        if (!WatchConnectionManager.this.forceClosed.get()) {
                            try {
                                webSocket.sendPing(new Buffer().writeUtf8("Alive?"));
                            }
                            catch (IOException e) {
                                logger.debug("Failed to send ping", (Throwable)e);
                                this.onClose(4000, "Connection unexpectedly closed");
                            }
                        }
                    }
                }, 0L, WatchConnectionManager.this.websocketPingInterval, TimeUnit.MILLISECONDS);
            }

            public void onFailure(IOException e, Response response) {
                if (response != null) {
                    Status status = OperationSupport.createStatus(response);
                    logger.error("Exec Failure: HTTP:" + status.getCode() + ". Message:" + status.getMessage(), (Throwable)e);
                    if (!WatchConnectionManager.this.started.get()) {
                        WatchConnectionManager.this.queue.add(new KubernetesClientException(status));
                    }
                } else {
                    logger.error("Exec Failure", (Throwable)e);
                    if (!WatchConnectionManager.this.started.get()) {
                        WatchConnectionManager.this.queue.add(KubernetesClientException.launderThrowable(e));
                    }
                }
                if (response != null && response.body() != null) {
                    response.body().close();
                }
                if (WatchConnectionManager.this.forceClosed.get()) {
                    WatchConnectionManager.this.watcher.onClose(null);
                    return;
                }
                if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                    return;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                }
                catch (InterruptedException e1) {
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                    return;
                }
                this.onClose(4000, "Connection unexpectedly closed");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(ResponseBody message) throws IOException {
                String messageSource = null;
                try {
                    messageSource = message.string();
                    WatchEvent event = (WatchEvent)mapper.readValue(messageSource, WatchEvent.class);
                    if (event.getObject() instanceof HasMetadata) {
                        String newResourceVersion;
                        KubernetesResource obj = event.getObject();
                        String currentResourceVersion = (String)WatchConnectionManager.this.resourceVersion.get();
                        if (currentResourceVersion.compareTo(newResourceVersion = ((HasMetadata)obj).getMetadata().getResourceVersion()) < 0) {
                            WatchConnectionManager.this.resourceVersion.compareAndSet(currentResourceVersion, newResourceVersion);
                        }
                        Watcher.Action action = Watcher.Action.valueOf(event.getType());
                        WatchConnectionManager.this.watcher.eventReceived(action, obj);
                    } else if (event.getObject() instanceof Status) {
                        Status status = (Status)event.getObject();
                        if (status.getCode() == 410) {
                            WatchConnectionManager.this.close();
                            WatchConnectionManager.this.watcher.onClose(new KubernetesClientException(status));
                            return;
                        }
                        logger.error("Error received: {}", (Object)status.toString());
                    }
                }
                catch (IOException e) {
                    logger.error("Could not deserialize watch event: {}", (Object)messageSource, (Object)e);
                }
                catch (ClassCastException e) {
                    logger.error("Received wrong type of object for watch", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Invalid event type", (Throwable)e);
                }
                finally {
                    message.close();
                }
            }

            public void onPong(Buffer buffer) {
                try {
                    if (!buffer.equals((Object)new Buffer().writeUtf8("Alive?"))) {
                        logger.error("Failed to verify pong");
                        this.onClose(4000, "Connection unexpectedly closed");
                    }
                }
                finally {
                    buffer.close();
                }
            }

            public void onClose(final int code, final String reason) {
                if (!WatchConnectionManager.this.pingFuture.isCancelled() && !WatchConnectionManager.this.pingFuture.isDone()) {
                    WatchConnectionManager.this.pingFuture.cancel(true);
                }
                if (WatchConnectionManager.this.forceClosed.get()) {
                    WatchConnectionManager.this.watcher.onClose(null);
                    return;
                }
                try {
                    WebSocket ws = (WebSocket)WatchConnectionManager.this.webSocketRef.get();
                    if (ws != null) {
                        ws.close(0, null);
                        WatchConnectionManager.this.webSocketRef.set(null);
                    }
                }
                catch (IOException e) {
                    logger.warn("Could not properly close websocket", (Throwable)e);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                WatchConnectionManager.this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                WatchConnectionManager.this.queue.clear();
                                WatchConnectionManager.this.runWatch();
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() == null || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof ConnectException)) break block6;
                                if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                                    return;
                                }
                                try {
                                    TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                                }
                                catch (InterruptedException e1) {
                                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                                    return;
                                }
                                this.onClose(code, reason);
                            }
                            catch (InterruptedException | MalformedURLException e) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                        }
                    }
                });
            }
        });
    }

    public void waitUntilReady() {
        try {
            Object obj = this.queue.poll(10L, TimeUnit.SECONDS);
            if (Boolean.TRUE.equals(obj)) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public void close() {
        this.forceClosed.set(true);
        try {
            WebSocket ws = this.webSocketRef.get();
            if (ws != null) {
                ws.close(0, null);
                this.webSocketRef.set(null);
            }
        }
        catch (IOException | IllegalStateException e) {
            logger.warn("Failed to cleanly close websocket", (Throwable)e);
        }
        if (!this.executor.isShutdown()) {
            try {
                this.executor.shutdown();
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (Throwable t) {
                throw KubernetesClientException.launderThrowable(t);
            }
        }
    }
}

