/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist.jclouds;

import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.brooklyn.core.mgmt.persist.PersistenceObjectStore;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.commons.io.Charsets;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.util.Strings2;

public class JcloudsStoreObjectAccessor
implements PersistenceObjectStore.StoreObjectAccessor {
    private final BlobStore blobStore;
    private final String containerName;
    private final String blobName;

    public JcloudsStoreObjectAccessor(BlobStore blobStore, String containerName, String blobNameOptionallyWithPath) {
        this.blobStore = blobStore;
        this.containerName = containerName;
        this.blobName = blobNameOptionallyWithPath;
    }

    public boolean exists() {
        return this.blobStore.blobExists(this.containerName, this.blobName);
    }

    public void put(String val) {
        if (val == null) {
            val = "";
        }
        this.put(ByteSource.wrap((byte[])val.getBytes(Charsets.UTF_8)));
    }

    public void put(ByteSource payload) {
        Blob blob;
        this.blobStore.createContainerInLocation(null, this.containerName);
        try {
            blob = this.blobStore.blobBuilder(this.blobName).payload(payload).contentLength(payload.size()).build();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.blobStore.putBlob(this.containerName, blob);
    }

    public void append(String val) {
        String val0 = this.get();
        if (val0 == null) {
            val0 = "";
        }
        if (val == null) {
            val = "";
        }
        this.put(val0 + val);
    }

    public void delete() {
        this.blobStore.removeBlob(this.containerName, this.blobName);
    }

    public String get() {
        try {
            if (!this.blobStore.blobExists(this.containerName, this.blobName)) {
                return null;
            }
            Blob blob = this.blobStore.getBlob(this.containerName, this.blobName);
            if (blob == null) {
                return null;
            }
            return Strings2.toStringAndClose((InputStream)blob.getPayload().openStream());
        }
        catch (IOException e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Error reading blobstore " + this.containerName + " " + this.blobName + ": " + e, e);
        }
    }

    public byte[] getBytes() {
        try {
            Blob blob = this.blobStore.getBlob(this.containerName, this.blobName);
            if (blob == null) {
                return null;
            }
            return Streams.readFullyAndClose((InputStream)blob.getPayload().openStream());
        }
        catch (IOException e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Error reading blobstore " + this.containerName + " " + this.blobName + ": " + e, e);
        }
    }

    public Date getLastModifiedDate() {
        Blob blob = this.blobStore.getBlob(this.containerName, this.blobName);
        if (blob == null) {
            return null;
        }
        return blob.getMetadata().getLastModified();
    }
}

