/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.bson.ByteBuf;
import org.bson.io.BsonInput;
import org.bson.types.ObjectId;

public class ByteBufferBsonInput
implements BsonInput {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private ByteBuf buffer;
    private int mark = -1;

    public ByteBufferBsonInput(ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can not be null");
        }
        this.buffer = buffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int getPosition() {
        this.ensureOpen();
        return this.buffer.position();
    }

    @Override
    public byte readByte() {
        this.ensureOpen();
        return this.buffer.get();
    }

    @Override
    public void readBytes(byte[] bytes) {
        this.ensureOpen();
        this.buffer.get(bytes);
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int length) {
        this.ensureOpen();
        this.buffer.get(bytes, offset, length);
    }

    @Override
    public long readInt64() {
        this.ensureOpen();
        return this.buffer.getLong();
    }

    @Override
    public double readDouble() {
        this.ensureOpen();
        return this.buffer.getDouble();
    }

    @Override
    public int readInt32() {
        this.ensureOpen();
        return this.buffer.getInt();
    }

    @Override
    public String readString() {
        this.ensureOpen();
        int size = this.readInt32();
        byte[] bytes = new byte[size];
        this.readBytes(bytes);
        return new String(bytes, 0, size - 1, UTF8_CHARSET);
    }

    @Override
    public ObjectId readObjectId() {
        this.ensureOpen();
        byte[] bytes = new byte[12];
        this.readBytes(bytes);
        return new ObjectId(bytes);
    }

    @Override
    public String readCString() {
        this.ensureOpen();
        int mark = this.buffer.position();
        this.readUntilNullByte();
        int size = this.buffer.position() - mark - 1;
        this.buffer.position(mark);
        byte[] bytes = new byte[size];
        this.readBytes(bytes);
        this.readByte();
        return new String(bytes, UTF8_CHARSET);
    }

    private void readUntilNullByte() {
        while (this.buffer.get() != 0) {
        }
    }

    @Override
    public void skipCString() {
        this.ensureOpen();
        this.readUntilNullByte();
    }

    @Override
    public void skip(int numBytes) {
        this.ensureOpen();
        this.buffer.position(this.buffer.position() + numBytes);
    }

    @Override
    public void mark(int readLimit) {
        this.ensureOpen();
        this.mark = this.buffer.position();
    }

    @Override
    public void reset() {
        this.ensureOpen();
        if (this.mark == -1) {
            throw new IllegalStateException("Mark not set");
        }
        this.buffer.position(this.mark);
    }

    @Override
    public boolean hasRemaining() {
        this.ensureOpen();
        return this.buffer.hasRemaining();
    }

    @Override
    public void close() {
        this.buffer.release();
        this.buffer = null;
    }

    private void ensureOpen() {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
    }
}

