/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.config.AzurePredicatesModule;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndNameAndIngressRules;
import org.jclouds.azurecompute.arm.compute.functions.TemplateToAvailabilitySet;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.compute.options.IpOptions;
import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.azurecompute.arm.domain.VirtualNetwork;
import org.jclouds.azurecompute.arm.domain.publicipaddress.PublicIPAddress;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.util.PasswordGenerator;

@Singleton
public class CreateResourcesThenCreateNodes
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final LoadingCache<ResourceGroupAndNameAndIngressRules, String> securityGroupMap;
    private final String defaultVnetAddressPrefix;
    private final String defaultSubnetAddressPrefix;
    private final TemplateToAvailabilitySet templateToAvailabilitySet;
    private final PasswordGenerator.Config passwordGenerator;
    private final AzurePredicatesModule.NetworkAvailablePredicateFactory networkAvailable;

    @Inject
    protected CreateResourcesThenCreateNodes(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, AzureComputeApi api, @Named(value="jclouds.azurecompute.arm.vnet.addressprefix") String defaultVnetAddressPrefix, @Named(value="jclouds.azurecompute.arm.subnet.addressprefix") String defaultSubnetAddressPrefix, LoadingCache<ResourceGroupAndNameAndIngressRules, String> securityGroupMap, TemplateToAvailabilitySet templateToAvailabilitySet, PasswordGenerator.Config passwordGenerator, AzurePredicatesModule.NetworkAvailablePredicateFactory networkAvailable) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.securityGroupMap = securityGroupMap;
        this.defaultVnetAddressPrefix = defaultVnetAddressPrefix;
        this.defaultSubnetAddressPrefix = defaultSubnetAddressPrefix;
        this.templateToAvailabilitySet = templateToAvailabilitySet;
        this.passwordGenerator = passwordGenerator;
        this.networkAvailable = networkAvailable;
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        AzureTemplateOptions options = (AzureTemplateOptions)template.getOptions().as(AzureTemplateOptions.class);
        this.generatePasswordIfNoneProvided(template);
        if (CreateResourcesThenCreateNodes.hasRunScriptWithKeyAuthAndNoPrivateKey(template)) {
            this.logger.warn(">> a runScript was configured but no SSH key has been provided. Authentication will delegate to the ssh-agent", new Object[0]);
        }
        String location = template.getLocation().getId();
        this.createResourceGroupIfNeeded(group, location, options);
        this.normalizeNetworkOptions(options);
        this.createDefaultNetworkIfNeeded(group, location, options);
        this.configureSecurityGroupForOptions(group, template.getLocation(), options);
        this.configureAvailabilitySetForTemplate(template);
        return super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
    }

    private void generatePasswordIfNoneProvided(Template template) {
        TemplateOptions options = template.getOptions();
        if (options.getLoginPassword() == null) {
            Optional passwordOptional = template.getImage().getDefaultCredentials().getOptionalPassword();
            options.overrideLoginPassword((String)passwordOptional.or((Object)this.passwordGenerator.generate()));
        }
    }

    protected synchronized void createDefaultNetworkIfNeeded(String group, String location, AzureTemplateOptions options) {
        if (options.getIpOptions().isEmpty()) {
            String name = this.namingConvention.create().sharedNameForGroup(group);
            Subnet subnet = Subnet.builder().name(name).properties(Subnet.SubnetProperties.builder().addressPrefix(this.defaultSubnetAddressPrefix).build()).build();
            VirtualNetwork.VirtualNetworkProperties properties = VirtualNetwork.VirtualNetworkProperties.builder().addressSpace(AddressSpace.create(Arrays.asList(this.defaultVnetAddressPrefix))).subnets(Arrays.asList(subnet)).build();
            this.logger.debug(">> network options have not been configured. Creating network %s(%s) and subnet %s(%s)", new Object[]{name, this.defaultVnetAddressPrefix, name, this.defaultSubnetAddressPrefix});
            this.api.getVirtualNetworkApi(options.getResourceGroup()).createOrUpdate(name, location, null, properties);
            Preconditions.checkState((boolean)this.networkAvailable.create(options.getResourceGroup()).apply((Object)name), (Object)"Network/Subnet was not created in the configured timeout");
            Subnet createdSubnet = this.api.getSubnetApi(options.getResourceGroup(), name).get(name);
            options.ipOptions(IpOptions.builder().subnet(createdSubnet.id()).allocateNewPublicIp(true).build());
        }
    }

    private static boolean hasRunScriptWithKeyAuthAndNoPrivateKey(Template template) {
        return template.getOptions().getRunScript() != null && template.getOptions().getPublicKey() != null && !template.getOptions().hasLoginPrivateKeyOption();
    }

    private void configureSecurityGroupForOptions(String group, Location location, AzureTemplateOptions options) {
        Preconditions.checkArgument((options.getGroups().size() <= 1 ? 1 : 0) != 0, (Object)"Only one security group can be configured for each network interface");
        if (!options.getGroups().isEmpty()) {
            ResourceGroupAndName securityGroupId = ResourceGroupAndName.fromSlashEncoded((String)Iterables.getOnlyElement((Iterable)options.getGroups()));
            NetworkSecurityGroup securityGroup = this.api.getNetworkSecurityGroupApi(securityGroupId.resourceGroup()).get(securityGroupId.name());
            Preconditions.checkArgument((securityGroup != null ? 1 : 0) != 0, (String)"Security group %s was not found", (Object[])new Object[]{securityGroupId.slashEncode()});
            options.securityGroups(new String[]{securityGroup.id()});
        } else if (options.getInboundPorts().length > 0) {
            String name = this.namingConvention.create().sharedNameForGroup(group);
            ResourceGroupAndNameAndIngressRules regionAndIdAndIngressRules = ResourceGroupAndNameAndIngressRules.create(options.getResourceGroup(), location.getId(), name, options.getInboundPorts());
            String securityGroupId = (String)this.securityGroupMap.getUnchecked((Object)regionAndIdAndIngressRules);
            options.securityGroups(new String[]{securityGroupId});
        }
    }

    private void configureAvailabilitySetForTemplate(Template template) {
        AvailabilitySet availabilitySet = this.templateToAvailabilitySet.apply(template);
        if (availabilitySet != null) {
            this.logger.debug(">> configuring nodes in availability set [%s]", new Object[]{availabilitySet.name()});
            ((AzureTemplateOptions)template.getOptions().as(AzureTemplateOptions.class)).availabilitySet(availabilitySet);
        }
    }

    private void createResourceGroupIfNeeded(String group, String location, AzureTemplateOptions options) {
        if (options.getResourceGroup() == null) {
            options.resourceGroup(group);
        }
        this.logger.debug(">> using resource group [%s]", new Object[]{options.getResourceGroup()});
        ResourceGroup rg = this.api.getResourceGroupApi().get(options.getResourceGroup());
        if (rg == null) {
            this.logger.debug(">> resource group [%s] does not exist. Creating!", new Object[]{options.getResourceGroup()});
            this.api.getResourceGroupApi().create(options.getResourceGroup(), location, (Map<String, String>)ImmutableMap.of((Object)"description", (Object)"jclouds default resource group"));
        }
    }

    @VisibleForTesting
    void normalizeNetworkOptions(AzureTemplateOptions options) {
        if (!options.getNetworks().isEmpty() && !options.getIpOptions().isEmpty()) {
            throw new IllegalArgumentException("The options.networks and options.ipOptions are exclusive");
        }
        if (!options.getNetworks().isEmpty()) {
            ImmutableList.Builder ipOptions = ImmutableList.builder();
            for (String subnetId : options.getNetworks()) {
                ipOptions.add((Object)IpOptions.builder().subnet(subnetId).allocateNewPublicIp(true).build());
            }
            options.ipOptions((Iterable<IpOptions>)ipOptions.build());
        }
        if (!options.getIpOptions().isEmpty()) {
            for (IpOptions ipConfig : options.getIpOptions()) {
                if (ipConfig.allocateNewPublicIp() && ipConfig.publicIpId() != null) {
                    throw new IllegalArgumentException("The allocateNewPublicIps and publicIpId are exclusive");
                }
                String resourceGroup = IdReference.extractResourceGroup(ipConfig.subnet());
                String networkName = Subnet.extractVirtualNetwork(ipConfig.subnet());
                String subnetName = IdReference.extractName(ipConfig.subnet());
                Subnet subnet = this.api.getSubnetApi(resourceGroup, networkName).get(subnetName);
                Preconditions.checkState((subnet != null ? 1 : 0) != 0, (String)"Configured subnet %s does not exist", (Object[])new Object[]{ipConfig.subnet()});
                if (ipConfig.publicIpId() == null) continue;
                PublicIPAddress publicIp = this.api.getPublicIPAddressApi(IdReference.extractResourceGroup(ipConfig.publicIpId())).get(IdReference.extractName(ipConfig.publicIpId()));
                Preconditions.checkState((publicIp != null ? 1 : 0) != 0, (String)"Configured public ip %s does not exist", (Object[])new Object[]{ipConfig.publicIpId()});
            }
        }
    }
}

